/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.common;

import org.gwt.mosaic.ui.client.WindowPanel;
import org.gwt.mosaic.ui.client.Caption;
import org.gwt.mosaic.core.client.Dimension;
import org.jboss.bpm.console.client.util.WindowUtil;
import com.google.gwt.user.client.WindowCloseListener;
import com.google.gwt.user.client.WindowResizeListener;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;

/**
 * General purpose window panel
 * 
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class WidgetWindowPanel
{
  private WindowPanel window;

  public WidgetWindowPanel(String title, final Widget widget)
  {
    window = new WindowPanel(title);
    window.setAnimationEnabled(true);
    //instanceDataWindowPanel.setSize("320px", "240px");

    window.addWindowCloseListener(new WindowCloseListener() {
      public void onWindowClosed() {

      }

      public String onWindowClosing() {
        return null;
      }
    });

    window.addWindowResizeListener(
        new WindowResizeListener() {

          public void onWindowResized(int i, int i1)
          {

          }
        }
    );

    window.setWidget(widget);

    WindowUtil.addMaximizeButton(window, Caption.CaptionRegion.RIGHT);
    WindowUtil.addMinimizeButton(window, Caption.CaptionRegion.RIGHT);


    final int width = Window.getClientWidth()-200;
    final int height = Window.getClientHeight()-100;

    window.setContentSize(
        new Dimension(width,height)
    );

    window.center();
  }

  public void close()
  {
    window.close();  
  }
}
