/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.engine;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.SourcesTabEvents;
import com.google.gwt.user.client.ui.TabListener;
import com.mvc4g.client.Event;
import org.gwt.mosaic.ui.client.DecoratedTabLayoutPanel;
import org.gwt.mosaic.ui.client.TabLayoutPanel;
import org.gwt.mosaic.ui.client.layout.BorderLayout;
import org.gwt.mosaic.ui.client.layout.BorderLayoutData;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.Editor;
import org.jboss.bpm.console.client.LazyPanel;
import org.jboss.bpm.console.client.MenuSection;
import org.jboss.bpm.console.client.common.AbstractView;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;

import java.util.HashMap;
import java.util.Map;

/**
 * Manage runtime aspects of a process engine
 * (currently jbpm only).
 * 
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class EngineEditor extends Editor
{
  public final static String ID = EngineEditor.class.getName();

  private TabLayoutPanel tabPanel;

  private Map<String,Integer> view2index = new HashMap<String,Integer>();

  public EngineEditor(ApplicationContext appContext)
  {
    super(appContext);
  }

  public void initialize()
  {
    if(!isInitialized)
    {

      // create inner tab layout
      tabPanel = new DecoratedTabLayoutPanel();      
      tabPanel.setPadding(5);

      tabPanel.addTabListener(
          new TabListener()
          {
            public boolean onBeforeTabSelected(SourcesTabEvents sourcesTabEvents, int i)
            {
              boolean showTab = true;
              return showTab;
            }

            public void onTabSelected(SourcesTabEvents sourcesTabEvents, int i)
            {
              LazyPanel lazyPanel = (LazyPanel) tabPanel.getWidget(i);
              if(!lazyPanel.isInitialized())
              {
                lazyPanel.initialize();                
                appContext.refreshView(); // TODO: hack around rendering problems
              }

              // load jobs
              if(1==i)
              {
                controller.handleEvent(
                    new Event(UpdateJobsAction.ID, null)
                );
              }
            }
          }
      );

      this.add(tabPanel, new BorderLayoutData(BorderLayout.Region.CENTER));

      // create and register views
      registerView(DeploymentListView.ID, new DeploymentListView());
      registerView(JobListView.ID, new JobListView(appContext));

      // create and register actions
      controller.addAction(UpdateDeploymentsAction.ID, new UpdateDeploymentsAction());
      controller.addAction(UpdateDeploymentDetailAction.ID, new UpdateDeploymentDetailAction());
      controller.addAction(DeleteDeploymentAction.ID, new DeleteDeploymentAction());
      controller.addAction(SuspendDeploymentAction.ID, new SuspendDeploymentAction());
      controller.addAction(ResumeDeploymentAction.ID, new ResumeDeploymentAction());
      controller.addAction(ExecuteJobAction.ID, new ExecuteJobAction());

      // display tab, needs to visible for correct rendering
      tabPanel.selectTab( view2index.get(DeploymentListView.ID ));

      // force loading
      super.controller.handleEvent(
          new Event(UpdateDeploymentsAction.ID, null)
      );

      isInitialized = true;
    }
  }

  private void registerView(String id, AbstractView view)
  {
    view2index.put(id, tabPanel.getWidgetCount());
    
    // register view with controller
    super.controller.addView(id, view);

    // add to tab layout
    this.tabPanel.add(view, view.getIconTitle(), true);
  }

  public String getEditorId()
  {
    return ID;
  }

  public String getTitle()
  {
    return "Runtime";
  }

  public MenuSection provideMenuSection()
  {
    ConsoleIconBundle icons = GWT.create(ConsoleIconBundle.class);

    return new MenuSection(
        getTitle(),
        icons.runtimeIcon(),
        new EngineEditorNavigation(appContext)
    );
  }

  public void showView(String viewId)
  {
    if(viewId!=null)
      tabPanel.selectTab( view2index.get(viewId) );
    else
      tabPanel.selectTab(0);
  }
}
