/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.engine;

import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.TreeListener;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.Workspace;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class EngineEditorNavigation extends Tree
{

  public EngineEditorNavigation(final ApplicationContext appContext)
  {
    super.setTitle("Deployments");

    TreeItem jbpmDeployments = addItem("Deployments");
    TreeItem jobs = addItem("Jobs");

    addTreeListener(
        new TreeListener()
        {
          public void onTreeItemSelected(TreeItem treeItem)
          {
            Workspace workspace = appContext.getWorkpace();

            if("Deployments".equals(treeItem.getText()))
            {
              workspace.showEditor(EngineEditor.ID, DeploymentListView.ID);
            }
            else if("Jobs".equals(treeItem.getText()))
            {
              workspace.showEditor(EngineEditor.ID, JobListView.ID);
            }
          }

          public void onTreeItemStateChanged(TreeItem treeItem)
          {

          }
        }
    );
  }
}
