/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.icons;

import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.ImageBundle;

public interface ConsoleIconBundle extends ImageBundle
{
  /**
   * @gwt.resource processIcon.png
   */
  AbstractImagePrototype processIcon();

  /**
   * @gwt.resource play.png
   */
  AbstractImagePrototype instanceIcon();

  /**
   * Would bundle the file 'open-file-icon.gif' residing in the same package as this type.
   * @gwt.resource open-file-icon.gif

  AbstractImagePrototype openFileIcon();

  /**
   * Would bundle the file 'savefile.gif' residing in the package 'org.example.icons'.
   * @gwt.resource org/example/icons/savefile.gif

  AbstractImagePrototype saveFileIcon();
  */

  /**
   * @gwt.resource toolsIcon.png
   */
  AbstractImagePrototype settingsIcon();

  /**
   * @gwt.resource taskIcon.png
   */
  AbstractImagePrototype taskIcon();

   /**
   * @gwt.resource userIcon.png
   */
  AbstractImagePrototype userIcon();

   /**
   * @gwt.resource tool-button-collapse-down.png
   */
  AbstractImagePrototype collapseDownIcon();

   /**
   * @gwt.resource tool-button-collapse-left.png
   */
  AbstractImagePrototype collapseLeftIcon();

  /**
   * @gwt.resource errorIcon.png
   */
  AbstractImagePrototype errorIcon();

  /**
   * @gwt.resource dialog-information.png
   */
  AbstractImagePrototype infoIcon();

  /**
   * @gwt.resource dialog-warning.png
   */
  AbstractImagePrototype warnIcon();

   /**
   * @gwt.resource dialog-question.png
   */
  AbstractImagePrototype questionIcon();

  /**
   * @gwt.resource loading.gif
   */
  AbstractImagePrototype loadingIcon();

  /**
   * @gwt.resource reload.png
   */
  AbstractImagePrototype reloadIcon();

  /**
   * @gwt.resource reload_small.png
   */
  AbstractImagePrototype reloadSmallIcon();

  /**
   * @gwt.resource report.png
   */
  AbstractImagePrototype reportIcon();

  /**
   * @gwt.resource runtime.png
   */
  AbstractImagePrototype runtimeIcon();

  /**
   * @gwt.resource deployment.png
   */
  AbstractImagePrototype deploymentIcon();

   /**
   * @gwt.resource jobs.png
   */
  AbstractImagePrototype jobsIcon();

  /**
   * @gwt.resource ws.png
   */
  AbstractImagePrototype webserviceIcon();

  /**
   * @gwt.resource arrow_blue.png
   */
  AbstractImagePrototype arrowIcon();

  /**
   * @gwt.resource piece.png
   */
  AbstractImagePrototype pieceIcon();

   /**
   * @gwt.resource reportInstance.png
   */
  AbstractImagePrototype reportInstanceIcon();
}
