/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.Response;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONValue;
import com.mvc4g.client.Controller;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.URLBuilder;
import org.jboss.bpm.console.client.common.AbstractRESTAction;
import org.jboss.bpm.console.client.model.ActiveNodeInfo;
import org.jboss.bpm.console.client.model.DiagramNodeInfo;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.process.events.ActivityDiagramResultEvent;
import org.jboss.bpm.console.client.util.ConsoleLog;
import org.jboss.bpm.console.client.util.JSONWalk;
import org.jboss.bpm.console.client.util.JSONWalk.JSONWrapper;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class LoadActivityDiagramAction extends AbstractRESTAction
{
  public final static String ID = LoadActivityDiagramAction.class.getName();

  public String getId()
  {
    return ID;
  }

  public String getUrl(Object event)
  {
    ProcessInstanceRef inst = (ProcessInstanceRef)event;
    return URLBuilder.getInstance().getActiveNodeInfoURL(inst.getId());
  }

  public RequestBuilder.Method getRequestMethod()
  {
    return RequestBuilder.GET;
  }

  public void handleSuccessfulResponse(
      final Controller controller, final Object event, Response response)
  {
    ProcessInstanceRef inst = (ProcessInstanceRef)event;

    ConsoleLog.debug("Parse: " + response.getText());

    //TODO: move to DTO Parser
    JSONValue root = JSONParser.parse(response.getText());
    //int diagramWidth = JSONWalk.on(root).next("diagramWidth").asInt();
    //int diagramHeight = JSONWalk.on(root).next("diagramHeight").asInt();

    if (root instanceof JSONArray) {
    	JSONArray array = (JSONArray) root;
    	List<ActiveNodeInfo> activeNodeInfos = new ArrayList<ActiveNodeInfo>();
	    for (int i = 0; i < array.size(); i++) {
	    	JSONWalk walk = JSONWalk.on(array.get(i));
		    JSONWrapper wrapper = walk.next("activeNode");
		    JSONObject activeNode = wrapper.asObject();
		
		    int x = JSONWalk.on(activeNode).next("x").asInt();
		    int y = JSONWalk.on(activeNode).next("y").asInt();
		
		    int width = JSONWalk.on(activeNode).next("width").asInt();
		    int height = JSONWalk.on(activeNode).next("height").asInt();
		    String name = JSONWalk.on(activeNode).next("name").asString();
						
		    activeNodeInfos.add(
		        new ActiveNodeInfo(
		            -1, -1,
		            new DiagramNodeInfo(name, x, y, width, height)
		        )
	        );
		    wrapper = walk.next("activeNode");
	    }
	
	    // update view
	    ActivityDiagramView view = (ActivityDiagramView) controller.getView(ActivityDiagramView.ID);
	    view.update(
	        new ActivityDiagramResultEvent(
	            URLBuilder.getInstance().getProcessImageURL(inst.getDefinitionId()),
	            activeNodeInfos
	        )
	    );
    }
  }
}
