/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.report;

import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.jboss.bpm.console.client.LazyPanel;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Frame;

import java.util.Date;

/**
 * Embeds an HTML report.
 *  
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class ReportFrame extends LayoutPanel implements LazyPanel
{

  private Frame frame;
  private String url;
  private boolean isInitialized;

  public ReportFrame(String url)
  {
    super();    
    setPadding(0);
    this.url = url;
    
    // report frame
    frame = new Frame();
    DOM.setStyleAttribute(frame.getElement(), "border", "none");
    this.add(frame);
  }

  public String getUrl()
  {
    return url;
  }

  public boolean isInitialized()
  {
    return isInitialized;
  }
                                                   
  public void initialize()
  {
    if(!isInitialized)
    {
      setFrameUrl(url);
      isInitialized = true;
    }
  }

  private void setFrameUrl(String url)
  {
    // https://jira.jboss.org/jira/browse/JBPM-2244
    frame.getElement().setId(
        String.valueOf( new Date().getTime())
    );

    frame.setUrl(url);
  }


}
