/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.sam;

import org.gwt.mosaic.ui.client.Label;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.jboss.bpm.console.client.Editor;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.MenuSection;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class SAMEditor extends Editor
{
  public final static String ID = SAMEditor.class.getName();

  private boolean initialized;

  public SAMEditor(ApplicationContext appContext)
  {
    super(appContext);
  }

  public void initialize()
  {
    if(!initialized)
    {
      LayoutPanel layout = new LayoutPanel();
      layout.add(new Label("Hello form SAM"));

      this.add(layout);
      
      initialized = true;
    }
  }

  public String getEditorId()
  {
    return ID;
  }

  public String getTitle()
  {
    return "Overview";
  }

  public MenuSection provideMenuSection()
  {
    //ConsoleIconBundle icons = GWT.create(ConsoleIconBundle.class);

    return new MenuSection(
        "Activity Monitor",
        null,
        new SAMEditorNavigation(appContext)
    );
  }
}
