/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.ViewInterface;
import org.gwt.mosaic.ui.client.CaptionLayoutPanel;
import org.gwt.mosaic.ui.client.DeckLayoutPanel;
import org.gwt.mosaic.ui.client.DecoratedTabLayoutPanel;
import org.gwt.mosaic.ui.client.HTML;
import org.gwt.mosaic.ui.client.Label;
import org.gwt.mosaic.ui.client.TabLayoutPanel;
import org.gwt.mosaic.ui.client.layout.BorderLayout;
import org.gwt.mosaic.ui.client.layout.BorderLayoutData;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.Editor;
import org.jboss.bpm.console.client.MenuSection;
import org.jboss.bpm.console.client.PreferencesView;
import org.jboss.bpm.console.client.ServerStatusView;
import org.jboss.bpm.console.client.SettingsEditorNavigation;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;

public class SettingsEditor
extends Editor {
    public static final String ID = SettingsEditor.class.getName();
    private TabLayoutPanel tabPanel;
    private DeckLayoutPanel deck;

    public SettingsEditor(ApplicationContext appContext) {
        super(appContext);
    }

    public void initialize() {
        if (!this.isInitialized()) {
            this.tabPanel = new DecoratedTabLayoutPanel();
            this.tabPanel.setPadding(5);
            this.deck = new DeckLayoutPanel();
            this.deck.add((Widget)this.createSystemPanel());
            this.deck.add((Widget)this.createPrefPanel());
            this.tabPanel.add((Widget)this.deck, "Settings");
            this.add((Widget)this.tabPanel, (LayoutData)new BorderLayoutData(BorderLayout.Region.CENTER));
            this.appContext.refreshView();
            this.isInitialized = true;
        }
    }

    public void showView(String viewId) {
        if (viewId == null || viewId.equals("system")) {
            this.deck.showWidget(0);
        } else if (viewId.equals("preferences")) {
            this.deck.showWidget(1);
        } else {
            throw new IllegalArgumentException("Unknown viewId: " + viewId);
        }
        this.layout();
    }

    private CaptionLayoutPanel createPrefPanel() {
        PreferencesView prefView = new PreferencesView();
        this.controller.addView(PreferencesView.ID, (ViewInterface)prefView);
        return prefView;
    }

    private CaptionLayoutPanel createSystemPanel() {
        CaptionLayoutPanel captionPanel = new CaptionLayoutPanel("System Settings");
        LayoutPanel layoutPanel = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        Label console = new Label("Console Info");
        layoutPanel.add((Widget)console, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        Grid g1 = new Grid(1, 2);
        g1.setWidget(0, 0, (Widget)new HTML("Version:"));
        g1.setWidget(0, 1, (Widget)new HTML("1.3.0"));
        g1.getColumnFormatter().setWidth(0, "20%");
        layoutPanel.add((Widget)g1, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        Label server = new Label("Server Info");
        layoutPanel.add((Widget)server, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        ServerStatusView serverStatus = new ServerStatusView(this.appContext);
        serverStatus.initialize();
        Grid g2 = new Grid(1, 2);
        g2.setWidget(0, 0, (Widget)new HTML("Host:"));
        g2.setWidget(0, 1, (Widget)new HTML(this.appContext.getConfig().getConsoleServerUrl()));
        g2.getColumnFormatter().setWidth(0, "20%");
        layoutPanel.add((Widget)g2, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        LayoutPanel pluginPanel = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        pluginPanel.setPadding(0);
        Label label = new Label("Plugins:");
        pluginPanel.add((Widget)label);
        pluginPanel.add((Widget)serverStatus);
        layoutPanel.add((Widget)pluginPanel, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        this.controller.addView(ServerStatusView.ID, (ViewInterface)serverStatus);
        captionPanel.add((Widget)layoutPanel);
        return captionPanel;
    }

    public String getEditorId() {
        return ID;
    }

    public String getTitle() {
        return "Settings";
    }

    public MenuSection provideMenuSection() {
        ConsoleIconBundle icons = (ConsoleIconBundle)GWT.create(ConsoleIconBundle.class);
        return new MenuSection(this.getTitle(), icons.settingsIcon(), (Tree)new SettingsEditorNavigation(this.appContext));
    }
}

