/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.URL;
import org.jboss.bpm.console.client.ConsoleConfig;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.model.TokenReference;

public class URLBuilder {
    private static ConsoleConfig config;
    private static URLBuilder instance;

    public static void configureInstance(ConsoleConfig config) {
        instance = new URLBuilder(config);
    }

    public static URLBuilder getInstance() {
        if (null == instance) {
            throw new IllegalArgumentException("UrlBuilder not configured");
        }
        return instance;
    }

    private URLBuilder(ConsoleConfig config) {
        URLBuilder.config = config;
    }

    public String getProcessDefinitionsURL() {
        return config.getConsoleServerUrl() + "/rs/process/definitions";
    }

    public String getProcessInstancesURL(String processId) {
        String encodedId = URL.encode((String)processId);
        return config.getConsoleServerUrl() + "/rs/process/definition/" + encodedId + "/instances";
    }

    public String getUserInRoleURL(String[] possibleRoles) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < possibleRoles.length; ++i) {
            sb.append(URL.encode((String)possibleRoles[i]));
            if (i >= possibleRoles.length - 1) continue;
            sb.append(",");
        }
        return config.getConsoleServerUrl() + "/rs/identity/user/roles?roleCheck=" + sb.toString();
    }

    public String getServerStatusURL() {
        return config.getConsoleServerUrl() + "/rs/server/status";
    }

    @Deprecated
    public String getRemoveDefinitionURL(String processId) {
        String encodedId = URL.encode((String)processId);
        return config.getConsoleServerUrl() + "/rs/process/definition/" + encodedId + "/remove";
    }

    public String getProcessImageURL(String processId) {
        String encodedId = URL.encode((String)processId);
        return config.getConsoleServerUrl() + "/rs/process/definition/" + encodedId + "/image";
    }

    public String getActiveNodeInfoURL(String instanceId) {
        return config.getConsoleServerUrl() + "/rs/process/instance/" + instanceId + "/activeNodeInfo";
    }

    public String getStateChangeURL(String instanceId, ProcessInstanceRef.STATE state) {
        return config.getConsoleServerUrl() + "/rs/process/instance/" + instanceId + "/state/" + state;
    }

    public String getInstanceEndURL(String instanceId, ProcessInstanceRef.RESULT result) {
        return config.getConsoleServerUrl() + "/rs/process/instance/" + instanceId + "/end/" + result;
    }

    public String getInstanceDeleteURL(String instanceId) {
        return config.getConsoleServerUrl() + "/rs/process/instance/" + instanceId + "/delete";
    }

    public String getInstanceDataURL(String instanceId) {
        return config.getConsoleServerUrl() + "/rs/process/instance/" + instanceId + "/dataset";
    }

    public String getStartNewInstanceURL(String processId) {
        String encodedID = URL.encode((String)processId);
        return config.getConsoleServerUrl() + "/rs/process/definition/" + encodedID + "/new_instance";
    }

    public String getTaskListURL(String idRef) {
        return config.getConsoleServerUrl() + "/rs/tasks/" + URL.encode((String)idRef);
    }

    public String getParticipationTaskListURL(String idRef) {
        return config.getConsoleServerUrl() + "/rs/tasks/" + URL.encode((String)idRef) + "/participation";
    }

    public String getTaskReleaseURL(long id) {
        return config.getConsoleServerUrl() + "/rs/task/" + id + "/release";
    }

    public String getTaskCompleteURL(long id) {
        return config.getConsoleServerUrl() + "/rs/task/" + id + "/close";
    }

    public String getTaskCompleteURL(long id, String outcome) {
        return config.getConsoleServerUrl() + "/rs/task/" + id + "/close/" + URL.encode((String)outcome);
    }

    public String getTaskAssignURL(long id, String idRef) {
        return config.getConsoleServerUrl() + "/rs/task/" + id + "/assign/" + URL.encode((String)idRef);
    }

    public String getExecutionSignalUrl(TokenReference tok) {
        return config.getConsoleServerUrl() + "/rs/process/tokens/" + tok.getId() + "/transition/default";
    }

    public String getExecutionSignalUrl(TokenReference tok, String signal) {
        String encodedSignal = URL.encode((String)signal);
        return config.getConsoleServerUrl() + "/rs/process/tokens/" + tok.getId() + "/transition?signal=" + encodedSignal;
    }

    public String getAvailableActorsUrl(String actorId) {
        return config.getConsoleServerUrl() + "/rs/identity/user/" + actorId + "/actors";
    }

    public String getDeployTestHarnessUrl() {
        return config.getConsoleServerUrl() + "/rs/test/deploy/harness";
    }

    public String getUndeployTestHarnessUrl() {
        return config.getConsoleServerUrl() + "/rs/test/undeploy/harness";
    }

    public String getReportURL(String templateName) {
        String reportFileName = URL.encode((String)templateName);
        String url = config.getConsoleServerUrl() + "/rs/report/render/" + reportFileName;
        if (!GWT.isScript()) {
            url = url + "?id=birt";
        }
        return url;
    }

    public String getDeploymentsUrl() {
        return config.getConsoleServerUrl() + "/rs/engine/deployments";
    }

    public String getSuspendDeploymentUrl(String id) {
        String encodedId = URL.encode((String)id);
        return config.getConsoleServerUrl() + "/rs/engine/deployment/" + encodedId + "/suspend";
    }

    public String getResumeDeploymentUrl(String id) {
        String encodedId = URL.encode((String)id);
        return config.getConsoleServerUrl() + "/rs/engine/deployment/" + encodedId + "/resume";
    }

    public String getDeleteDeploymentUrl(String id) {
        String encodedId = URL.encode((String)id);
        return config.getConsoleServerUrl() + "/rs/engine/deployment/" + encodedId + "/delete";
    }

    public String getJobsUrl() {
        return config.getConsoleServerUrl() + "/rs/engine/jobs";
    }

    public String getExecuteJobURL(String id) {
        String encodedId = URL.encode((String)id);
        return config.getConsoleServerUrl() + "/rs/engine/job/" + encodedId + "/execute";
    }

    static {
        instance = null;
    }
}

