/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.common;

import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import org.gwt.mosaic.ui.client.Label;
import org.gwt.mosaic.ui.client.ScrollLayoutPanel;

public class PropertyGrid
extends ScrollLayoutPanel {
    private String[] fieldNames;
    private Grid grid;

    public PropertyGrid(String[] fieldDesc) {
        this.grid = new Grid(fieldDesc.length, 2);
        this.grid.setStyleName("bpm-prop-grid");
        this.fieldNames = fieldDesc;
        this.add((Widget)this.grid);
        this.initReset();
    }

    private void initReset() {
        for (int i = 0; i < this.fieldNames.length; ++i) {
            Label label = new Label(this.fieldNames[i]);
            label.setStyleName("bpm-prop-grid-label");
            this.grid.setWidget(i, 0, (Widget)label);
            this.grid.setWidget(i, 1, (Widget)new HTML(""));
            String style = i % 2 == 0 ? "bpm-prop-grid-even" : "bpm-prop-grid-odd";
            this.grid.getRowFormatter().setStyleName(i, style);
            this.grid.getColumnFormatter().setWidth(0, "20%");
            this.grid.getColumnFormatter().setWidth(1, "80%");
        }
    }

    public void clear() {
        this.initReset();
    }

    public void update(String[] fieldValues) {
        if (fieldValues.length != this.fieldNames.length) {
            throw new IllegalArgumentException("fieldValues.length doesn't match fieldName.length: " + this.fieldNames);
        }
        for (int i = 0; i < this.fieldNames.length; ++i) {
            Label label = new Label(this.fieldNames[i]);
            label.setStyleName("bpm-prop-grid-label");
            this.grid.setWidget(i, 0, (Widget)label);
            this.grid.setWidget(i, 1, (Widget)new HTML(fieldValues[i]));
        }
    }
}

