/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.model;

import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jboss.bpm.console.client.model.DeploymentRef;
import org.jboss.bpm.console.client.model.JobRef;
import org.jboss.bpm.console.client.model.ParticipantRef;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.model.TaskRef;
import org.jboss.bpm.console.client.model.TokenReference;
import org.jboss.bpm.console.client.util.ConsoleLog;
import org.jboss.bpm.console.client.util.JSONWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class DTOParser {
    public static List<TaskRef> parseTaskReferenceList(String json) {
        ConsoleLog.debug((String)("parse " + json));
        ArrayList<TaskRef> results = new ArrayList<TaskRef>();
        JSONValue root = JSONParser.parse((String)json);
        JSONArray array = JSONWalk.on((JSONValue)root).next("tasks").asArray();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject item = array.get(i).isObject();
            TaskRef ref = DTOParser.parseTaskReference((JSONObject)item);
            results.add(ref);
        }
        return results;
    }

    public static TaskRef parseTaskReference(JSONObject item) {
        JSONWalk.JSONWrapper createDate;
        ConsoleLog.debug((String)("parse " + item));
        long id = JSONWalk.on((JSONValue)item).next("id").asLong();
        JSONWalk.JSONWrapper instanceIdWrapper = JSONWalk.on((JSONValue)item).next("processInstanceId");
        String executionId = instanceIdWrapper != null ? instanceIdWrapper.asString() : "n/a";
        JSONWalk.JSONWrapper processIdWrapper = JSONWalk.on((JSONValue)item).next("processId");
        String processId = processIdWrapper != null ? processIdWrapper.asString() : "n/a";
        String name = JSONWalk.on((JSONValue)item).next("name").asString();
        String assignee = JSONWalk.on((JSONValue)item).next("assignee").asString();
        boolean isBlocking = JSONWalk.on((JSONValue)item).next("isBlocking").asBool();
        boolean isSignalling = JSONWalk.on((JSONValue)item).next("isSignalling").asBool();
        TaskRef ref = new TaskRef(id, executionId, processId, name, assignee, isSignalling, isBlocking);
        JSONWalk.JSONWrapper jsonWrapper = JSONWalk.on((JSONValue)item).next("url");
        if (jsonWrapper != null) {
            String url = jsonWrapper.asString();
            ref.setUrl(url);
        } else {
            ref.setUrl("");
        }
        JSONArray arrUsers = JSONWalk.on((JSONValue)item).next("participantUsers").asArray();
        for (int k = 0; k < arrUsers.size(); ++k) {
            JSONValue jsonValue = arrUsers.get(k);
            ParticipantRef p = DTOParser.parseParticipant((JSONValue)jsonValue, (int)k);
            ref.getParticipantUsers().add(p);
        }
        JSONArray arrGroups = JSONWalk.on((JSONValue)item).next("participantGroups").asArray();
        for (int k = 0; k < arrGroups.size(); ++k) {
            JSONValue jsonValue = arrGroups.get(k);
            ParticipantRef p = DTOParser.parseParticipant((JSONValue)jsonValue, (int)k);
            ref.getParticipantGroups().add(p);
        }
        if (isSignalling) {
            JSONArray arr = JSONWalk.on((JSONValue)item).next("outcomes").asArray();
            for (int k = 0; k < arr.size(); ++k) {
                JSONValue jsonValue = arr.get(k);
                if (jsonValue.toString().equals("null")) {
                    ConsoleLog.warn((String)("FIXME JBPM-1828: Null value on outcomes:" + arr.toString()));
                    continue;
                }
                JSONString t = jsonValue.isString();
                ref.getOutcomes().add(t.stringValue());
            }
        }
        int prio = JSONWalk.on((JSONValue)item).next("priority").asInt();
        ref.setPriority(prio);
        JSONWalk.JSONWrapper dueDate = JSONWalk.on((JSONValue)item).next("dueDate");
        if (dueDate != null) {
            Date due = dueDate.asDate();
            ref.setDueDate(due);
        }
        if ((createDate = JSONWalk.on((JSONValue)item).next("createDate")) != null) {
            Date due = createDate.asDate();
            ref.setDueDate(due);
        }
        return ref;
    }

    private static ParticipantRef parseParticipant(JSONValue jsonValue, int k) {
        String type = JSONWalk.on((JSONValue)jsonValue).next("type").asString();
        String idRef = JSONWalk.on((JSONValue)jsonValue).next("idRef").asString();
        ParticipantRef p = new ParticipantRef(type, idRef);
        boolean isGroup = JSONWalk.on((JSONValue)jsonValue).next("isGroup").asBool();
        p.setGroup(isGroup);
        return p;
    }

    public static List<ProcessInstanceRef> parseProcessInstances(JSONValue jso) {
        ArrayList<ProcessInstanceRef> results = new ArrayList<ProcessInstanceRef>();
        JSONArray arr = JSONWalk.on((JSONValue)jso).next("instances").asArray();
        for (int i = 0; i < arr.size(); ++i) {
            results.add(DTOParser.parseProcessInstance((JSONValue)arr.get(i)));
        }
        return results;
    }

    public static ProcessInstanceRef parseProcessInstance(JSONValue root) {
        ConsoleLog.debug((String)("parse " + root));
        String id = JSONWalk.on((JSONValue)root).next("id").asString();
        String definitionId = JSONWalk.on((JSONValue)root).next("definitionId").asString();
        Date start = JSONWalk.on((JSONValue)root).next("startDate").asDate();
        JSONWalk.JSONWrapper endDateJSON = JSONWalk.on((JSONValue)root).next("endDate");
        Date end = null;
        if (endDateJSON != null) {
            end = endDateJSON.asDate();
        }
        boolean suspended = JSONWalk.on((JSONValue)root).next("suspended").asBool();
        ProcessInstanceRef processInstance = new ProcessInstanceRef(id, definitionId, start, end, suspended);
        JSONWalk.JSONWrapper rootTokenJSON = JSONWalk.on((JSONValue)root).next("rootToken");
        if (rootTokenJSON != null) {
            JSONObject tokJso = rootTokenJSON.asObject();
            TokenReference rootToken = DTOParser.parseTokenReference((JSONObject)tokJso);
            processInstance.setRootToken(rootToken);
        }
        return processInstance;
    }

    public static TokenReference parseTokenReference(JSONObject jso) {
        JSONString item;
        ConsoleLog.debug((String)("parse " + jso));
        String rootTokenId = JSONWalk.on((JSONValue)jso).next("id").asString();
        JSONWalk.JSONWrapper nodeNameWrapper = JSONWalk.on((JSONValue)jso).next("currentNodeName");
        String nodeName = nodeNameWrapper != null ? nodeNameWrapper.asString() : "";
        TokenReference rt = new TokenReference(rootTokenId, "", nodeName);
        boolean canBeSignaled = JSONWalk.on((JSONValue)jso).next("canBeSignaled").asBool();
        rt.setCanBeSignaled(canBeSignaled);
        JSONArray signals = JSONWalk.on((JSONValue)jso).next("availableSignals").asArray();
        for (int i = 0; i < signals.size(); ++i) {
            JSONValue jsonValue = signals.get(i);
            if (jsonValue.toString().equals("null")) {
                ConsoleLog.warn((String)("FIXME JBPM-1828: Null value on availableSignals:" + signals.toString()));
                continue;
            }
            item = jsonValue.isString();
            rt.getAvailableSignals().add(item.stringValue());
        }
        JSONArray childArr = JSONWalk.on((JSONValue)jso).next("children").asArray();
        for (int i = 0; i < childArr.size(); ++i) {
            item = childArr.get(i).isObject();
            rt.getChildren().add(DTOParser.parseTokenReference((JSONObject)item));
        }
        return rt;
    }

    public static List<String> parseStringArray(JSONValue jso) {
        ArrayList<String> result = new ArrayList<String>();
        JSONArray jsonArray = jso.isArray();
        if (null == jsonArray) {
            throw new IllegalArgumentException("Not an array: " + jso);
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONValue jsonValue = jsonArray.get(i);
            if (jsonValue.toString().equals("null")) {
                ConsoleLog.warn((String)("FIXME JBPM-1828: Null value on string array:" + jsonArray.toString()));
                continue;
            }
            JSONString item = jsonValue.isString();
            result.add(item.stringValue());
        }
        return result;
    }

    public static List<DeploymentRef> parseDeploymentRefList(JSONValue json) {
        ConsoleLog.debug((String)("parse " + json));
        ArrayList<DeploymentRef> result = new ArrayList<DeploymentRef>();
        JSONArray jsonArray = JSONWalk.on((JSONValue)json).next("deployments").asArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONValue item = jsonArray.get(i);
            String id = JSONWalk.on((JSONValue)item).next("id").asString();
            boolean suspended = JSONWalk.on((JSONValue)item).next("suspended").asBool();
            String name = JSONWalk.on((JSONValue)item).next("name").asString();
            long ts = JSONWalk.on((JSONValue)item).next("timestamp").asLong();
            DeploymentRef ref = new DeploymentRef(id, suspended);
            ref.setName(name);
            ref.setTimestamp(ts);
            JSONArray defArr = JSONWalk.on((JSONValue)item).next("definitions").asArray();
            for (int c = 0; c < defArr.size(); ++c) {
                String defId = defArr.get(c).isString().stringValue();
                ref.getDefinitions().add(defId);
            }
            JSONArray resArr = JSONWalk.on((JSONValue)item).next("resourceNames").asArray();
            for (int c = 0; c < resArr.size(); ++c) {
                String resourceName = resArr.get(c).isString().stringValue();
                ref.getResourceNames().add(resourceName);
            }
            result.add(ref);
        }
        return result;
    }

    public static List<JobRef> parseJobRefList(JSONValue json) {
        ConsoleLog.debug((String)("parse " + json));
        ArrayList<JobRef> result = new ArrayList<JobRef>();
        JSONArray jsonArray = JSONWalk.on((JSONValue)json).next("jobs").asArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONWalk.JSONWrapper err;
            JSONValue item = jsonArray.get(i);
            String id = JSONWalk.on((JSONValue)item).next("id").asString();
            String type = JSONWalk.on((JSONValue)item).next("type").asString();
            JobRef ref = new JobRef();
            ref.setId(id);
            ref.setType(type);
            JSONWalk.JSONWrapper tsEl = JSONWalk.on((JSONValue)item).next("timestamp");
            if (tsEl != null) {
                ref.setTimestamp(tsEl.asLong());
            }
            if ((err = JSONWalk.on((JSONValue)item).next("errMsg")) != null) {
                ref.setErrMsg(err.asString());
            }
            result.add(ref);
        }
        return result;
    }
}

