/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.model;

import com.google.gwt.core.client.JsArray;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jboss.bpm.console.client.model.JSOModel;
import org.jboss.bpm.console.client.model.PluginInfo;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.model.ServerStatus;
import org.jboss.bpm.report.model.ReportParameter;
import org.jboss.bpm.report.model.ReportReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class JSOParser {
    public static List<ProcessDefinitionRef> parseProcessDefinitions(String json) {
        ArrayList<ProcessDefinitionRef> results = new ArrayList<ProcessDefinitionRef>();
        JSOModel rootModel = JSOModel.fromJson((String)json);
        JsArray definitions = rootModel.getArray("definitions");
        for (int i = 0; i < definitions.length(); ++i) {
            JSOModel def = (JSOModel)definitions.get(i);
            results.add(JSOParser.parseProcessDefinition((JSOModel)def));
        }
        return results;
    }

    public static ProcessDefinitionRef parseProcessDefinition(JSOModel rootModel) {
        ProcessDefinitionRef def = new ProcessDefinitionRef();
        def.setId(rootModel.get("id"));
        def.setName(rootModel.get("name"));
        def.setVersion(rootModel.getLong("version"));
        def.setKey(rootModel.get("key"));
        def.setDeploymentId(rootModel.get("deploymentId"));
        def.setSuspended(rootModel.getBoolean("suspended"));
        def.setPackageName(rootModel.get("packageName", ""));
        def.setFormUrl(rootModel.get("formUrl", null));
        def.setDiagramUrl(rootModel.get("diagramUrl", null));
        return def;
    }

    public static List<ProcessInstanceRef> parseProcessInstances(String json) {
        System.out.println(json);
        ArrayList<ProcessInstanceRef> results = new ArrayList<ProcessInstanceRef>();
        JSOModel rootModel = JSOModel.fromJson((String)json);
        JsArray instances = rootModel.getArray("instances");
        for (int i = 0; i < instances.length(); ++i) {
            results.add(JSOParser.parseProcessInstance((JSOModel)((JSOModel)instances.get(i))));
        }
        return results;
    }

    public static ProcessInstanceRef parseProcessInstance(JSOModel root) {
        String id = root.get("id");
        String definitionId = root.get("definitionId");
        Date start = root.getDate("startDate");
        Date end = root.getDate("endDate", null);
        boolean suspended = root.getBoolean("suspended");
        ProcessInstanceRef processInstance = new ProcessInstanceRef(id, definitionId, start, end, suspended);
        return processInstance;
    }

    public static List<ReportReference> parseReportConfig(String json) {
        ArrayList<ReportReference> results = new ArrayList<ReportReference>();
        JsArray rootModel = JSOModel.arrayFromJson((String)json);
        for (int i = 0; i < rootModel.length(); ++i) {
            JSOModel reportCfg = (JSOModel)rootModel.get(i);
            String title = reportCfg.get("title");
            String description = reportCfg.get("description", "");
            String reportFile = reportCfg.get("reportFileName");
            ReportReference reportRef = new ReportReference(reportFile);
            reportRef.setTitle(title);
            reportRef.setDescription(description);
            JsArray params = reportCfg.getArray("parameterMetaData");
            for (int x = 0; x < params.length(); ++x) {
                JSOModel p = (JSOModel)params.get(x);
                String name = p.get("name");
                String type = p.get("type");
                String dataType = p.get("dataType");
                ReportParameter pmd = new ReportParameter(name, ReportParameter.Type.valueOf((String)type));
                pmd.setDataType(ReportParameter.DataType.valueOf((String)dataType));
                pmd.setHelptext(p.get("helptext", ""));
                pmd.setPromptText(p.get("promptText", ""));
                reportRef.getParameterMetaData().add(pmd);
            }
            results.add(reportRef);
        }
        return results;
    }

    public static ServerStatus parseStatus(String json) {
        ServerStatus status = new ServerStatus();
        JSOModel rootModel = JSOModel.fromJson((String)json);
        JsArray plugins = rootModel.getArray("plugins");
        for (int i = 0; i < plugins.length(); ++i) {
            JSOModel item = (JSOModel)plugins.get(i);
            String type = item.get("type");
            boolean avail = item.getBoolean("available");
            status.getPlugins().add(new PluginInfo(type, avail));
        }
        return status;
    }
}

