/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.List;
import org.gwt.mosaic.ui.client.ListBox;
import org.gwt.mosaic.ui.client.ToolBar;
import org.gwt.mosaic.ui.client.layout.BorderLayout;
import org.gwt.mosaic.ui.client.layout.BorderLayoutData;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.gwt.mosaic.ui.client.list.DefaultListModel;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.common.AbstractView;
import org.jboss.bpm.console.client.common.IFrameWindowPanel;
import org.jboss.bpm.console.client.common.PagingCallback;
import org.jboss.bpm.console.client.common.PagingPanel;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.process.InstanceDetailView;
import org.jboss.bpm.console.client.process.UpdateInstanceDetailAction;
import org.jboss.bpm.console.client.process.events.InstanceEvent;
import org.jboss.bpm.console.client.util.SimpleDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InstanceListView
extends AbstractView {
    public static final String ID = InstanceListView.class.getName();
    private Controller controller;
    private LayoutPanel instanceList = null;
    private ListBox<ProcessInstanceRef> listBox;
    private ProcessDefinitionRef currentDefinition;
    private boolean isInitialized;
    private List<ProcessInstanceRef> cachedInstances = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private ApplicationContext appContext;
    private IFrameWindowPanel iframeWindow = null;
    private boolean isRiftsawInstance;
    private PagingPanel pagingPanel;

    public InstanceListView(ApplicationContext appContext) {
        this.appContext = appContext;
        ConsoleIconBundle icons = (ConsoleIconBundle)GWT.create(ConsoleIconBundle.class);
        this.setTitle("Process Instances");
        this.setIcon(icons.instanceIcon());
        this.isRiftsawInstance = appContext.getConfig().getProfileName().equals("BPEL Console");
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void initialize() {
        if (!this.isInitialized) {
            this.instanceList = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
            this.instanceList.setPadding(0);
            this.instanceList.setWidgetSpacing(0);
            this.listBox = new ListBox(new String[]{"Instance ID", "State", "Start Date"});
            this.listBox.setCellRenderer((ListBox.CellRenderer)new /* Unavailable Anonymous Inner Class!! */);
            this.listBox.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
            LayoutPanel toolBox = new LayoutPanel();
            toolBox.setPadding(0);
            toolBox.setWidgetSpacing(5);
            ToolBar toolBar = new ToolBar();
            toolBar.add((Widget)new PushButton("Refresh", (ClickListener)new /* Unavailable Anonymous Inner Class!! */));
            toolBar.add((Widget)new /* Unavailable Anonymous Inner Class!! */);
            toolBar.add((Widget)new PushButton("Terminate", (ClickListener)new /* Unavailable Anonymous Inner Class!! */));
            toolBar.add((Widget)new /* Unavailable Anonymous Inner Class!! */);
            toolBox.add((Widget)toolBar, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.instanceList.add((Widget)toolBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.instanceList.add((Widget)this.listBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
            this.pagingPanel = new PagingPanel((PagingCallback)new /* Unavailable Anonymous Inner Class!! */);
            this.instanceList.add((Widget)this.pagingPanel, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            if (this.cachedInstances != null) {
                this.bindData(this.cachedInstances);
            }
            LayoutPanel layout = new LayoutPanel((LayoutManager)new BorderLayout());
            layout.add((Widget)this.instanceList, (LayoutData)new BorderLayoutData(BorderLayout.Region.CENTER));
            InstanceDetailView detailsView = new InstanceDetailView(this.appContext);
            this.controller.addView(InstanceDetailView.ID, (ViewInterface)detailsView);
            this.controller.addAction(UpdateInstanceDetailAction.ID, (ActionInterface)new UpdateInstanceDetailAction());
            layout.add((Widget)detailsView, (LayoutData)new BorderLayoutData(BorderLayout.Region.SOUTH, 10, 200));
            this.add((Widget)layout);
            this.isInitialized = true;
        }
    }

    public ProcessInstanceRef getSelection() {
        ProcessInstanceRef selection = null;
        if (this.listBox.getSelectedIndex() != -1) {
            selection = (ProcessInstanceRef)this.listBox.getItem(this.listBox.getSelectedIndex());
        }
        return selection;
    }

    public ProcessDefinitionRef getCurrentDefinition() {
        return this.currentDefinition;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void update(ProcessDefinitionRef def, List<ProcessInstanceRef> instances) {
        this.currentDefinition = def;
        this.cachedInstances = instances;
        if (this.isInitialized()) {
            this.pagingPanel.reset();
        }
        this.renderUpdate();
    }

    private void renderUpdate() {
        if (this.isInitialized()) {
            this.bindData(this.cachedInstances);
            this.controller.handleEvent(new Event(UpdateInstanceDetailAction.ID, (Object)new InstanceEvent(this.currentDefinition, null)));
        }
    }

    private void bindData(List<ProcessInstanceRef> instances) {
        DefaultListModel model = (DefaultListModel)this.listBox.getModel();
        model.clear();
        List list = this.pagingPanel.trim(instances);
        for (ProcessInstanceRef inst : list) {
            model.add((Object)inst);
        }
        this.invalidate();
    }

    static /* synthetic */ SimpleDateFormat access$000(InstanceListView x0) {
        return x0.dateFormat;
    }

    static /* synthetic */ ListBox access$100(InstanceListView x0) {
        return x0.listBox;
    }

    static /* synthetic */ ProcessDefinitionRef access$200(InstanceListView x0) {
        return x0.currentDefinition;
    }

    static /* synthetic */ Controller access$300(InstanceListView x0) {
        return x0.controller;
    }

    static /* synthetic */ IFrameWindowPanel access$402(InstanceListView x0, IFrameWindowPanel x1) {
        x0.iframeWindow = x1;
        return x0.iframeWindow;
    }

    static /* synthetic */ IFrameWindowPanel access$400(InstanceListView x0) {
        return x0.iframeWindow;
    }

    static /* synthetic */ boolean access$500(InstanceListView x0) {
        return x0.isRiftsawInstance;
    }

    static /* synthetic */ void access$600(InstanceListView x0) {
        x0.renderUpdate();
    }
}

