/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.task;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.Event;
import java.util.List;
import org.gwt.mosaic.ui.client.ListBox;
import org.gwt.mosaic.ui.client.ToolBar;
import org.gwt.mosaic.ui.client.layout.BorderLayout;
import org.gwt.mosaic.ui.client.layout.BorderLayoutData;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.gwt.mosaic.ui.client.list.DefaultListModel;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.ServerPlugins;
import org.jboss.bpm.console.client.common.IFrameWindowPanel;
import org.jboss.bpm.console.client.common.PagingCallback;
import org.jboss.bpm.console.client.common.PagingPanel;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;
import org.jboss.bpm.console.client.model.TaskRef;
import org.jboss.bpm.console.client.task.AbstractTaskList;
import org.jboss.bpm.console.client.task.TaskDetailView;
import org.jboss.bpm.console.client.task.UpdateDetailsAction;
import org.jboss.bpm.console.client.task.events.DetailViewEvent;
import org.jboss.bpm.console.client.util.SimpleDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignedTasksView
extends AbstractTaskList {
    public static final String ID = AssignedTasksView.class.getName();
    private final ApplicationContext appContext;
    private IFrameWindowPanel iframeWindow = null;
    private TaskDetailView detailsView;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private boolean hasDispatcherPlugin;
    private PagingPanel pagingPanel;

    public AssignedTasksView(ApplicationContext appContext, TaskDetailView detailsView) {
        this.appContext = appContext;
        ConsoleIconBundle icons = (ConsoleIconBundle)GWT.create(ConsoleIconBundle.class);
        this.setTitle("Personal Tasks");
        this.setIcon(icons.userIcon());
        this.detailsView = detailsView;
    }

    public void initialize() {
        if (!this.isInitialized) {
            this.taskList = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
            this.taskList.setPadding(0);
            this.taskList.setWidgetSpacing(0);
            this.listBox = new ListBox(new String[]{"Priority", "Process", "Task Name", "Due Date"});
            this.listBox.setCellRenderer((ListBox.CellRenderer)new /* Unavailable Anonymous Inner Class!! */);
            this.listBox.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
            LayoutPanel toolBox = new LayoutPanel();
            toolBox.setPadding(0);
            toolBox.setWidgetSpacing(5);
            ToolBar toolBar = new ToolBar();
            toolBar.add((Widget)new PushButton("Refresh", (ClickListener)new /* Unavailable Anonymous Inner Class!! */));
            PushButton viewBtn = new PushButton("View", (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            toolBar.add((Widget)viewBtn);
            toolBar.add((Widget)new PushButton("Release", (ClickListener)new /* Unavailable Anonymous Inner Class!! */));
            toolBox.add((Widget)toolBar, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.taskList.add((Widget)toolBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            this.taskList.add((Widget)this.listBox, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
            this.pagingPanel = new PagingPanel((PagingCallback)new /* Unavailable Anonymous Inner Class!! */);
            this.taskList.add((Widget)this.pagingPanel, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
            LayoutPanel layout = new LayoutPanel((LayoutManager)new BorderLayout());
            layout.add((Widget)this.taskList, (LayoutData)new BorderLayoutData(BorderLayout.Region.CENTER));
            layout.add((Widget)this.detailsView, (LayoutData)new BorderLayoutData(BorderLayout.Region.SOUTH, 10, 200));
            this.add((Widget)layout);
            this.hasDispatcherPlugin = ServerPlugins.has((String)"org.jboss.bpm.console.server.plugin.FormDispatcherPlugin");
            viewBtn.setEnabled(this.hasDispatcherPlugin);
            this.isInitialized = true;
        }
    }

    public void update(String identity, List<TaskRef> tasks) {
        this.identity = identity;
        this.cachedTasks = tasks;
        if (this.isInitialized()) {
            this.pagingPanel.reset();
        }
        this.renderUpdate();
    }

    private void renderUpdate() {
        this.initialize();
        DefaultListModel model = (DefaultListModel)this.listBox.getModel();
        model.clear();
        List trimmed = this.pagingPanel.trim(this.cachedTasks);
        for (TaskRef task : trimmed) {
            if (TaskRef.STATE.ASSIGNED != task.getCurrentState()) continue;
            model.add((Object)task);
        }
        this.controller.handleEvent(new Event(UpdateDetailsAction.ID, (Object)new DetailViewEvent("AssignedDetailView", null)));
        this.invalidate();
    }

    static /* synthetic */ SimpleDateFormat access$000(AssignedTasksView x0) {
        return x0.dateFormat;
    }

    static /* synthetic */ ApplicationContext access$100(AssignedTasksView x0) {
        return x0.appContext;
    }

    static /* synthetic */ IFrameWindowPanel access$202(AssignedTasksView x0, IFrameWindowPanel x1) {
        x0.iframeWindow = x1;
        return x0.iframeWindow;
    }

    static /* synthetic */ IFrameWindowPanel access$200(AssignedTasksView x0) {
        return x0.iframeWindow;
    }

    static /* synthetic */ void access$300(AssignedTasksView x0) {
        x0.renderUpdate();
    }
}

