/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.Controller;
import com.mvc4g.client.ViewInterface;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.gwt.mosaic.ui.client.layout.FillLayoutData;
import org.gwt.mosaic.ui.client.CaptionLayoutPanel;
import org.jboss.bpm.console.client.common.HeaderLabel;

import java.util.List;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class PreferencesView extends CaptionLayoutPanel implements ViewInterface
{

  public final static String ID = PreferencesView.class.getName();

  private Controller controller;

  private ApplicationContext appContext;  

  public void setController(Controller controller)
  {
    this.controller = controller;
  }

  public PreferencesView()
  {
    super("User Preferences");
    
    LayoutPanel layout = new LayoutPanel(new BoxLayout(BoxLayout.Orientation.VERTICAL));

    this.appContext = Registry.get(ApplicationContext.class);
    //layout.add(new HeaderLabel("User Preferences"));
    
    LayoutPanel defaultToolPanel = new LayoutPanel(new BoxLayout(BoxLayout.Orientation.HORIZONTAL));
    
    defaultToolPanel.add(
        new HTML("<b>Default Tool</b><br>" +
        "Select the tool that should be loaded upon login.")
    );

    final List<Workspace.EditorRef> editors = appContext.getWorkpace().getEditors();
    final ListBox multiBox = new ListBox();
    multiBox.setVisibleItemCount(5);
    defaultToolPanel.add(multiBox);

    // init
    String prefEditor = Preferences.get(Preferences.BPM_DEFAULT_TOOL);    
    for(Workspace.EditorRef ref : editors)
    {
      multiBox.addItem(ref.title);
      if(ref.id.equals(prefEditor))
        multiBox.setItemSelected(multiBox.getItemCount()-1, true);
    }

    multiBox.addClickListener(
        new ClickListener()
        {
          public void onClick(Widget widget)
          {
            String title = multiBox.getItemText(multiBox.getSelectedIndex());
            for(Workspace.EditorRef ref : editors)
            {
              if(ref.title.equals(title))
              {                
                Preferences.set(Preferences.BPM_DEFAULT_TOOL, ref.id);
              }
            }
          }
        }
    );

    // parent
    layout.add(defaultToolPanel);

    this.add(layout);
  }
}
