/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.report;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.*;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.ViewInterface;
import com.mvc4g.client.Event;
import org.gwt.mosaic.ui.client.DecoratedTabLayoutPanel;
import org.gwt.mosaic.ui.client.ImageButton;
import org.gwt.mosaic.ui.client.WindowPanel;
import org.gwt.mosaic.ui.client.layout.BorderLayout;
import org.gwt.mosaic.ui.client.layout.BorderLayoutData;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.Editor;
import org.jboss.bpm.console.client.LazyPanel;
import org.jboss.bpm.console.client.MenuSection;
import org.jboss.bpm.console.client.common.AbstractView;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class ReportEditor extends Editor implements ViewInterface
{
  public final static String ID = ReportEditor.class.getName();

  private DecoratedTabLayoutPanel tabPanel;

  public ReportEditor(ApplicationContext appContext)
  {
    super(appContext);
  }

  public void setController(Controller controller)
  {
  }

  public void initialize()
  {
    if(!isInitialized())
    {
      tabPanel = new DecoratedTabLayoutPanel();
      tabPanel.setPadding(5);
      tabPanel.addTabListener(
          new TabListener()
          {
            public boolean onBeforeTabSelected(SourcesTabEvents sourcesTabEvents, int i)
            {
              boolean showTab = true;

              if(i!=0)
              {
                /*DefinitionListView view = ((DefinitionListView) controller.getView(DefinitionListView.ID));
                boolean hasSelection = view.getSelection() != null;
                if(!hasSelection)
                {
                  MessageBox.alert("Missing selection", "Please select a process");
                  showTab=false;
                } */
              }

              return showTab;
            }

            public void onTabSelected(SourcesTabEvents sourcesTabEvents, int i)
            {
              LazyPanel lazyPanel = (LazyPanel) tabPanel.getWidget(i);
              if(!lazyPanel.isInitialized())
              {
                lazyPanel.initialize();
              }
            }
          }
      );

      this.add(tabPanel, new BorderLayoutData(BorderLayout.Region.CENTER));

      // create and register views
      ReportView view = new ReportView();
      registerView(ReportView.ID, view);
      view.initialize();
      
      controller.addView(ID, this);

      // create and register actions
      registerAction(UpdateReportConfigAction.ID, new UpdateReportConfigAction());

      // display tab, needs to visible for correct rendering
      tabPanel.selectTab(0);

      // load report config
      controller.handleEvent(new Event(UpdateReportConfigAction.ID, null));

      this.isInitialized = true;
    }
  }

  private void registerView(String id, AbstractView view)
  {
    // register view with controller
    super.controller.addView(id, view);

    // add to tab layout
    this.tabPanel.add(view, view.getIconTitle(), true);
  }

  private void registerAction(String name, ActionInterface action)
  {
    super.controller.addAction(name, action);
  }

  public String getEditorId()
  {
    return ID;
  }

  public String getTitle()
  {
    return "Reporting";
  }

  public MenuSection provideMenuSection()
  {
    ConsoleIconBundle icons = GWT.create(ConsoleIconBundle.class);

    return new MenuSection(
        getTitle(),
        icons.reportIcon(),
        new ReportEditorNavigation(appContext)
    );
  }

  public void displayReport(String title, String dispatchUrl)
  {
    boolean match = false;
    for(int i=1; i<tabPanel.getWidgetCount(); i++)
    {
      ReportFrame openTab = (ReportFrame)tabPanel.getWidget(i);
      if(openTab.getUrl().equals(dispatchUrl))
      {
        tabPanel.selectTab(i);
        match=true;
        break;
      }
    }

    if(!match)
    {
      ReportFrame reportFrame = new ReportFrame(dispatchUrl);
      tabPanel.add(reportFrame, newLabel(reportFrame, title, tabPanel.getWidgetCount()));
      tabPanel.selectTab(tabPanel.getWidgetCount()-1);

    }
  }

  private Widget newLabel(final Widget widget, final String string,
                          final int index) {
    final HorizontalPanel hPanel = new HorizontalPanel();
    final HTML label = new HTML(string);
    DOM.setStyleAttribute(label.getElement(), "whiteSpace", "nowrap");
    ImageButton closeBtn = new ImageButton(
        WindowPanel.CAPTION_IMAGES.windowClose());
    closeBtn.addClickListener(new ClickListener() {
      public void onClick(Widget sender) {
        int widgetIndex = tabPanel.getWidgetIndex(widget);
        if (widgetIndex == tabPanel.getSelectedTab()) {
          tabPanel.selectTab(widgetIndex - 1);
        }
        tabPanel.remove(widgetIndex);
      }
    });
    hPanel.add(label);
    hPanel.add(new HTML("&nbsp&nbsp&nbsp"));
    hPanel.add(closeBtn);
    return hPanel;
  }
}
