/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.bpm.console.client.report;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.Registry;
import org.jboss.bpm.console.client.URLBuilder;
import org.jboss.bpm.console.client.common.IconHeader;
import org.jboss.bpm.console.client.common.WidgetWindowPanel;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;
import org.jboss.bpm.report.model.ReportReference;

import java.util.List;
import java.util.Map;
import java.util.Iterator;

/**
 * List the available reports and allows to redner them.<br>
 * Driven by a list of {@link org.jboss.bpm.report.model.ReportReference}s
 * that need to be retrieved from the server module.
 *
 * @see org.jboss.bpm.console.client.report.UpdateReportConfigAction
 * 
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
class ReportLaunchPadView extends LayoutPanel implements ViewInterface
{
  public final static String ID = ReportLaunchPadView.class.getName();

  private Controller controller;

  private WidgetWindowPanel window;

  public ReportLaunchPadView()
  {
    super(new BoxLayout(BoxLayout.Orientation.VERTICAL));
    this.setPadding(10);
    HTML html = new HTML("The following reports are available.<br/> " +
        "Please note that rendering may take a while.");
    this.add(html);
  
  }

  public void update(List<ReportReference> reports)
  {
    ConsoleIconBundle icons = GWT.create(ConsoleIconBundle.class);

    for(final ReportReference reportRef : reports)
    {
      final boolean hasParameters = reportRef.getParameterMetaData().size()>0;

      //p.add(new HeaderLabel(group.name));
      LayoutPanel inner = new LayoutPanel(new BoxLayout(BoxLayout.Orientation.VERTICAL));

      // a single report description
      LayoutPanel row = new LayoutPanel(new BoxLayout(BoxLayout.Orientation.HORIZONTAL));

      LayoutPanel desc = new LayoutPanel(new BoxLayout(BoxLayout.Orientation.VERTICAL));
      desc.setPadding(0);
      IconHeader header = new IconHeader(icons.reportInstanceIcon(), reportRef.getTitle());
      header.setWidth("95%");
      desc.add(header);
      String description = reportRef.getDescription()!=null ? reportRef.getDescription() : "";
      desc.add(new HTML(description));
      row.add(desc,new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));

      // render button
      row.add(new Button("Render",
          new ClickListener()
          {
            public void onClick(Widget widget)
            {
              if(hasParameters)
              {
                ReportParameterForm form =
                    new ReportParameterForm(reportRef,
                        new ReportParamCallback()
                        {

                          public void onSumbit(Map<String, String> paramValues)
                          {

                            String url = URLBuilder.getInstance().getReportURL(reportRef.getReportFileName());

                            RenderDispatchEvent eventPayload = new RenderDispatchEvent(reportRef.getTitle(), url);
                            eventPayload.setParameters(fieldValues2PostParams(paramValues));
                            controller.handleEvent( new Event(RenderReportAction.ID, eventPayload));

                            window.close();
                          }
                        });

                window = new WidgetWindowPanel("Report Parameter", form);
              }
              else
              {
                String url = URLBuilder.getInstance().getReportURL(reportRef.getReportFileName());
                controller.handleEvent(
                    new Event(RenderReportAction.ID,
                        new RenderDispatchEvent(reportRef.getTitle(), url)
                    )
                );
              }
            }
          })
      );


      inner.add(row, new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
      this.add(inner, new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));

    }


    Registry.get(ApplicationContext.class).refreshView();
  }

  private static String fieldValues2PostParams(Map<String,String> values)
  {
    StringBuffer sb = new StringBuffer();
    Iterator<String> keys = values.keySet().iterator();
    while(keys.hasNext())
    {
      String key = keys.next();
      sb.append(key).append("=").append(values.get(key));
      sb.append(";");
    }

    System.out.println(sb.toString());
    return sb.toString();
  }

  public void setController(Controller controller)
  {
    this.controller = controller;
  }

}
