/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.report;

import com.google.gwt.user.client.ui.*;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.jboss.bpm.console.client.common.HeaderLabel;
import org.jboss.bpm.report.model.ReportParameter;
import org.jboss.bpm.report.model.ReportReference;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

/**
 * Report parameter input.
 * 
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class ReportParameterForm extends LayoutPanel
{
  private ReportReference reportReference;
  private ReportParamCallback callback;
  private List<InputField> fields = new ArrayList<InputField>();
  
  public ReportParameterForm(ReportReference reportReference, ReportParamCallback callback)
  {
    this.reportReference = reportReference;
    this.callback = callback;
    
    Widget form = createForm(reportReference);
    this.add(form);
  }

  private Widget createForm(final ReportReference reportRef)
  {
    LayoutPanel p = new LayoutPanel(new BoxLayout(BoxLayout.Orientation.VERTICAL));
    HeaderLabel label = new HeaderLabel(reportRef.getTitle(), true);
    p.add(label, new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));

    String description = reportRef.getDescription()!=null ? reportRef.getDescription() : "";
    p.add(new HTML("<blockquote>"+description+"</blockquote>"));

    Grid grid = new Grid(reportRef.getParameterMetaData().size(),2);
    grid.setCellPadding(5);

    int row = 0;
    for(final ReportParameter reportParam : reportRef.getParameterMetaData())
    {
      String promptText = reportParam.getPromptText() != null ? reportParam.getPromptText() : reportParam.getName();
      String helpText = reportParam.getHelptext() != null ? reportParam.getHelptext() : "";

      grid.setWidget(row,0, new HTML("<b>"+promptText+"</b><br/>"+helpText));
      
      final TextBox textBox = new TextBox();

      // retain access to values
      final InputField field = new InputField()
      {
        String getValue()
        {
          return textBox.getText();
        }

        {
        widget = textBox;
        id = reportParam.getName();
               
      }};
      fields.add(field);

      grid.setWidget(row,1, textBox);
      grid.getRowFormatter().setVerticalAlign(row, HasVerticalAlignment.ALIGN_BOTTOM);

      row++;
    }

    p.add(grid);
    p.add(new Button("Submit",
        new ClickListener()
        {
          public void onClick(Widget widget)
          {
            Map<String, String> values = new HashMap<String,String>();
            for(InputField field : fields)
              values.put(field.id, field.getValue());   

            callback.onSumbit(values);
          }
        })
    );

    return p;
  }

  class InputField
  {
    Widget widget;
    String id;
        
    String getValue()
    {
      throw new IllegalArgumentException("Override this method");
    }
  }
}
