/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.report;

import com.google.gwt.core.client.GWT;
import com.mvc4g.client.Controller;
import org.gwt.mosaic.ui.client.DeckLayoutPanel;
import org.gwt.mosaic.ui.client.Label;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.jboss.bpm.console.client.common.AbstractView;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;
import org.jboss.bpm.console.client.search.UpdateSearchDefinitionsAction;
import org.jboss.bpm.console.client.util.ConsoleLog;
import org.jboss.bpm.report.model.ReportReference;

import java.util.List;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class ReportView extends AbstractView
{
  public final static String ID = ReportView.class.getName();

  private Controller controller;
  private boolean isInitialized;
  private DeckLayoutPanel deck;
  private ReportLaunchPadView coverpanel;
  
  public ReportView()
  {
    super();
    ConsoleIconBundle icons = GWT.create(ConsoleIconBundle.class);
    setTitle("Available Reports");
    setIcon(icons.reportIcon());
  }

  public boolean isInitialized()
  {
    return isInitialized;
  }

  public void initialize()
  {
    if(!isInitialized)
    {
      // layout
      deck = new DeckLayoutPanel();

      // loading
      LayoutPanel loadingPanel = new LayoutPanel();
      loadingPanel.add(new Label("Loading..."));
      loadingPanel.setVisible(false);
      deck.add(loadingPanel);

      // cover
      coverpanel = new ReportLaunchPadView();
      deck.add(coverpanel);
      
      this.add(deck);

      // views and actions      
      controller.addView(ReportLaunchPadView.ID, coverpanel);

      controller.addAction(UpdateSearchDefinitionsAction.ID, new UpdateSearchDefinitionsAction());
      controller.addAction(RenderReportAction.ID, new RenderReportAction());

      deck.showWidget(0);

      this.isInitialized = true;
    }
  }

  public void setController(Controller controller)
  {
    this.controller = controller;
  }
  
  public void configure(List<ReportReference> reports)
  {
    // update coverview
    coverpanel.update(reports);    
    deck.showWidget(1);
  }
}
