/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.task;

import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.TreeListener;
import com.google.gwt.core.client.GWT;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.Workspace;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.Label;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
class TaskEditorNavigation extends Tree
{
  public TaskEditorNavigation(final ApplicationContext appContext)
  {
    super.setTitle("Tasks");

    addItem("Group Tasks");
    addItem("Personal Tasks");

    addTreeListener(
        new TreeListener()
        {
          public void onTreeItemSelected(TreeItem treeItem)
          {
            if("Group Tasks".equals(treeItem.getText()))
            {
              Workspace workspace = appContext.getWorkpace();
              workspace.showEditor(TaskEditor.ID, "group");
            }
            else if("Personal Tasks".equals(treeItem.getText()))
            {
              Workspace workspace = appContext.getWorkpace();
              workspace.showEditor(TaskEditor.ID, "personal");
            }
          }

          public void onTreeItemStateChanged(TreeItem treeItem)
          {

          }
        }
    );
  }

  /*public void add(String string)
  {
    ConsoleIconBundle icons = GWT.create(ConsoleIconBundle.class);
    LayoutPanel p = new LayoutPanel(new BoxLayout(BoxLayout.Orientation.HORIZONTAL));
    p.add(icons.arrowIcon().createImage());
    p.add(new Label(string));
    super.add(p);
  } */
}
