/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.ws;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.Controller;
import org.gwt.mosaic.ui.client.ToolBar;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.common.AbstractView;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;

import java.util.Date;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class EmbeddedWSView extends AbstractView
{
  public final static String ID = EmbeddedWSView.class.getName();

  private Controller controller;
  private boolean isInitialized;
  private ApplicationContext appContext;
  private LayoutPanel layout;
  private Frame frame;

  private String remoteUrl;

  public EmbeddedWSView(ApplicationContext appContext)
  {
    super();
    this.appContext = appContext;
    ConsoleIconBundle icons = GWT.create(ConsoleIconBundle.class);

    remoteUrl ="http://localhost:8080/jbossws/services";

    setTitle(remoteUrl);
    setIcon(icons.webserviceIcon());

  }

  public boolean isInitialized()
  {
    return isInitialized;
  }

  public void initialize()
  {
    if(!isInitialized)
    {

      // layout
      layout = new LayoutPanel( new BoxLayout(BoxLayout.Orientation.VERTICAL));
      layout.setPadding(0);
      layout.setWidgetSpacing(0);

      // report frame
      frame = new Frame();
      DOM.setStyleAttribute(frame.getElement(), "border", "none");

      // toolbar
      final LayoutPanel toolBox = new LayoutPanel();
      toolBox.setPadding(0);
      toolBox.setWidgetSpacing(5);
      //toolBox.setLayout(new BoxLayout(BoxLayout.Orientation.VERTICAL));

      final ToolBar toolBar = new ToolBar();
      toolBar.add(createMenuBtn());
      toolBox.add(toolBar, new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));


      // assembly
      layout.add(toolBox, new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));     
      layout.add(frame, new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));

      this.add(layout);

      // load contents
      setFrameUrl(remoteUrl);
      
      this.isInitialized = true;
    }
  }


  public void onClick(Widget widget)
  {
    System.out.println(widget);
  }


  private Widget createMenuBtn()
  {
    return new Button("Referesh",
        new ClickListener()
        {
          public void onClick(Widget widget)
          {
            setFrameUrl(remoteUrl);
          }      
        }
    );
  }

  public void setController(Controller controller)
  {
    this.controller = controller;
  }

  private void setFrameUrl(String url)
  {
    // https://jira.jboss.org/jira/browse/JBPM-2244
    frame.getElement().setId(
        String.valueOf( new Date().getTime())
    );

    frame.setUrl(url);

  }
}
