/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client.ws;

import org.jboss.bpm.console.client.Editor;
import org.jboss.bpm.console.client.MenuSection;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.LazyPanel;
import org.jboss.bpm.console.client.common.AbstractView;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;
import org.gwt.mosaic.ui.client.DecoratedTabLayoutPanel;
import org.gwt.mosaic.ui.client.layout.BorderLayoutData;
import org.gwt.mosaic.ui.client.layout.BorderLayout;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.TabListener;
import com.google.gwt.user.client.ui.SourcesTabEvents;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class WebServiceEditor extends Editor
{

  public final static String ID = WebServiceEditor.class.getName();

  private DecoratedTabLayoutPanel tabPanel;

  public WebServiceEditor(ApplicationContext appContext)
  {
    super(appContext);
  }

  public void initialize()
  {
    if(!isInitialized())
    {
      tabPanel = new DecoratedTabLayoutPanel();
      tabPanel.setPadding(5);
      tabPanel.addTabListener(
          new TabListener()
          {
            public boolean onBeforeTabSelected(SourcesTabEvents sourcesTabEvents, int i)
            {
              boolean showTab = true;

              if(i!=0)
              {
                
              }

              return showTab;
            }

            public void onTabSelected(SourcesTabEvents sourcesTabEvents, int i)
            {
              LazyPanel lazyPanel = (LazyPanel) tabPanel.getWidget(i);
              if(!lazyPanel.isInitialized())
              {
                lazyPanel.initialize();
                appContext.refreshView(); // TODO: hack around rendering problems
              }
            }
          }
      );

      this.add(tabPanel, new BorderLayoutData(BorderLayout.Region.CENTER));

      // create and register views
      registerView(EmbeddedWSView.ID, new EmbeddedWSView(appContext));
     
      // display tab, needs to visible for correct rendering
      tabPanel.selectTab(0);

      appContext.refreshView();
      this.isInitialized = true;
    }
  }

  private void registerView(String id, AbstractView view)
  {
    // register view with controller
    super.controller.addView(id, view);

    // add to tab layout
    this.tabPanel.add(view, view.getIconTitle(), true);
  }


  public String getEditorId()
  {
    return ID;
  }

  public String getTitle()
  {
    return "Web Service Endpoints";
  }

  public MenuSection provideMenuSection()
  {
    ConsoleIconBundle icons = GWT.create(ConsoleIconBundle.class);

    return new MenuSection(
        "Web Services",
        icons.webserviceIcon(),
        new WebServiceEditorNavigation(appContext)
    );
  }
}
