/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.task;

import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.Controller;
import com.mvc4g.client.ViewInterface;
import org.gwt.mosaic.ui.client.Caption;
import org.gwt.mosaic.ui.client.CaptionLayoutPanel;
import org.gwt.mosaic.ui.client.DeckLayoutPanel;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.MosaicPanel;
import org.jboss.bpm.console.client.LazyPanel;
import org.jboss.bpm.console.client.common.PropertyGrid;
import org.jboss.bpm.console.client.model.TaskRef;
import org.jboss.bpm.console.client.task.ParticipantPanel;

public class TaskDetailView
extends CaptionLayoutPanel
implements ViewInterface,
LazyPanel {
    public static final String ID = TaskDetailView.class.getName();
    private Controller controller;
    private TaskRef currentTask = null;
    private PropertyGrid grid;
    private ParticipantPanel participantPanel;
    private boolean openView;
    private boolean initialzed;

    public TaskDetailView(boolean openView) {
        super("Task details");
        super.setStyleName("bpm-detail-panel");
        this.openView = openView;
    }

    public boolean isInitialized() {
        return this.initialzed;
    }

    public void initialize() {
        if (!this.initialzed) {
            this.grid = new PropertyGrid(new String[]{"ID:", "Process:", "Name:", "Assignee:", "Description:"});
            if (this.openView) {
                DeckLayoutPanel deck = new DeckLayoutPanel();
                deck.add((Widget)this.grid);
                this.participantPanel = new ParticipantPanel();
                this.participantPanel.setController(this.controller);
                ListBox dropBox = new ListBox(false);
                dropBox.setStyleName("bpm-operation-ui");
                dropBox.addItem("Properties");
                dropBox.addItem("Participants");
                dropBox.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
                deck.add((Widget)this.participantPanel);
                this.getHeader().add((Widget)dropBox, Caption.CaptionRegion.RIGHT);
                this.add((Widget)deck, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
                deck.showWidget(dropBox.getSelectedIndex());
            } else {
                MosaicPanel p = new MosaicPanel();
                p.add((Widget)this.grid);
                this.add((Widget)p);
            }
            this.initialzed = true;
        }
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void update(TaskRef task) {
        String description = task.getDescription() != null ? task.getDescription() : "";
        String[] values = new String[]{String.valueOf(task.getId()), task.getProcessId(), task.getName(), task.getAssignee(), description};
        this.grid.update(values);
        if (this.openView && this.participantPanel != null) {
            this.participantPanel.update(task);
        }
    }

    public void clearView() {
        this.grid.clear();
        if (this.openView && this.participantPanel != null) {
            this.participantPanel.clearView();
        }
        this.currentTask = null;
    }
}

