/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.monitor;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gwt.mosaic.ui.client.LayoutPopupPanel;
import org.gwt.mosaic.ui.client.PopupMenu;
import org.gwt.mosaic.ui.client.ToolBar;
import org.gwt.mosaic.ui.client.ToolButton;
import org.gwt.mosaic.ui.client.layout.BorderLayout;
import org.gwt.mosaic.ui.client.layout.BorderLayoutData;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.ColumnLayout;
import org.gwt.mosaic.ui.client.layout.ColumnLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.gwt.mosaic.ui.client.layout.RowLayout;
import org.gwt.mosaic.ui.client.layout.RowLayoutData;
import org.gwt.mosaic.ui.client.list.DefaultListModel;
import org.gwt.mosaic.ui.client.util.ResizableWidget;
import org.gwt.mosaic.ui.client.util.ResizableWidgetCollection;
import org.jboss.bpm.console.client.common.LoadingOverlay;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.model.StringRef;
import org.jboss.bpm.console.client.monitor.ExecutionHistoryView;
import org.jboss.bpm.console.client.monitor.GetProcessDefinitionsAction;
import org.jboss.bpm.console.client.monitor.LoadChartProcessInstancesAction;
import org.jboss.bpm.console.client.monitor.LoadDatasetEvent;
import org.jboss.bpm.console.client.monitor.LoadDatasetsAction;
import org.jboss.bpm.console.client.util.ConsoleLog;
import org.jboss.bpm.console.client.util.SimpleDateFormat;
import org.jboss.bpm.monitor.gui.client.ChronoscopeFactory;
import org.jboss.bpm.monitor.gui.client.JSOModel;
import org.jboss.bpm.monitor.gui.client.TimespanValues;
import org.jboss.errai.bus.client.ErraiBus;
import org.jboss.errai.bus.client.api.MessageCallback;
import org.jboss.errai.workspaces.client.api.ProvisioningCallback;
import org.jboss.errai.workspaces.client.api.WidgetProvider;
import org.jboss.errai.workspaces.client.api.annotations.LoadTool;
import org.jboss.errai.workspaces.client.framework.Registry;
import org.timepedia.chronoscope.client.Dataset;
import org.timepedia.chronoscope.client.Datasets;
import org.timepedia.chronoscope.client.Overlay;
import org.timepedia.chronoscope.client.XYPlot;
import org.timepedia.chronoscope.client.browser.ChartPanel;
import org.timepedia.chronoscope.client.browser.Chronoscope;
import org.timepedia.chronoscope.client.browser.json.GwtJsonDataset;
import org.timepedia.chronoscope.client.canvas.View;
import org.timepedia.chronoscope.client.canvas.ViewReadyCallback;
import org.timepedia.chronoscope.client.data.json.JsonDataset;
import org.timepedia.chronoscope.client.data.tuple.Tuple2D;
import org.timepedia.chronoscope.client.event.PlotFocusHandler;
import org.timepedia.chronoscope.client.io.DatasetReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@LoadTool(name="Execution History", group="Processes")
public class ExecutionHistoryView
implements WidgetProvider,
ViewInterface {
    public static final String ID = ExecutionHistoryView.class.getName();
    private static final String TIMEPEDIA_FONTBOOK_SERVICE = "http://api.timepedia.org/fr";
    private static volatile double GOLDEN__RATIO = 1.618;
    private ChartPanel chartPanel;
    private ToolButton menuButton;
    private ToolButton timespanButton;
    private HTML title;
    private HTML timespan;
    private LayoutPanel chartArea;
    private LayoutPanel timespanPanel;
    private Map<Long, Overlay> overlayMapping = new HashMap();
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private String currentProcDef;
    private TimespanValues currentTimespan;
    private LayoutPanel instancePanel;
    private org.gwt.mosaic.ui.client.ListBox<String> listBox;
    private LayoutPanel buttonPanel;
    private CheckBox includeFailed;
    private Controller controller;
    private static final int DATASET_COMPLETED = 0;
    private static final int DATASET_FAILED = 1;
    private static final int DATASET_TERMINATED = 2;
    private List<ProcessDefinitionRef> processDefinitions;

    public void provideWidget(ProvisioningCallback callback) {
        this.controller = (Controller)Registry.get(Controller.class);
        this.controller.addView(ID, (ViewInterface)this);
        this.controller.addAction(GetProcessDefinitionsAction.ID, (ActionInterface)new GetProcessDefinitionsAction());
        this.controller.addAction(LoadDatasetsAction.ID, (ActionInterface)new LoadDatasetsAction());
        this.controller.addAction(LoadChartProcessInstancesAction.ID, (ActionInterface)new LoadChartProcessInstancesAction());
        LayoutPanel panel = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        ToolBar toolBar = new ToolBar();
        panel.add((Widget)toolBar, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        this.menuButton = new ToolButton("Open", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        toolBar.add((Widget)this.menuButton);
        this.title = new HTML();
        this.title.getElement().setAttribute("style", "font-size:24px; font-weight:BOLD");
        BoxLayout boxLayout = new BoxLayout(BoxLayout.Orientation.HORIZONTAL);
        this.timespanPanel = new LayoutPanel((LayoutManager)boxLayout);
        this.timespanPanel.setPadding(0);
        this.timespan = new HTML();
        this.timespan.getElement().setAttribute("style", "padding-left:10px;padding-top:2px; color:#C8C8C8;font-size:16px;text-align:left;");
        this.timespanButton = new ToolButton();
        this.timespanButton.setStyle(ToolButton.ToolButtonStyle.MENU);
        this.timespanButton.getElement().setAttribute("style", "padding-right:0px;background-image:none;");
        this.timespanButton.setVisible(false);
        PopupMenu timeBtnMenu = new PopupMenu();
        for (TimespanValues ts : TimespanValues.values()) {
            timeBtnMenu.addItem(ts.getCanonicalName(), (Command)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.timespanButton.setMenu(timeBtnMenu);
        this.timespanPanel.add((Widget)this.timespanButton, (LayoutData)new BoxLayoutData("20px", "20px"));
        this.timespanPanel.add((Widget)this.timespan, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        LayoutPanel contents = new LayoutPanel((LayoutManager)new RowLayout());
        LayoutPanel headerPanel = new LayoutPanel((LayoutManager)new ColumnLayout());
        headerPanel.setPadding(0);
        headerPanel.add((Widget)this.title, (LayoutData)new ColumnLayoutData("55%"));
        headerPanel.add((Widget)this.timespanPanel, (LayoutData)new ColumnLayoutData("45%"));
        this.chartArea = new LayoutPanel();
        this.chartArea.setPadding(15);
        this.chartArea.setLayout((LayoutManager)new BorderLayout());
        this.instancePanel = new LayoutPanel();
        this.listBox = new org.gwt.mosaic.ui.client.ListBox(new String[]{"Process Instance"});
        this.instancePanel.add((Widget)this.listBox);
        contents.add((Widget)headerPanel, (LayoutData)new RowLayoutData("100"));
        contents.add((Widget)this.chartArea, (LayoutData)new RowLayoutData(true));
        this.includeFailed = new CheckBox("Incl. failed / terminated?");
        this.includeFailed.setValue(Boolean.valueOf(false));
        this.includeFailed.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonPanel = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        this.buttonPanel.add((Widget)this.includeFailed);
        panel.add((Widget)contents, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
        ErraiBus.get().subscribe("process.execution.history", (MessageCallback)new /* Unavailable Anonymous Inner Class!! */);
        callback.onSuccess((Widget)panel);
    }

    private String getDefinitionId(String currentProcessDefinition) {
        String definitionId = null;
        for (ProcessDefinitionRef ref : this.processDefinitions) {
            if (!currentProcessDefinition.equals(ref.getName())) continue;
            definitionId = ref.getId();
        }
        return definitionId;
    }

    public void selectDefinition(List<ProcessDefinitionRef> processDefinitions) {
        this.processDefinitions = processDefinitions;
        LayoutPopupPanel popup = new LayoutPopupPanel(true);
        popup.addStyleName("soa-PopupPanel");
        ListBox listBox = new ListBox();
        listBox.addItem("");
        for (ProcessDefinitionRef ref : processDefinitions) {
            listBox.addItem(ref.getName());
        }
        LayoutPanel p = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        p.add((Widget)new HTML("Please select a process:"));
        p.add((Widget)listBox);
        LayoutPanel p2 = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.HORIZONTAL));
        p2.add((Widget)new Button("Done", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */));
        HTML html = new HTML("Cancel");
        html.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        p2.add((Widget)html, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        p.add((Widget)p2);
        popup.setPopupPosition(this.menuButton.getAbsoluteLeft() - 5, this.menuButton.getAbsoluteTop() + 30);
        popup.setWidget((Widget)p);
        popup.pack();
        popup.show();
    }

    private void update(String procDef, String processDefinitionId) {
        String name = this.currentProcDef = procDef;
        String subtitle = "";
        if (this.currentProcDef.indexOf("}") != -1) {
            String[] qname = this.currentProcDef.split("}");
            name = qname[1];
            subtitle = qname[0].substring(1, qname[0].length());
        }
        this.title.setHTML(name + "<br/><div style='color:#C8C8C8;font-size:12px;text-align:left;'>" + subtitle + "</div>");
        TimespanValues ts = this.currentTimespan == null ? TimespanValues.LAST_7_DAYS : this.currentTimespan;
        LoadingOverlay.on((Widget)this.chartArea, (boolean)true);
        LoadDatasetEvent theEvent = new LoadDatasetEvent();
        theEvent.setDefinitionId(processDefinitionId);
        theEvent.setTimespan(ts);
        if (this.includeFailed.getValue().booleanValue()) {
            theEvent.setIncludedFailed(true);
        } else {
            theEvent.setIncludedFailed(false);
        }
        this.currentTimespan = ts;
        this.controller.handleEvent(new Event(LoadDatasetsAction.ID, (Object)theEvent));
    }

    public void updateChart(String chartData) {
        ((DefaultListModel)this.listBox.getModel()).clear();
        LoadingOverlay.on((Widget)this.chartArea, (boolean)false);
        this.timespanButton.setVisible(true);
        Datasets datasets = new Datasets();
        DatasetReader datasetReader = ChronoscopeFactory.getInstance().getDatasetReader();
        JSOModel jsoModel = JSOModel.fromJson((String)chartData);
        if (chartData.startsWith("[")) {
            for (int i = 0; i < jsoModel.length(); ++i) {
                datasets.add(datasetReader.createDatasetFromJson((JsonDataset)new GwtJsonDataset(jsoModel.get(i))));
            }
        } else {
            datasets.add(datasetReader.createDatasetFromJson((JsonDataset)new GwtJsonDataset((JavaScriptObject)jsoModel)));
        }
        this.renderChart(datasets);
        this.timespanPanel.layout();
    }

    private void renderChart(Datasets<Tuple2D> datasets) {
        try {
            Dataset[] dsArray = datasets.toArray();
            if (this.chartPanel != null) {
                this.chartPanel.replaceDatasets(dsArray);
                this.overlayMapping.clear();
            } else {
                this.initChartPanel(dsArray);
            }
            this.timespan.setText("Executions " + this.currentTimespan.getCanonicalName());
            this.chartArea.layout();
        }
        catch (Exception e) {
            ConsoleLog.error((String)"Failed to create chart", (Throwable)e);
        }
    }

    private void initChartPanel(Dataset[] datasets) {
        int[] dim = this.calcChartDimension();
        this.chartPanel = Chronoscope.createTimeseriesChart((Dataset[])datasets, (int)dim[0], (int)dim[1]);
        XYPlot plot = this.chartPanel.getChart().getPlot();
        plot.addPlotFocusHandler((PlotFocusHandler)new /* Unavailable Anonymous Inner Class!! */);
        8 callback = new /* Unavailable Anonymous Inner Class!! */;
        this.chartPanel.setViewReadyCallback((ViewReadyCallback)callback);
        LayoutPanel wrapper = new LayoutPanel();
        wrapper.setLayout((LayoutManager)new ColumnLayout());
        wrapper.add((Widget)this.chartPanel, (LayoutData)new ColumnLayoutData("70%"));
        wrapper.add((Widget)new Label("More..."), (LayoutData)new ColumnLayoutData("30%"));
        this.chartArea.add((Widget)this.chartPanel);
        this.chartArea.add((Widget)this.buttonPanel, (LayoutData)new BorderLayoutData(BorderLayout.Region.EAST, "150px"));
        this.instancePanel.getElement().setAttribute("style", "margin-top:15px");
        this.chartArea.add((Widget)this.instancePanel, (LayoutData)new BorderLayoutData(BorderLayout.Region.SOUTH, "150px"));
        ResizableWidgetCollection.get().add((ResizableWidget)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void updateProcessInstances(List<StringRef> instances) {
        DefaultListModel listModel = (DefaultListModel)this.listBox.getModel();
        listModel.clear();
        for (StringRef instance : instances) {
            listModel.add((Object)instance.getValue());
        }
    }

    private int[] calcChartDimension() {
        return new int[]{460, 200};
    }

    private View resizeChartView() {
        int[] dim = this.calcChartDimension();
        View view = this.chartPanel.getChart().getView();
        if (view != null) {
            view.resize(dim[0], dim[1]);
        }
        this.resizeChartArea(view);
        return view;
    }

    private void resizeChartArea(View view) {
        this.chartArea.layout();
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    static /* synthetic */ Controller access$000(ExecutionHistoryView x0) {
        return x0.controller;
    }

    static /* synthetic */ LayoutPanel access$100(ExecutionHistoryView x0) {
        return x0.chartArea;
    }

    static /* synthetic */ String access$200(ExecutionHistoryView x0) {
        return x0.currentProcDef;
    }

    static /* synthetic */ String access$300(ExecutionHistoryView x0, String x1) {
        return x0.getDefinitionId(x1);
    }

    static /* synthetic */ TimespanValues access$402(ExecutionHistoryView x0, TimespanValues x1) {
        x0.currentTimespan = x1;
        return x0.currentTimespan;
    }

    static /* synthetic */ CheckBox access$500(ExecutionHistoryView x0) {
        return x0.includeFailed;
    }

    static /* synthetic */ TimespanValues access$400(ExecutionHistoryView x0) {
        return x0.currentTimespan;
    }

    static /* synthetic */ void access$600(ExecutionHistoryView x0, String x1, String x2) {
        x0.update(x1, x2);
    }

    static /* synthetic */ void access$700(ExecutionHistoryView x0, View x1) {
        x0.resizeChartArea(x1);
    }

    static /* synthetic */ ChartPanel access$800(ExecutionHistoryView x0) {
        return x0.chartPanel;
    }

    static /* synthetic */ View access$900(ExecutionHistoryView x0) {
        return x0.resizeChartView();
    }
}

