/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.server;

import java.net.HttpURLConnection;
import java.security.KeyPair;
import java.security.KeyStore;
import java.util.Map;
import org.jboss.bpm.console.server.RestProxyAuthProvider;
import org.jboss.bpm.console.server.RestProxyBasicAuthProvider;
import org.overlord.commons.auth.util.SAMLAssertionUtil;
import org.overlord.commons.auth.util.SAMLBearerTokenUtil;

public class RestProxySAMLBearerTokenAuthProvider
implements RestProxyAuthProvider {
    public static final String SAML_AUTH_ISSUER = "bpel-console.rest-proxy.authentication.saml.issuer";
    public static final String SAML_AUTH_SERVICE = "bpel-console.rest-proxy.authentication.saml.service";
    public static final String SAML_AUTH_SIGN_ASSERTIONS = "bpel-console.rest-proxy.authentication.saml.sign-assertions";
    public static final String SAML_AUTH_KEYSTORE = "bpel-console.rest-proxy.authentication.saml.keystore";
    public static final String SAML_AUTH_KEYSTORE_PASSWORD = "bpel-console.rest-proxy.authentication.saml.keystore-password";
    public static final String SAML_AUTH_KEY_ALIAS = "bpel-console.rest-proxy.authentication.saml.key-alias";
    public static final String SAML_AUTH_KEY_PASSWORD = "bpel-console.rest-proxy.authentication.saml.key-password";
    private Map<String, String> configProperties;

    public void setConfiguration(Map<String, String> configProperties) {
        this.configProperties = configProperties;
    }

    public void provideAuthentication(HttpURLConnection connection) {
        String headerValue = RestProxyBasicAuthProvider.createBasicAuthHeader((String)"SAML-BEARER-TOKEN", (String)this.createSAMLBearerTokenAssertion());
        connection.setRequestProperty("Authorization", headerValue);
    }

    private String createSAMLBearerTokenAssertion() {
        String samlAssertion = SAMLAssertionUtil.createSAMLAssertion((String)this.getIssuer(), (String)this.getService());
        if (this.isSignAssertions()) {
            try {
                KeyStore keystore = SAMLBearerTokenUtil.loadKeystore((String)this.getKeystorePath(), (String)this.getKeystorePassword());
                KeyPair keyPair = SAMLBearerTokenUtil.getKeyPair((KeyStore)keystore, (String)this.getAlias(), (String)this.getAliasPassword());
                samlAssertion = SAMLBearerTokenUtil.signSAMLAssertion((String)samlAssertion, (KeyPair)keyPair);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return samlAssertion;
    }

    private String getIssuer() {
        return (String)this.configProperties.get(SAML_AUTH_ISSUER);
    }

    private String getService() {
        return (String)this.configProperties.get(SAML_AUTH_SERVICE);
    }

    private boolean isSignAssertions() {
        return "true".equals(this.configProperties.get(SAML_AUTH_SIGN_ASSERTIONS));
    }

    protected String getKeystorePath() {
        return (String)this.configProperties.get(SAML_AUTH_KEYSTORE);
    }

    protected String getKeystorePassword() {
        return (String)this.configProperties.get(SAML_AUTH_KEYSTORE_PASSWORD);
    }

    protected String getAlias() {
        return (String)this.configProperties.get(SAML_AUTH_KEY_ALIAS);
    }

    protected String getAliasPassword() {
        return (String)this.configProperties.get(SAML_AUTH_KEY_PASSWORD);
    }
}

