/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import javax.transaction.Transaction;
import org.jboss.cache.config.Option;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.transaction.GlobalTransaction;

public class InvocationContext
implements Cloneable {
    private Transaction transaction;
    private GlobalTransaction globalTransaction;
    private Option optionOverrides;
    private boolean originLocal = true;
    private boolean txHasMods;
    private boolean localRollbackOnly;
    private MethodCall methodCall;

    InvocationContext() {
    }

    public void setLocalRollbackOnly(boolean localRollbackOnly) {
        this.localRollbackOnly = localRollbackOnly;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public GlobalTransaction getGlobalTransaction() {
        return this.globalTransaction;
    }

    public void setGlobalTransaction(GlobalTransaction globalTransaction) {
        this.globalTransaction = globalTransaction;
    }

    public Option getOptionOverrides() {
        if (this.optionOverrides == null) {
            this.optionOverrides = new Option();
        }
        return this.optionOverrides;
    }

    public void setOptionOverrides(Option optionOverrides) {
        this.optionOverrides = optionOverrides;
    }

    public boolean isOriginLocal() {
        return this.originLocal;
    }

    public void setOriginLocal(boolean originLocal) {
        this.originLocal = originLocal;
    }

    public String toString() {
        return "InvocationContext{methodCall=" + (Object)((Object)this.methodCall) + "transaction=" + this.transaction + ", globalTransaction=" + this.globalTransaction + ", optionOverrides=" + this.optionOverrides + ", originLocal=" + this.originLocal + ", txHasMods=" + this.txHasMods + '}';
    }

    public boolean isTxHasMods() {
        return this.txHasMods;
    }

    public void setTxHasMods(boolean b) {
        this.txHasMods = b;
    }

    public boolean isLocalRollbackOnly() {
        return this.localRollbackOnly;
    }

    public void reset() {
        this.transaction = null;
        this.globalTransaction = null;
        this.optionOverrides = null;
        this.originLocal = true;
        this.txHasMods = false;
    }

    public InvocationContext clone() throws CloneNotSupportedException {
        InvocationContext clone = (InvocationContext)super.clone();
        clone.setOptionOverrides(this.getOptionOverrides().clone());
        return clone;
    }

    public void setState(InvocationContext template) {
        if (template == null) {
            throw new NullPointerException("Template InvocationContext passed in to InvocationContext.setState() passed in is null");
        }
        this.setGlobalTransaction(template.getGlobalTransaction());
        this.setLocalRollbackOnly(template.isLocalRollbackOnly());
        this.setOptionOverrides(template.getOptionOverrides());
        this.setOriginLocal(template.isOriginLocal());
        this.setTransaction(template.getTransaction());
        this.setTxHasMods(template.isTxHasMods());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvocationContext that = (InvocationContext)o;
        if (this.localRollbackOnly != that.localRollbackOnly) {
            return false;
        }
        if (this.originLocal != that.originLocal) {
            return false;
        }
        if (this.txHasMods != that.txHasMods) {
            return false;
        }
        if (this.globalTransaction != null ? !this.globalTransaction.equals(that.globalTransaction) : that.globalTransaction != null) {
            return false;
        }
        if (this.optionOverrides != null ? !this.optionOverrides.equals(that.optionOverrides) : that.optionOverrides != null) {
            return false;
        }
        return !(this.transaction != null ? !this.transaction.equals(that.transaction) : that.transaction != null);
    }

    public int hashCode() {
        int result = this.transaction != null ? this.transaction.hashCode() : 0;
        result = 29 * result + (this.globalTransaction != null ? this.globalTransaction.hashCode() : 0);
        result = 29 * result + (this.optionOverrides != null ? this.optionOverrides.hashCode() : 0);
        result = 29 * result + (this.originLocal ? 1 : 0);
        result = 29 * result + (this.txHasMods ? 1 : 0);
        result = 29 * result + (this.localRollbackOnly ? 1 : 0);
        return result;
    }

    public MethodCall getMethodCall() {
        return this.methodCall;
    }

    public void setMethodCall(MethodCall methodCall) {
        this.methodCall = methodCall;
    }

    public static InvocationContext fromMethodCall(MethodCall methodCall) {
        InvocationContext ctx = new InvocationContext();
        ctx.methodCall = methodCall;
        return ctx;
    }
}

