/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.UnknownHostException;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class GlobalTransactionTest {
    @Test(groups={"functional"})
    public void testEquality() throws UnknownHostException {
        IpAddress a1 = new IpAddress("localhost", 4444);
        GlobalTransaction tx1 = GlobalTransaction.create((Address)a1);
        GlobalTransaction tx2 = GlobalTransaction.create((Address)a1);
        System.out.println("\ntx1: " + tx1 + "\ntx2: " + tx2);
        AssertJUnit.assertTrue((!tx1.equals((Object)tx2) ? 1 : 0) != 0);
        tx2 = tx1;
        AssertJUnit.assertTrue((boolean)tx1.equals((Object)tx2));
    }

    @Test(groups={"functional"})
    public void testEqualityWithOtherObject() throws UnknownHostException {
        IpAddress a1 = new IpAddress("localhost", 4444);
        GlobalTransaction tx1 = GlobalTransaction.create((Address)a1);
        System.out.println("\ntx1: " + tx1);
        AssertJUnit.assertFalse((boolean)tx1.equals((Object)Thread.currentThread()));
    }

    @Test(groups={"functional"})
    public void testEqualityWithNull() throws UnknownHostException {
        IpAddress a1 = new IpAddress("localhost", 4444);
        GlobalTransaction tx1 = GlobalTransaction.create((Address)a1);
        System.out.println("\ntx1: " + tx1);
        AssertJUnit.assertFalse((boolean)tx1.equals(null));
    }

    @Test(groups={"functional"})
    public void testHashcode() throws UnknownHostException {
        IpAddress a1 = new IpAddress("localhost", 4444);
        GlobalTransaction tx1 = GlobalTransaction.create((Address)a1);
        GlobalTransaction tx2 = GlobalTransaction.create((Address)a1);
        System.out.println("\ntx1: " + tx1 + "\ntx2: " + tx2);
        AssertJUnit.assertTrue((!tx1.equals((Object)tx2) ? 1 : 0) != 0);
        int hcode_1 = tx1.hashCode();
        int hcode_2 = tx2.hashCode();
        AssertJUnit.assertFalse((hcode_1 == hcode_2 ? 1 : 0) != 0);
        tx2 = tx1;
        AssertJUnit.assertTrue((boolean)tx1.equals((Object)tx2));
        hcode_1 = tx1.hashCode();
        hcode_2 = tx2.hashCode();
        AssertJUnit.assertEquals((int)hcode_1, (int)hcode_2);
    }

    @Test(groups={"functional"})
    public void testExternalization() throws Exception {
        IpAddress a1 = new IpAddress("localhost", 4444);
        IpAddress a2 = new IpAddress("localhost", 5555);
        GlobalTransaction tx1_copy = null;
        GlobalTransaction tx2_copy = null;
        ByteArrayOutputStream bos = null;
        ByteArrayInputStream bis = null;
        ObjectOutputStream out = null;
        ObjectInputStream in = null;
        byte[] buf = null;
        GlobalTransaction tx1 = GlobalTransaction.create((Address)a1);
        GlobalTransaction tx2 = GlobalTransaction.create((Address)a2);
        bos = new ByteArrayOutputStream(1024);
        out = new ObjectOutputStream(bos);
        out.writeObject(tx1);
        out.writeObject(tx2);
        out.flush();
        buf = bos.toByteArray();
        bis = new ByteArrayInputStream(buf);
        in = new ObjectInputStream(bis);
        tx1_copy = (GlobalTransaction)in.readObject();
        tx2_copy = (GlobalTransaction)in.readObject();
        System.out.println("\ntx1: " + tx1 + ", tx1_copy: " + tx1_copy + "\ntx2: " + tx2 + ", tx2_copy: " + tx2_copy);
        AssertJUnit.assertNotNull((Object)tx1_copy);
        AssertJUnit.assertNotNull((Object)tx2_copy);
        AssertJUnit.assertEquals((Object)tx1, (Object)tx1_copy);
        AssertJUnit.assertEquals((Object)tx2, (Object)tx2_copy);
        int hcode_1 = tx1.hashCode();
        int hcode_2 = tx2.hashCode();
        int hcode_3 = tx1_copy.hashCode();
        int hcode_4 = tx2_copy.hashCode();
        AssertJUnit.assertFalse((hcode_1 == hcode_2 ? 1 : 0) != 0);
        AssertJUnit.assertFalse((hcode_3 == hcode_4 ? 1 : 0) != 0);
        AssertJUnit.assertEquals((int)hcode_1, (int)hcode_3);
        AssertJUnit.assertEquals((int)hcode_2, (int)hcode_4);
    }

    @Test(groups={"functional"})
    public void testWithNullAddress() {
        GlobalTransaction tx1 = GlobalTransaction.create(null);
        GlobalTransaction tx2 = GlobalTransaction.create(null);
        GlobalTransaction tmp_tx1 = tx1;
        AssertJUnit.assertEquals((Object)tx1, (Object)tmp_tx1);
        AssertJUnit.assertTrue((!tx1.equals((Object)tx2) ? 1 : 0) != 0);
    }

    @Test(groups={"functional"})
    public void testOneNullAddress() throws UnknownHostException {
        GlobalTransaction tx1 = GlobalTransaction.create(null);
        AssertJUnit.assertFalse((boolean)tx1.equals(null));
        GlobalTransaction tx2 = GlobalTransaction.create(null);
        AssertJUnit.assertFalse((boolean)tx1.equals((Object)tx2));
        AssertJUnit.assertFalse((boolean)tx2.equals((Object)tx1));
        IpAddress a1 = new IpAddress("localhost", 4444);
        tx2 = GlobalTransaction.create((Address)a1);
        AssertJUnit.assertFalse((boolean)tx1.equals((Object)tx2));
        AssertJUnit.assertFalse((boolean)tx2.equals((Object)tx1));
    }

    void log(String msg) {
        System.out.println("-- [" + Thread.currentThread() + "]: " + msg);
    }
}

