/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyGroupAssignmentTest;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.misc.TestingUtil;
import org.jgroups.Address;
import org.testng.AssertJUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuddyReplicationContentTest
extends BuddyReplicationTestsBase {
    private String key = "key";
    private String value = "value";
    private Log log = LogFactory.getLog(BuddyGroupAssignmentTest.class);

    private void assertNoStaleLocks(List<CacheImpl<Object, Object>> caches) {
        for (CacheImpl<Object, Object> cache : caches) {
            this.assertNoStaleLocks(cache);
        }
    }

    private void assertNoStaleLocks(CacheImpl<Object, Object> cache) {
        AssertJUnit.assertEquals((String)("Number of locks in cache instance " + cache.toString(true) + " should be 0"), (int)0, (int)cache.getNumberOfLocksHeld());
    }

    public void testSimplePut() throws Exception {
        this.log.debug((Object)"Running testSimplePut");
        this.caches = this.createCaches(3, false);
        String fqn = "/test";
        String backupFqn = "/_BUDDY_BACKUP_/" + BuddyManager.getGroupNameFromAddress((Object)((CacheImpl)this.caches.get(0)).getLocalAddress()) + fqn;
        this.assertNoStaleLocks(this.caches);
        ((CacheImpl)this.caches.get(0)).put(fqn, (Object)this.key, (Object)this.value);
        this.assertNoStaleLocks(this.caches);
        AssertJUnit.assertEquals((Object)this.value, (Object)((CacheImpl)this.caches.get(0)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)this.caches.get(1)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)this.caches.get(2)).get(fqn, (Object)this.key));
        AssertJUnit.assertEquals((String)"Buddy should have data in backup tree", (Object)this.value, (Object)((CacheImpl)this.caches.get(1)).get(backupFqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)this.caches.get(2)).get(backupFqn, (Object)this.key));
        this.assertNoStaleLocks(this.caches);
    }

    public void testPutAndRemove() throws Exception {
        this.log.debug((Object)"Running testPutAndRemove");
        this.caches = this.createCaches(3, false);
        String fqn = "/test";
        String backupFqn = "/_BUDDY_BACKUP_/" + BuddyManager.getGroupNameFromAddress((Object)((CacheImpl)this.caches.get(0)).getLocalAddress()) + fqn;
        this.assertNoStaleLocks(this.caches);
        ((CacheImpl)this.caches.get(0)).put(fqn, (Object)this.key, (Object)this.value);
        this.assertNoStaleLocks(this.caches);
        AssertJUnit.assertEquals((Object)this.value, (Object)((CacheImpl)this.caches.get(0)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)this.caches.get(1)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)this.caches.get(2)).get(fqn, (Object)this.key));
        AssertJUnit.assertEquals((String)"Buddy should have data in backup tree", (Object)this.value, (Object)((CacheImpl)this.caches.get(1)).get(backupFqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)this.caches.get(2)).get(backupFqn, (Object)this.key));
        this.assertNoStaleLocks(this.caches);
        ((CacheImpl)this.caches.get(0)).remove(fqn);
        this.assertNoStaleLocks(this.caches);
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)this.caches.get(0)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)this.caches.get(1)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)this.caches.get(2)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)this.caches.get(0)).get(backupFqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)this.caches.get(1)).get(backupFqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)this.caches.get(2)).get(backupFqn, (Object)this.key));
        this.assertNoStaleLocks(this.caches);
    }

    public void testPutAndRemove2() throws Exception {
        this.log.debug((Object)"Running testPutAndRemove2");
        this.caches = this.createCaches(2, 4, false);
        String fqn = "/test";
        String backupFqn = "/_BUDDY_BACKUP_/" + BuddyManager.getGroupNameFromAddress((Object)((CacheImpl)this.caches.get(0)).getLocalAddress()) + fqn;
        this.assertNoStaleLocks(this.caches);
        ((CacheImpl)this.caches.get(0)).put(fqn, (Object)this.key, (Object)this.value);
        this.assertNoStaleLocks(this.caches);
        AssertJUnit.assertEquals((Object)this.value, (Object)((CacheImpl)this.caches.get(0)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)this.caches.get(1)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)this.caches.get(2)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)this.caches.get(3)).get(fqn, (Object)this.key));
        AssertJUnit.assertEquals((String)"Buddy should have data in backup tree", (Object)this.value, (Object)((CacheImpl)this.caches.get(1)).get(backupFqn, (Object)this.key));
        AssertJUnit.assertEquals((String)"Buddy should have data in backup tree", (Object)this.value, (Object)((CacheImpl)this.caches.get(2)).get(backupFqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)this.caches.get(3)).get(backupFqn, (Object)this.key));
        this.assertNoStaleLocks(this.caches);
        ((CacheImpl)this.caches.get(0)).remove(fqn);
        this.assertNoStaleLocks(this.caches);
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)this.caches.get(0)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)this.caches.get(1)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)this.caches.get(2)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)this.caches.get(3)).get(fqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)this.caches.get(0)).get(backupFqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)this.caches.get(1)).get(backupFqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)this.caches.get(2)).get(backupFqn, (Object)this.key));
        AssertJUnit.assertNull((String)"Should be null", (Object)((CacheImpl)this.caches.get(3)).get(backupFqn, (Object)this.key));
        this.assertNoStaleLocks(this.caches);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBuddyJoin() throws Exception {
        this.log.debug((Object)"Running testBuddyJoin");
        this.caches = this.createCaches(2, false);
        CacheImpl<Object, Object> cache2 = null;
        try {
            Fqn fqn = Fqn.fromString((String)"/test");
            Fqn backupFqn = BuddyManager.getBackupFqn((Address)((CacheImpl)this.caches.get(1)).getLocalAddress(), (Fqn)fqn);
            this.assertNoStaleLocks(this.caches);
            ((CacheImpl)this.caches.get(1)).put(fqn, (Object)this.key, (Object)this.value);
            this.assertNoStaleLocks(this.caches);
            AssertJUnit.assertEquals((Object)this.value, (Object)((CacheImpl)this.caches.get(1)).get(fqn, (Object)this.key));
            AssertJUnit.assertFalse((String)"Should be false", (boolean)((CacheImpl)this.caches.get(0)).exists(fqn));
            AssertJUnit.assertEquals((String)"Buddy should have data in backup tree", (Object)this.value, (Object)((CacheImpl)this.caches.get(0)).get(backupFqn, (Object)this.key));
            this.assertNoStaleLocks(this.caches);
            cache2 = this.createCache(1, null);
            TestingUtil.blockUntilViewsReceived(3000L, new Cache[]{(Cache)this.caches.get(0), (Cache)this.caches.get(1), cache2});
            TestingUtil.sleepThread(2000L);
            ArrayList<CacheImpl<Object, Object>> dump = new ArrayList<CacheImpl<Object, Object>>(this.caches);
            dump.add(cache2);
            this.dumpCacheContents(dump);
            this.assertIsBuddy((CacheSPI)this.caches.get(1), (CacheSPI)cache2, true);
            this.assertIsBuddy((CacheSPI)this.caches.get(0), (CacheSPI)this.caches.get(1), true);
            this.assertIsBuddy((CacheSPI)cache2, (CacheSPI)this.caches.get(0), true);
            AssertJUnit.assertFalse((String)"This backup data should have been removed", (boolean)((CacheImpl)this.caches.get(0)).exists(backupFqn));
            AssertJUnit.assertEquals((String)"Backup state should have been transferred to this new cache instance", (Object)this.value, (Object)cache2.get(backupFqn, (Object)this.key));
            ((CacheImpl)this.caches.get(1)).remove(fqn);
            this.assertNoStaleLocks(this.caches);
            AssertJUnit.assertFalse((String)"Should be null", (boolean)((CacheImpl)this.caches.get(0)).exists(fqn));
            AssertJUnit.assertFalse((String)"Should be null", (boolean)((CacheImpl)this.caches.get(1)).exists(fqn));
            AssertJUnit.assertFalse((String)"Should be null", (boolean)cache2.exists(fqn));
            AssertJUnit.assertFalse((String)"Should be null", (boolean)((CacheImpl)this.caches.get(0)).exists(backupFqn));
            AssertJUnit.assertFalse((String)"Should be null", (boolean)((CacheImpl)this.caches.get(1)).exists(backupFqn));
            AssertJUnit.assertFalse((String)"Should be null", (boolean)cache2.exists(backupFqn));
            this.assertNoStaleLocks(this.caches);
        }
        finally {
            if (cache2 != null) {
                cache2.stop();
            }
        }
    }

    public void testCompleteStateSurvival() throws Exception {
        this.log.debug((Object)"Running testCompleteStateSurvival");
        this.caches = null;
        this.caches = this.createCaches(3, false, true);
        ((CacheImpl)this.caches.get(0)).put("/0", (Object)"key", (Object)"value");
        ((CacheImpl)this.caches.get(1)).put("/1", (Object)"key", (Object)"value");
        ((CacheImpl)this.caches.get(2)).put("/2", (Object)"key", (Object)"value");
        TestingUtil.sleepThread(this.getSleepTimeout());
        this.log.info((Object)"stopping 2");
        ((CacheImpl)this.caches.get(2)).stop();
        this.log.info((Object)("0 ** " + ((CacheImpl)this.caches.get(0)).printLockInfo()));
        this.log.info((Object)("1 ** " + ((CacheImpl)this.caches.get(1)).printLockInfo()));
        this.log.info((Object)("2 ** " + ((CacheImpl)this.caches.get(2)).printLockInfo()));
        TestingUtil.sleepThread(this.getSleepTimeout());
        AssertJUnit.assertEquals((Object)"value", (Object)((CacheImpl)this.caches.get(0)).get("/2", (Object)"key"));
        this.log.info((Object)("0 ** " + ((CacheImpl)this.caches.get(0)).printLockInfo()));
        this.log.info((Object)("1 ** " + ((CacheImpl)this.caches.get(1)).printLockInfo()));
        this.log.info((Object)("2 ** " + ((CacheImpl)this.caches.get(2)).printLockInfo()));
        TestingUtil.sleepThread(this.getSleepTimeout());
        ((CacheImpl)this.caches.get(1)).stop();
        this.log.info((Object)("0 ** " + ((CacheImpl)this.caches.get(0)).printLockInfo()));
        this.log.info((Object)("1 ** " + ((CacheImpl)this.caches.get(1)).printLockInfo()));
        this.log.info((Object)("2 ** " + ((CacheImpl)this.caches.get(2)).printLockInfo()));
        AssertJUnit.assertEquals((Object)"value", (Object)((CacheImpl)this.caches.get(0)).get("/0", (Object)"key"));
        try {
            AssertJUnit.assertEquals((Object)"value", (Object)((CacheImpl)this.caches.get(0)).get("/1", (Object)"key"));
        }
        catch (RuntimeException e) {
            AssertJUnit.assertEquals(IllegalArgumentException.class, e.getCause().getClass());
        }
        AssertJUnit.assertEquals((Object)"value", (Object)((CacheImpl)this.caches.get(0)).get("/1", (Object)"key"));
        AssertJUnit.assertEquals((Object)"value", (Object)((CacheImpl)this.caches.get(0)).get("/2", (Object)"key"));
    }
}

