/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jboss.cache.Fqn;
import org.jboss.cache.marshall.CacheMarshaller200;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class MethodIdPreservationTest {
    private Marshaller m = new CacheMarshaller200(null, false, false);
    private ObjectOutputStream stream;
    private ByteArrayOutputStream byteStream;
    private MethodCall call1;
    private MethodCall call2;
    private List<MethodCall> list = new ArrayList<MethodCall>(2);
    private MethodCall prepareCall;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.byteStream = new ByteArrayOutputStream();
        this.stream = new ObjectOutputStream(this.byteStream);
        this.call1 = MethodCallFactory.create((Method)MethodDeclarations.putDataMethodLocal, (Object[])new Object[]{null, Fqn.ROOT, null, null, true});
        this.call2 = MethodCallFactory.create((Method)MethodDeclarations.putDataMethodLocal, (Object[])new Object[]{null, Fqn.ROOT, null, null, true});
        this.list.clear();
        this.list.add(this.call1);
        this.list.add(this.call2);
        this.prepareCall = MethodCallFactory.create((Method)MethodDeclarations.prepareMethod, (Object[])new Object[]{null, this.list, null, true});
    }

    public void testSingleMethodCall() throws Exception {
        this.m.objectToObjectStream((Object)this.call1, this.stream);
        this.stream.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(this.byteStream.toByteArray()));
        Object result = this.m.objectFromObjectStream(in);
        AssertJUnit.assertEquals(this.call1.getClass(), result.getClass());
        MethodCall resultMethod = (MethodCall)result;
        AssertJUnit.assertEquals((int)this.call1.getMethodId(), (int)resultMethod.getMethodId());
    }

    public void testListOfMethodCalls() throws Exception {
        this.m.objectToObjectStream(this.list, this.stream);
        this.stream.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(this.byteStream.toByteArray()));
        Object result = this.m.objectFromObjectStream(in);
        AssertJUnit.assertEquals(this.list.getClass(), result.getClass());
        AssertJUnit.assertEquals((int)this.list.size(), (int)((List)result).size());
        MethodCall result1 = (MethodCall)((List)result).get(0);
        MethodCall result2 = (MethodCall)((List)result).get(1);
        AssertJUnit.assertEquals((int)this.call1.getMethodId(), (int)result1.getMethodId());
        AssertJUnit.assertEquals((int)this.call2.getMethodId(), (int)result2.getMethodId());
    }

    public void testMethodCallsInPrepare() throws Exception {
        this.m.objectToObjectStream((Object)this.prepareCall, this.stream);
        this.stream.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(this.byteStream.toByteArray()));
        Object result = this.m.objectFromObjectStream(in);
        AssertJUnit.assertEquals(this.prepareCall.getClass(), result.getClass());
        MethodCall prepareCallRes = (MethodCall)result;
        List listResult = (List)prepareCallRes.getArgs()[1];
        AssertJUnit.assertEquals((int)this.list.size(), (int)listResult.size());
        MethodCall result1 = (MethodCall)listResult.get(0);
        MethodCall result2 = (MethodCall)listResult.get(1);
        AssertJUnit.assertEquals((int)this.call1.getMethodId(), (int)result1.getMethodId());
        AssertJUnit.assertEquals((int)this.call2.getMethodId(), (int)result2.getMethodId());
    }
}

