/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.util.HashMap;
import java.util.Set;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.Fqn;
import org.jboss.cache.factories.InterceptorChainFactory;
import org.jboss.cache.interceptors.CallInterceptor;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.loader.SamplePojo;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.MockInterceptor;
import org.jboss.cache.optimistic.TestListener;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.transaction.TransactionTable;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public class NodeInterceptorRemoveNodeTest
extends AbstractOptimisticTestCase {
    private CacheImpl<Object, Object> cache;
    private TestListener listener;
    private MockInterceptor dummy;
    private TransactionManager mgr;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        Interceptor interceptor;
        this.listener = new TestListener();
        this.cache = this.createCacheWithListener(this.listener);
        this.dummy = new MockInterceptor();
        this.dummy.setCache(this.cache);
        Interceptor next = interceptor = (Interceptor)this.cache.getInterceptorChain().get(0);
        Interceptor prev = interceptor;
        while (!(next instanceof CallInterceptor)) {
            prev = next;
            next = next.getNext();
        }
        prev.setNext((Interceptor)this.dummy);
        InterceptorChainFactory.getInstance().setLastInterceptorPointer(interceptor, (Interceptor)this.dummy);
        this.cache.setInterceptorChain(interceptor);
        this.mgr = this.cache.getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        super.tearDown();
        this.cache.stop();
    }

    public void testTransactionRemoveNotExistsNodeMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx));
        this.cache.remove("/one/two");
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        this.mgr.commit();
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        AssertJUnit.assertEquals((int)0, (int)workspace.getNodes().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        AssertJUnit.assertEquals((int)0, (int)this.listener.getNodesAdded());
    }

    public void testTransactionRemoveNodeMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx));
        SamplePojo pojo = new SamplePojo(21, "test");
        HashMap<String, SamplePojo> temp = new HashMap<String, SamplePojo>();
        temp.put("key1", pojo);
        this.cache.put("/one/two", temp);
        this.cache.remove("/one/two");
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        this.mgr.commit();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one/two")).isDeleted());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((boolean)false, (boolean)workspace.getNode(Fqn.fromString((String)"/one")).isDeleted());
        AssertJUnit.assertEquals((int)1, (int)((Set)workspace.getNode(Fqn.fromString((String)"/one")).getMergedChildren().get(1)).size());
        AssertJUnit.assertEquals(null, (Object)workspace.getNode(Fqn.fromString((String)"/one")).getChild(Fqn.fromString((String)"/two")));
        System.out.println(entry.getModifications());
        AssertJUnit.assertEquals((int)2, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
    }

    public void testTransactionRemoveIntermediateNodeMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx));
        SamplePojo pojo = new SamplePojo(21, "test");
        HashMap<String, SamplePojo> temp = new HashMap<String, SamplePojo>();
        temp.put("key1", pojo);
        this.cache.put("/one/two", temp);
        this.cache.remove("/one");
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        this.mgr.commit();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one/two")).isDeleted());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one")).isDeleted());
        AssertJUnit.assertEquals((int)1, (int)((Set)workspace.getNode(Fqn.fromString((String)"/one")).getMergedChildren().get(0)).size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")).getChild(Fqn.fromString((String)"two")));
        AssertJUnit.assertEquals(null, (Object)workspace.getNode(Fqn.fromString((String)"/")).getChild(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((int)2, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
    }

    public void testTransactionRemoveTwiceMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx));
        SamplePojo pojo = new SamplePojo(21, "test");
        HashMap<String, SamplePojo> temp = new HashMap<String, SamplePojo>();
        temp.put("key1", pojo);
        this.cache.put("/one/two", temp);
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        workspace.getNode(Fqn.fromString((String)"/one"));
        workspace.getNode(Fqn.fromString((String)"/one/two"));
        this.cache.remove("/one");
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one/two")).isDeleted());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one")).isDeleted());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")).getChild(Fqn.fromString((String)"two")));
        AssertJUnit.assertEquals(null, (Object)workspace.getNode(Fqn.fromString((String)"/")).getChild(Fqn.fromString((String)"one")));
        this.cache.remove("/one");
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one/two")).isDeleted());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one")).isDeleted());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")).getChild(Fqn.fromString((String)"two")));
        AssertJUnit.assertEquals(null, (Object)workspace.getNode(Fqn.fromString((String)"/")).getChild(Fqn.fromString((String)"one")));
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        this.mgr.commit();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertEquals((int)3, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
    }

    public void testTransactionRemovePutNodeMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx));
        SamplePojo pojo = new SamplePojo(21, "test");
        HashMap<String, SamplePojo> temp = new HashMap<String, SamplePojo>();
        temp.put("key1", pojo);
        this.cache.put("/one/two", temp);
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        WorkspaceNode one = workspace.getNode(Fqn.fromString((String)"/one"));
        WorkspaceNode two = workspace.getNode(Fqn.fromString((String)"/one/two"));
        this.cache.remove("/one");
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one/two")).isDeleted());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one")).isDeleted());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")).getChild(Fqn.fromString((String)"two")));
        AssertJUnit.assertEquals(null, (Object)workspace.getNode(Fqn.fromString((String)"/")).getChild(Fqn.fromString((String)"one")));
        this.cache.put("/one/two", temp);
        WorkspaceNode oneAfter = workspace.getNode(Fqn.fromString((String)"/one"));
        WorkspaceNode twoAfter = workspace.getNode(Fqn.fromString((String)"/one/two"));
        AssertJUnit.assertNotSame((Object)one, (Object)oneAfter);
        AssertJUnit.assertEquals((boolean)false, (boolean)oneAfter.isDeleted());
        AssertJUnit.assertNotSame((Object)two, (Object)twoAfter);
        AssertJUnit.assertEquals((boolean)false, (boolean)twoAfter.isDeleted());
        AssertJUnit.assertEquals((Object)twoAfter.getNode(), (Object)workspace.getNode(Fqn.fromString((String)"/one")).getChild(Fqn.fromString((String)"two")));
        AssertJUnit.assertEquals((Object)oneAfter.getNode(), (Object)workspace.getNode(Fqn.fromString((String)"/")).getChild(Fqn.fromString((String)"one")));
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        this.mgr.commit();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertEquals((int)3, (int)entry.getModifications().size());
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        AssertJUnit.assertEquals((int)4, (int)this.listener.getNodesAdded());
    }

    public void testTransactionRemovePutkeyValMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx));
        SamplePojo pojo = new SamplePojo(21, "test");
        HashMap<String, SamplePojo> temp = new HashMap<String, SamplePojo>();
        temp.put("key1", pojo);
        this.cache.put("/one/two", temp);
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        WorkspaceNode one = workspace.getNode(Fqn.fromString((String)"/one"));
        WorkspaceNode two = workspace.getNode(Fqn.fromString((String)"/one/two"));
        this.cache.remove("/one");
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one/two")).isDeleted());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one")).isDeleted());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")).getChild(Fqn.fromString((String)"two")));
        AssertJUnit.assertEquals(null, (Object)workspace.getNode(Fqn.fromString((String)"/")).getChild(Fqn.fromString((String)"one")));
        SamplePojo pojo2 = new SamplePojo(21, "test");
        this.cache.put(new Fqn(new Object[]{"one"}), (Object)"key1", (Object)pojo2);
        WorkspaceNode oneAfter = workspace.getNode(Fqn.fromString((String)"/one"));
        WorkspaceNode twoAfter = workspace.getNode(Fqn.fromString((String)"/one/two"));
        AssertJUnit.assertNotSame((Object)one, (Object)oneAfter);
        AssertJUnit.assertEquals((boolean)false, (boolean)oneAfter.isDeleted());
        AssertJUnit.assertEquals((Object)two, (Object)twoAfter);
        AssertJUnit.assertEquals((boolean)true, (boolean)twoAfter.isDeleted());
        AssertJUnit.assertNull((Object)workspace.getNode(Fqn.fromString((String)"/one")).getChild(Fqn.fromString((String)"two")));
        AssertJUnit.assertEquals((Object)oneAfter.getNode(), (Object)workspace.getNode(Fqn.fromString((String)"/")).getChild(Fqn.fromString((String)"one")));
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        this.mgr.commit();
        AssertJUnit.assertEquals((Object)pojo2, (Object)workspace.getNode(Fqn.fromString((String)"/one")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertEquals((int)3, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        AssertJUnit.assertEquals((int)3, (int)this.listener.getNodesAdded());
    }

    public void testTransactionRemoveSubNodeMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx));
        SamplePojo pojo = new SamplePojo(21, "test");
        HashMap<String, SamplePojo> temp = new HashMap<String, SamplePojo>();
        temp.put("key1", pojo);
        this.cache.put("/one/two", temp);
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        WorkspaceNode one = workspace.getNode(Fqn.fromString((String)"/one"));
        AssertJUnit.assertEquals((int)1, (int)((Set)one.getMergedChildren().get(0)).size());
        this.cache.remove("/one/two");
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one/two")).isDeleted());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((boolean)false, (boolean)workspace.getNode(Fqn.fromString((String)"/one")).isDeleted());
        AssertJUnit.assertEquals(null, (Object)workspace.getNode(Fqn.fromString((String)"/one")).getChild(Fqn.fromString((String)"two")));
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        this.mgr.commit();
        AssertJUnit.assertEquals((int)1, (int)((Set)workspace.getNode(Fqn.fromString((String)"/one")).getMergedChildren().get(1)).size());
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertEquals((int)2, (int)entry.getModifications().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalled());
        AssertJUnit.assertEquals((int)2, (int)this.listener.getNodesAdded());
    }
}

