package org.jboss.cache.pojo;

import static org.testng.AssertJUnit.assertEquals;
import static org.testng.AssertJUnit.assertNull;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.pojo.test.SerializedAddress;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;


/**
 * Test for Serializable POJOs
 *
 * @author Ben Wang
 */

@Test(groups = {"functional"})
public class NonAspectizedTest 
{
   Log log_ = LogFactory.getLog(NonAspectizedTest.class);
   PojoCache cache_;


   @BeforeMethod(alwaysRun = true)
   protected void setUp() throws Exception
   {
      log_.info("setUp() ....");
      String configFile = "META-INF/local-service.xml";
      boolean toStart = false;
      cache_ = PojoCacheFactory.createCache(configFile, toStart);
      cache_.start();
   }

   @AfterMethod(alwaysRun = true)
   protected void tearDown() throws Exception
   {
      cache_.stop();
   }

//   public void testDummy() {}

   public void testPutPrimitive() throws Exception
   {
      log_.info("testPutPrimitive() ....");
      String test = "test";
      cache_.attach("/a", test);
      String result = (String) cache_.find("/a");
      assertEquals("test string ", "test", result);
      cache_.detach("/a");
      assertNull("Object should be null ", cache_.find("/a"));
   }

   public void testPutSerializable() throws Exception
   {
      log_.info("testPutSerializable() ....");
      SerializedAddress test = new SerializedAddress();
      test.setCity("Sunnyvale");
      test.setZip(94086);
      cache_.attach("/a", test);
      SerializedAddress result = (SerializedAddress) cache_.find("/a");
      assertEquals("test SerializedAddress ", test, result);
      cache_.detach("/a");
      assertNull("Object should be null ", cache_.find("/a"));
   }




}

