/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.cache.pojo.notification;

import java.util.LinkedList;
import java.util.Queue;

import net.jcip.annotations.NotThreadSafe;

import org.jboss.cache.pojo.notification.annotation.Attached;
import org.jboss.cache.pojo.notification.annotation.Detached;
import org.jboss.cache.pojo.notification.annotation.FieldModified;
import org.jboss.cache.pojo.notification.annotation.ListModified;
import org.jboss.cache.pojo.notification.annotation.MapModified;
import org.jboss.cache.pojo.notification.annotation.PojoCacheListener;
import org.jboss.cache.pojo.notification.annotation.SetModified;
import org.jboss.cache.pojo.notification.event.Event;

// $Id: Listener.java 4103 2007-07-03 01:45:58Z jgreene $

/**
 * A recoding Listener for notification test package. This is not thread safe, just for testing.
 *
 * @author Jason T. Greene
 */
@PojoCacheListener
@NotThreadSafe
public class Listener
{
   private Queue<Event> events = new LinkedList<Event>();

   @SuppressWarnings("unchecked")
   public <T extends Event> T take(Class<T> t)
   {
      Event notification = events.remove();
      if (!t.isInstance(notification))
         throw new IllegalStateException("Expected notification type: " + t.getSimpleName() + " but was: " + notification.getClass().getSimpleName());

      return (T) notification;
   }

   public void clear()
   {
      events.clear();
   }

   @Attached
   @Detached
   @FieldModified
   @ListModified
   @SetModified
   @MapModified
   public void handle(Event event)
   {
      events.offer(event);
   }
}