/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api;

import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.LRUConfiguration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.misc.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ResidentNodesTest {
    private CacheImpl<Object, Object> cache;
    private final String TEST_NODES_ROOT = "residentNodesTest";
    private Configuration cacheConfig;
    private Cache[] caches = new Cache[0];

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        this.cacheConfig = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, true);
        this.cacheConfig.setCacheMode(Configuration.CacheMode.LOCAL);
        this.cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache(this.cacheConfig, false);
        this.cache.getConfiguration().getEvictionConfig().setWakeupIntervalSeconds(1);
        this.createNewRegion();
        this.cache.start();
    }

    private void createNewRegion() {
        EvictionConfig evConfig = this.cache.getConfiguration().getEvictionConfig();
        EvictionRegionConfig evRegConfig = new EvictionRegionConfig();
        evRegConfig.setRegionFqn(Fqn.fromString((String)"/residentNodesTest"));
        evRegConfig.setEventQueueSize(100);
        LRUConfiguration lruConfig = new LRUConfiguration();
        lruConfig.setMaxAgeSeconds(100000);
        lruConfig.setTimeToLiveSeconds(100000);
        lruConfig.setMaxNodes(3);
        evRegConfig.setEvictionPolicyConfig((EvictionPolicyConfig)lruConfig);
        evConfig.getEvictionRegionConfigs().add(evRegConfig);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cache.stop();
        for (Cache c : this.caches) {
            if (c == null) continue;
            c.stop();
        }
    }

    public void testHappyFlow() throws InterruptedException {
        this.cache.put(this.getSubFqn("/a"), (Object)"k_a", (Object)"v_a");
        this.cache.get(this.getSubFqn("/a")).setResident(true);
        this.cache.put(this.getSubFqn("/b"), (Object)"k_b", (Object)"v_b");
        this.cache.get(this.getSubFqn("/b")).setResident(true);
        this.cache.put(this.getSubFqn("/c"), (Object)"k_c", (Object)"v_c");
        this.cache.put(this.getSubFqn("/d"), (Object)"k_d", (Object)"v_d");
        this.cache.put(this.getSubFqn("/e"), (Object)"k_e", (Object)"v_e");
        this.cache.put(this.getSubFqn("/f"), (Object)"k_f", (Object)"v_f");
        this.cache.put(this.getSubFqn("/g"), (Object)"k_g", (Object)"v_g");
        this.cache.put(this.getSubFqn("/h"), (Object)"k_h", (Object)"v_h");
        this.cache.put(this.getSubFqn("/i"), (Object)"k_i", (Object)"v_i");
        Thread.sleep(3000L);
        Assert.assertTrue((boolean)this.cache.exists(this.getSubFqn("/a")));
        Assert.assertTrue((boolean)this.cache.exists(this.getSubFqn("/b")));
        Assert.assertFalse((boolean)this.cache.exists(this.getSubFqn("/c")));
        Assert.assertFalse((boolean)this.cache.exists(this.getSubFqn("/d")));
        Assert.assertFalse((boolean)this.cache.exists(this.getSubFqn("/e")));
        Assert.assertFalse((boolean)this.cache.exists(this.getSubFqn("/f")));
        Assert.assertTrue((boolean)this.cache.exists(this.getSubFqn("/g")));
        Assert.assertTrue((boolean)this.cache.exists(this.getSubFqn("/h")));
        Assert.assertTrue((boolean)this.cache.exists(this.getSubFqn("/i")));
    }

    public void testNoEvictionEventsForResidentNodes() throws InterruptedException {
        this.cache.put(this.getSubFqn("/a"), (Object)"k_a", (Object)"v_a");
        this.cache.put(this.getSubFqn("/b"), (Object)"k_b", (Object)"v_b");
        this.cache.get(this.getSubFqn("/a")).setResident(true);
        this.cache.get(this.getSubFqn("/b")).setResident(true);
        this.cache.put(this.getSubFqn("/c"), (Object)"k_c", (Object)"v_c");
        this.cache.put(this.getSubFqn("/d"), (Object)"k_d", (Object)"v_d");
        this.cache.put(this.getSubFqn("/e"), (Object)"k_e", (Object)"v_e");
        this.cache.put(this.getSubFqn("/f"), (Object)"k_f", (Object)"v_f");
        this.cache.put(this.getSubFqn("/g"), (Object)"k_g", (Object)"v_g");
        this.cache.put(this.getSubFqn("/h"), (Object)"k_h", (Object)"v_h");
        this.cache.get(this.getSubFqn("/a"));
        this.cache.get(this.getSubFqn("/b"));
        TestingUtil.sleepThread(3000L);
        Assert.assertTrue((boolean)this.cache.exists(this.getSubFqn("/a")));
        Assert.assertTrue((boolean)this.cache.exists(this.getSubFqn("/b")));
        Assert.assertFalse((boolean)this.cache.exists(this.getSubFqn("/c")));
        Assert.assertFalse((boolean)this.cache.exists(this.getSubFqn("/d")));
        Assert.assertFalse((boolean)this.cache.exists(this.getSubFqn("/e")));
        Assert.assertTrue((boolean)this.cache.exists(this.getSubFqn("/f")));
        Assert.assertTrue((boolean)this.cache.exists(this.getSubFqn("/g")));
        Assert.assertTrue((boolean)this.cache.exists(this.getSubFqn("/h")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResidencyAndOptimisticLocking() throws Exception {
        Configuration config = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, true);
        config.setCacheMode(Configuration.CacheMode.LOCAL);
        config.setNodeLockingOptimistic(true);
        CacheImpl cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache(config, true);
        cache.put(Fqn.fromString((String)"/a/b"), (Object)"key", (Object)"value");
        TransactionManager txManager = cache.getTransactionManager();
        txManager.begin();
        cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).setResident(true);
        cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).put((Object)"k2", (Object)"v2");
        Assert.assertEquals((int)cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).getKeys().size(), (int)2);
        txManager.rollback();
        Assert.assertTrue((boolean)cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).isResident());
        txManager.begin();
        cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).setResident(false);
        cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).put((Object)"k2", (Object)"v2");
        Assert.assertEquals((int)cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).getKeys().size(), (int)2);
        txManager.commit();
        Assert.assertFalse((boolean)cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).isResident());
        Assert.assertEquals((int)cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).getKeys().size(), (int)2);
        try {
            if (cache.getTransactionManager().getTransaction() != null) {
                cache.getTransactionManager().rollback();
            }
        }
        finally {
            cache.stop();
        }
    }

    public void testResidencyAndPesimistickLocking() throws Exception {
        this.cache.put(Fqn.fromString((String)"/a/b"), (Object)"key", (Object)"value");
        TransactionManager txManager = this.cache.getTransactionManager();
        txManager.begin();
        this.cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).setResident(true);
        this.cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).put((Object)"k2", (Object)"v2");
        Assert.assertEquals((int)this.cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).getKeys().size(), (int)2);
        txManager.rollback();
        Assert.assertTrue((boolean)this.cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).isResident());
        txManager.begin();
        this.cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).setResident(false);
        this.cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).put((Object)"k2", (Object)"v2");
        Assert.assertEquals((int)this.cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).getKeys().size(), (int)2);
        txManager.commit();
        Assert.assertFalse((boolean)this.cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).isResident());
        Assert.assertEquals((int)this.cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).getKeys().size(), (int)2);
    }

    private Fqn getSubFqn(String str) {
        return Fqn.fromString((String)("/residentNodesTest" + str));
    }
}

