/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.misc.TestingUtil;

public class BuddyGroupAssignmentTest
extends BuddyReplicationTestsBase {
    private Log log = LogFactory.getLog(BuddyGroupAssignmentTest.class);

    public void testSingleBuddy() throws Exception {
        this.log.debug((Object)"Running testSingleBuddy");
        this.caches = this.createCaches(3, false);
        for (CacheImpl cache : this.caches) {
            this.printBuddyGroup((CacheSPI)cache);
        }
        System.out.println("*** Testing cache 0:");
        this.assertIsBuddy((CacheSPI)this.caches.get(0), (CacheSPI)this.caches.get(1), true);
        System.out.println("*** Testing cache 1:");
        this.assertIsBuddy((CacheSPI)this.caches.get(1), (CacheSPI)this.caches.get(2), true);
        System.out.println("*** Testing cache 2:");
        this.assertIsBuddy((CacheSPI)this.caches.get(2), (CacheSPI)this.caches.get(0), true);
    }

    public void test2Buddies() throws Exception {
        this.log.debug((Object)"Running test2Buddies");
        this.caches = this.createCaches(2, 3, false);
        TestingUtil.blockUntilViewsReceived(5000L, this.caches.toArray(new Cache[0]));
        TestingUtil.sleepThread(2000L);
        System.out.println("*** Testing cache 0");
        this.assertIsBuddy((CacheSPI)this.caches.get(0), (CacheSPI)this.caches.get(1), false);
        this.assertIsBuddy((CacheSPI)this.caches.get(0), (CacheSPI)this.caches.get(2), false);
        System.out.println("*** Testing cache 1");
        this.assertIsBuddy((CacheSPI)this.caches.get(1), (CacheSPI)this.caches.get(2), false);
        this.assertIsBuddy((CacheSPI)this.caches.get(1), (CacheSPI)this.caches.get(0), false);
        System.out.println("*** Testing cache 2");
        this.assertIsBuddy((CacheSPI)this.caches.get(2), (CacheSPI)this.caches.get(1), false);
        this.assertIsBuddy((CacheSPI)this.caches.get(2), (CacheSPI)this.caches.get(0), false);
    }

    public void testRemovalFromClusterSingleBuddy() throws Exception {
        this.log.debug((Object)"Running testRemovalFromClusterSingleBuddy");
        this.caches = this.createCaches(3, false);
        System.out.println("*** Testing cache 0");
        this.assertIsBuddy((CacheSPI)this.caches.get(0), (CacheSPI)this.caches.get(1), true);
        System.out.println("*** Testing cache 1");
        this.assertIsBuddy((CacheSPI)this.caches.get(1), (CacheSPI)this.caches.get(2), true);
        System.out.println("*** Testing cache 2");
        this.assertIsBuddy((CacheSPI)this.caches.get(2), (CacheSPI)this.caches.get(0), true);
        ((CacheImpl)this.caches.get(1)).stop();
        this.caches.set(1, null);
        TestingUtil.sleepThread(this.getSleepTimeout());
        System.out.println("*** Testing cache 0");
        this.assertIsBuddy((CacheSPI)this.caches.get(0), (CacheSPI)this.caches.get(2), true);
        System.out.println("*** Testing cache 2");
        this.assertIsBuddy((CacheSPI)this.caches.get(2), (CacheSPI)this.caches.get(0), true);
        System.out.println("*** Completed successfully ***");
        this.assertNoLocks(this.caches);
    }

    public void testRemovalFromCluster2Buddies() throws Exception {
        this.log.debug((Object)"Running testRemovalFromCluster2Buddies");
        this.caches = this.createCaches(2, 4, false);
        this.assertNoLocks(this.caches);
        System.out.println("*** Testing cache 0");
        this.assertIsBuddy((CacheSPI)this.caches.get(0), (CacheSPI)this.caches.get(1), false);
        this.assertIsBuddy((CacheSPI)this.caches.get(0), (CacheSPI)this.caches.get(2), false);
        System.out.println("*** Testing cache 1");
        this.assertIsBuddy((CacheSPI)this.caches.get(1), (CacheSPI)this.caches.get(2), false);
        this.assertIsBuddy((CacheSPI)this.caches.get(1), (CacheSPI)this.caches.get(3), false);
        System.out.println("*** Testing cache 2");
        this.assertIsBuddy((CacheSPI)this.caches.get(2), (CacheSPI)this.caches.get(3), false);
        this.assertIsBuddy((CacheSPI)this.caches.get(2), (CacheSPI)this.caches.get(0), false);
        System.out.println("*** Testing cache 3");
        this.assertIsBuddy((CacheSPI)this.caches.get(3), (CacheSPI)this.caches.get(0), false);
        this.assertIsBuddy((CacheSPI)this.caches.get(3), (CacheSPI)this.caches.get(1), false);
        ((CacheImpl)this.caches.get(1)).stop();
        this.caches.set(1, null);
        TestingUtil.sleepThread(this.getSleepTimeout());
        System.out.println("*** Testing cache 0");
        this.assertIsBuddy((CacheSPI)this.caches.get(0), (CacheSPI)this.caches.get(2), false);
        this.assertIsBuddy((CacheSPI)this.caches.get(0), (CacheSPI)this.caches.get(3), false);
        System.out.println("*** Testing cache 2");
        this.assertIsBuddy((CacheSPI)this.caches.get(2), (CacheSPI)this.caches.get(3), false);
        this.assertIsBuddy((CacheSPI)this.caches.get(2), (CacheSPI)this.caches.get(0), false);
        System.out.println("*** Testing cache 3");
        this.assertIsBuddy((CacheSPI)this.caches.get(3), (CacheSPI)this.caches.get(0), false);
        this.assertIsBuddy((CacheSPI)this.caches.get(3), (CacheSPI)this.caches.get(2), false);
        this.assertNoLocks(this.caches);
    }
}

