/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import javax.transaction.TransactionManager;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.Fqn;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.testng.annotations.AfterMethod;

public class ThreadedCacheAccessTest
extends AbstractOptimisticTestCase {
    private static final Log log = LogFactory.getLog(ThreadedCacheAccessTest.class);
    private final int numThreads = 5;
    private final int numLoopsPerThread = 25;
    private final int writeFrequency = 5;
    private final int minSleep = 0;
    private final int maxSleep = 100;
    private final Fqn fqn = Fqn.fromString((String)"/a/b");
    private final String key = "key";
    private final String value = "value";
    private CacheImpl<Object, Object> cache;
    private WorkerThread[] threads;

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        super.tearDown();
        this.destroyCache((Cache<Object, Object>)this.cache);
    }

    public void testThreadedMostlyReads() throws Exception {
        int i;
        this.cache = this.createCache();
        this.cache.put(this.fqn, (Object)"key", (Object)"value");
        this.threads = new WorkerThread[5];
        for (i = 0; i < 5; ++i) {
            this.threads[i] = new WorkerThread();
            this.threads[i].start();
        }
        for (i = 0; i < 5; ++i) {
            this.threads[i].join();
        }
        for (i = 0; i < 5; ++i) {
            Assert.assertTrue((String)"Thread threw an exception!", (boolean)this.threads[i].success);
        }
    }

    public class WorkerThread
    extends Thread {
        public boolean success = true;

        public void run() {
            log.debug((Object)(this.getName() + " starting up ... "));
            for (int j = 0; j < 25; ++j) {
                TransactionManager tm = ThreadedCacheAccessTest.this.cache.getTransactionManager();
                try {
                    tm.begin();
                    ThreadedCacheAccessTest.this.cache.get(ThreadedCacheAccessTest.this.fqn, (Object)"key");
                    if (j % 5 == 0) {
                        ThreadedCacheAccessTest.this.cache.put(ThreadedCacheAccessTest.this.fqn, (Object)"key", (Object)("value" + j));
                    }
                    tm.commit();
                }
                catch (Exception e) {
                    log.error((Object)"Caught Exception!", (Throwable)e);
                    Assert.assertTrue((String)"Caught Exception!", (boolean)false);
                    this.success = false;
                    try {
                        tm.rollback();
                    }
                    catch (Exception e2) {
                        log.error((Object)"Rollback failed!", (Throwable)e2);
                    }
                    break;
                }
                ThreadedCacheAccessTest.this.randomSleep(0, 100);
            }
        }
    }
}

