/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class LOOPBACK
extends Protocol {
    private Address local_addr = null;
    private String group_addr = null;

    public String toString() {
        return "LOOPBACK(local address: " + this.local_addr + ')';
    }

    public String getName() {
        return "LOOPBACK";
    }

    public void init() throws Exception {
        this.local_addr = new IpAddress(12345);
    }

    public void start() throws Exception {
        this.up_prot.up(new Event(8, this.local_addr));
    }

    public Object down(Event evt) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("event is " + evt + ", group_addr=" + this.group_addr + ", time is " + System.currentTimeMillis() + ", hdrs: " + Util.printEvent(evt)));
        }
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Message rsp = msg.copy();
                if (rsp.getSrc() == null) {
                    rsp.setSrc(this.local_addr);
                }
                this.up(new Event(1, rsp));
                break;
            }
            case 2: 
            case 80: {
                this.group_addr = (String)evt.getArg();
                break;
            }
            case 47: {
                this.up_prot.up(evt);
            }
        }
        return null;
    }
}

