/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.stack.Interval;
import org.jgroups.stack.Retransmitter;
import org.jgroups.stack.StaticInterval;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class AckSenderWindow
implements Retransmitter.RetransmitCommand {
    RetransmitCommand retransmit_command = null;
    final ConcurrentMap<Long, Message> msgs = new ConcurrentHashMap<Long, Message>();
    Interval interval = new StaticInterval(400L, 800L, 1200L, 1600L);
    final Retransmitter retransmitter;
    static final Log log = LogFactory.getLog(AckSenderWindow.class);

    public AckSenderWindow(RetransmitCommand com) {
        this.retransmit_command = com;
        this.retransmitter = new Retransmitter(null, this);
        this.retransmitter.setRetransmitTimeouts(this.interval);
    }

    public AckSenderWindow(RetransmitCommand com, Interval interval) {
        this.retransmit_command = com;
        this.interval = interval;
        this.retransmitter = new Retransmitter(null, this);
        this.retransmitter.setRetransmitTimeouts(interval);
    }

    public AckSenderWindow(RetransmitCommand com, Interval interval, TimeScheduler sched) {
        this.retransmit_command = com;
        this.interval = interval;
        this.retransmitter = new Retransmitter(null, this, sched);
        this.retransmitter.setRetransmitTimeouts(interval);
    }

    public AckSenderWindow(RetransmitCommand com, Interval interval, TimeScheduler sched, Address sender) {
        this.retransmit_command = com;
        this.interval = interval;
        this.retransmitter = new Retransmitter(sender, this, sched);
        this.retransmitter.setRetransmitTimeouts(interval);
    }

    public void reset() {
        this.msgs.clear();
        this.retransmitter.reset();
    }

    public void add(long seqno, Message msg) {
        Long tmp = new Long(seqno);
        this.msgs.putIfAbsent(tmp, msg);
        this.retransmitter.add(seqno, seqno);
    }

    public void ack(long seqno) {
        this.msgs.remove(new Long(seqno));
        this.retransmitter.remove(seqno);
    }

    public int size() {
        return this.msgs.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.msgs.size()).append(" msgs (").append(this.retransmitter.size()).append(" to retransmit): ");
        TreeSet keys = new TreeSet(this.msgs.keySet());
        if (!keys.isEmpty()) {
            sb.append(keys.first()).append(" - ").append(keys.last());
        } else {
            sb.append("[]");
        }
        return sb.toString();
    }

    public String printDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.msgs.size()).append(" msgs (").append(this.retransmitter.size()).append(" to retransmit): ").append(new TreeSet(this.msgs.keySet()));
        return sb.toString();
    }

    public void retransmit(long first_seqno, long last_seqno, Address sender) {
        if (this.retransmit_command != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)new StringBuilder("retransmitting messages ").append(first_seqno).append(" - ").append(last_seqno).append(" from ").append(sender));
            }
            for (long i = first_seqno; i <= last_seqno; ++i) {
                Message msg = (Message)this.msgs.get(new Long(i));
                if (msg == null) continue;
                this.retransmit_command.retransmit(i, msg);
            }
        }
    }

    public static void main(String[] args) {
        int i;
        StaticInterval xmit_timeouts = new StaticInterval(1000L, 2000L, 3000L, 4000L);
        AckSenderWindow win = new AckSenderWindow(new Dummy(), xmit_timeouts);
        int NUM = 1000;
        for (i = 1; i < 1000; ++i) {
            win.add(i, new Message());
        }
        System.out.println(win);
        Util.sleep(5000L);
        for (i = 1; i < 1000; ++i) {
            if (i % 2 != 0) continue;
            win.ack(i);
        }
        System.out.println(win);
        Util.sleep(4000L);
        for (i = 1; i < 1000; ++i) {
            if (i % 2 == 0) continue;
            win.ack(i);
        }
        System.out.println(win);
        win.add(3L, new Message());
        win.add(5L, new Message());
        win.add(4L, new Message());
        win.add(8L, new Message());
        win.add(9L, new Message());
        win.add(6L, new Message());
        win.add(7L, new Message());
        win.add(3L, new Message());
        System.out.println(win);
        try {
            Thread.sleep(5000L);
            win.ack(5L);
            System.out.println("ack(5)");
            win.ack(4L);
            System.out.println("ack(4)");
            win.ack(6L);
            System.out.println("ack(6)");
            win.ack(7L);
            System.out.println("ack(7)");
            win.ack(8L);
            System.out.println("ack(8)");
            win.ack(6L);
            System.out.println("ack(6)");
            win.ack(9L);
            System.out.println("ack(9)");
            System.out.println(win);
            Thread.sleep(5000L);
            win.ack(3L);
            System.out.println("ack(3)");
            System.out.println(win);
            Thread.sleep(3000L);
            win.add(10L, new Message());
            win.add(11L, new Message());
            System.out.println(win);
            Thread.sleep(3000L);
            win.ack(10L);
            System.out.println("ack(10)");
            win.ack(11L);
            System.out.println("ack(11)");
            System.out.println(win);
            win.add(12L, new Message());
            win.add(13L, new Message());
            win.add(14L, new Message());
            win.add(15L, new Message());
            win.add(16L, new Message());
            System.out.println(win);
            Util.sleep(1000L);
            win.ack(12L);
            System.out.println("ack(12)");
            win.ack(13L);
            System.out.println("ack(13)");
            win.ack(15L);
            System.out.println("ack(15)");
            System.out.println(win);
            Util.sleep(5000L);
            win.ack(16L);
            System.out.println("ack(16)");
            System.out.println(win);
            Util.sleep(1000L);
            win.ack(14L);
            System.out.println("ack(14)");
            System.out.println(win);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    static class Dummy
    implements RetransmitCommand {
        static final long last_xmit_req = 0L;
        long curr_time;

        Dummy() {
        }

        public void retransmit(long seqno, Message msg) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("seqno=" + seqno));
            }
            this.curr_time = System.currentTimeMillis();
        }
    }

    static class Entry {
        final long seqno;
        final Message msg;

        Entry(long seqno, Message msg) {
            this.seqno = seqno;
            this.msg = msg;
        }
    }

    public static interface RetransmitCommand {
        public void retransmit(long var1, Message var3);
    }
}

