/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.NodeFactory;
import org.jboss.cache.NodeNotExistsException;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.RPCManager;
import org.jboss.cache.RPCManagerImpl;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.ReplicationException;
import org.jboss.cache.ReplicationQueue;
import org.jboss.cache.SuspectException;
import org.jboss.cache.Version;
import org.jboss.cache.buddyreplication.BuddyGroup;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.BuddyNotInitException;
import org.jboss.cache.buddyreplication.GravitateResult;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Option;
import org.jboss.cache.config.RuntimeConfig;
import org.jboss.cache.factories.InterceptorChainFactory;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.CacheLoaderManager;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.LockStrategyFactory;
import org.jboss.cache.lock.LockUtil;
import org.jboss.cache.lock.LockingException;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.marshall.InactiveRegionAwareRpcDispatcher;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.marshall.NodeData;
import org.jboss.cache.marshall.VersionAwareMarshaller;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.statetransfer.StateTransferManager;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.transaction.TransactionEntry;
import org.jboss.cache.transaction.TransactionManagerLookup;
import org.jboss.cache.transaction.TransactionTable;
import org.jboss.cache.util.ExposedByteArrayOutputStream;
import org.jboss.cache.util.ThreadGate;
import org.jboss.cache.util.Util;
import org.jboss.cache.util.concurrent.ConcurrentHashSet;
import org.jboss.util.stream.MarshalledValueInputStream;
import org.jboss.util.stream.MarshalledValueOutputStream;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelFactory;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.ExtendedMembershipListener;
import org.jgroups.ExtendedMessageListener;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.StateTransferException;
import org.jgroups.View;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RspFilter;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheImpl<K, V>
implements CacheSPI<K, V> {
    private Log log = LogFactory.getLog(CacheImpl.class);
    private final ThreadGate flushBlockGate = new ThreadGate();
    private NodeSPI<K, V> root;
    private RegionManager regionManager = null;
    protected Channel channel = null;
    private volatile boolean coordinator = false;
    private final Vector<Address> members = new Vector();
    private RpcDispatcher disp = null;
    private MessageListenerAdaptor ml = new MessageListenerAdaptor();
    private final TransactionTable tx_table = new TransactionTable();
    private Map<Thread, List<NodeLock>> lock_table;
    private Set<Fqn> internalFqns = new ConcurrentHashSet<Fqn>();
    private volatile boolean isStateSet = false;
    private String evictionInterceptorClass = "org.jboss.cache.interceptors.EvictionInterceptor";
    private Marshaller marshaller_ = null;
    private Interceptor interceptor_chain = null;
    private TransactionManagerLookup tm_lookup = null;
    private TransactionManager tm = null;
    private CacheLoaderManager cacheLoaderManager;
    private ReplicationQueue repl_queue = null;
    CacheStatus cacheStatus;
    private BuddyManager buddyManager;
    private StateTransferManager stateTransferManager;
    private Notifier notifier;
    private ThreadLocal<InvocationContext> invocationContextContainer = new ThreadLocal<InvocationContext>(){

        @Override
        protected InvocationContext initialValue() {
            return new InvocationContext();
        }
    };
    private Configuration configuration = new Configuration(this);

    protected CacheImpl() throws Exception {
        this.notifier = new Notifier(this);
        this.regionManager = new RegionManager(this);
        this.cacheStatus = CacheStatus.INSTANTIATED;
    }

    @Override
    public StateTransferManager getStateTransferManager() {
        if (this.stateTransferManager == null) {
            this.stateTransferManager = new StateTransferManager(this);
        }
        return this.stateTransferManager;
    }

    public void setStateTransferManager(StateTransferManager manager) {
        this.stateTransferManager = manager;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getVersion() {
        return Version.printVersion();
    }

    @Override
    public NodeSPI<K, V> getRoot() {
        return this.root;
    }

    @Override
    public Address getLocalAddress() {
        return this.channel != null ? this.channel.getLocalAddress() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Address> getMembers() {
        Vector<Address> vector = this.members;
        synchronized (vector) {
            return new ArrayList<Address>(this.members);
        }
    }

    public boolean isCoordinator() {
        return this.coordinator;
    }

    @Override
    public TransactionTable getTransactionTable() {
        return this.tx_table;
    }

    @Override
    public Map<Thread, List<NodeLock>> getLockTable() {
        if (this.lock_table == null) {
            this.lock_table = new ConcurrentHashMap<Thread, List<NodeLock>>();
        }
        return this.lock_table;
    }

    public String dumpTransactionTable() {
        return this.tx_table.toString(true);
    }

    public void setInterceptorChain(Interceptor i) {
        this.interceptor_chain = i;
    }

    public List<Interceptor> getInterceptors() {
        return InterceptorChainFactory.getInstance().asList(this.interceptor_chain);
    }

    public CacheLoader getCacheLoader() {
        if (this.cacheLoaderManager == null) {
            return null;
        }
        return this.cacheLoaderManager.getCacheLoader();
    }

    public String getEvictionInterceptorClass() {
        return this.evictionInterceptorClass;
    }

    private void setUseReplQueue(boolean flag) {
        if (flag) {
            if (this.repl_queue == null) {
                this.repl_queue = new ReplicationQueue(this, this.configuration.getReplQueueInterval(), this.configuration.getReplQueueMaxElements());
                if (this.configuration.getReplQueueInterval() >= 0L) {
                    this.repl_queue.start();
                }
            }
        } else if (this.repl_queue != null) {
            this.repl_queue.stop();
            this.repl_queue = null;
        }
    }

    public ReplicationQueue getReplicationQueue() {
        return this.repl_queue;
    }

    private void setIsolationLevel(IsolationLevel level) {
        LockStrategyFactory.setIsolationLevel(level);
    }

    public void setTransactionManagerLookup(TransactionManagerLookup l) {
        this.tm_lookup = l;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    public void fetchState(long timeout) throws ChannelClosedException, ChannelNotConnectedException {
        if (this.channel == null) {
            throw new ChannelNotConnectedException();
        }
        boolean rc = this.channel.getState(null, timeout);
        if (rc) {
            this.log.debug((Object)"fetchState(): state was retrieved successfully");
        } else {
            this.log.debug((Object)"fetchState(): state could not be retrieved (first member)");
        }
    }

    void fetchPartialState(List<Address> sources, Fqn sourceTarget, Fqn integrationTarget) throws Exception {
        String encodedStateId = sourceTarget + "_PARTIAL_STATE_DELIMITER" + integrationTarget;
        this.fetchPartialState(sources, encodedStateId);
    }

    void fetchPartialState(List<Address> sources, Fqn subtree) throws Exception {
        if (subtree == null) {
            throw new IllegalArgumentException("Cannot fetch partial state. Null subtree.");
        }
        this.fetchPartialState(sources, subtree.toString());
    }

    private void fetchPartialState(List<Address> sources, String stateId) throws Exception {
        if (sources == null || sources.isEmpty() || stateId == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("Cannot fetch partial state, targets are " + sources + " and stateId is " + stateId));
            }
            return;
        }
        LinkedList<Address> targets = new LinkedList<Address>(sources);
        targets.remove(this.getLocalAddress());
        if (targets.isEmpty()) {
            this.log.debug((Object)"Cannot fetch partial state. There are no target members specified");
            return;
        }
        this.log.debug((Object)("Node " + this.getLocalAddress() + " fetching partial state " + stateId + " from members " + targets));
        boolean successfulTransfer = false;
        for (Address target : targets) {
            this.log.debug((Object)("Node " + this.getLocalAddress() + " fetching partial state " + stateId + " from member " + target));
            this.isStateSet = false;
            successfulTransfer = this.channel.getState(target, stateId, this.configuration.getStateRetrievalTimeout());
            if (successfulTransfer) {
                try {
                    this.ml.waitForState();
                }
                catch (Exception transferFailed) {
                    successfulTransfer = false;
                }
            }
            this.log.debug((Object)("Node " + this.getLocalAddress() + " fetching partial state " + stateId + " from member " + target + (successfulTransfer ? " successful" : " failed")));
            if (!successfulTransfer) continue;
            break;
        }
        if (!successfulTransfer) {
            this.log.debug((Object)("Node " + this.getLocalAddress() + " could not fetch partial state " + stateId + " from any member " + targets));
        }
    }

    @Override
    public void create() throws CacheException {
        if (!this.cacheStatus.createAllowed()) {
            if (this.cacheStatus.needToDestroyFailedCache()) {
                this.destroy();
            } else {
                return;
            }
        }
        try {
            this.internalCreate();
        }
        catch (Throwable t) {
            this.handleLifecycleTransitionFailure(t);
        }
    }

    private void handleLifecycleTransitionFailure(Throwable t) throws CacheException, RuntimeException, Error {
        this.cacheStatus = CacheStatus.FAILED;
        if (t instanceof CacheException) {
            throw (CacheException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new CacheException(t);
    }

    private void internalCreate() throws CacheException {
        this.configureLogCategory();
        NodeFactory nf = this.configuration.getRuntimeConfig().getNodeFactory();
        if (nf == null) {
            nf = new NodeFactory(this);
            this.configuration.getRuntimeConfig().setNodeFactory(nf);
        } else {
            nf.init();
        }
        if (this.notifier == null) {
            this.notifier = new Notifier(this);
        }
        NodeSPI tempRoot = nf.createRootDataNode();
        if (this.root == null || !this.root.getClass().equals(tempRoot.getClass())) {
            this.root = tempRoot;
        }
        if (this.configuration.getCacheLoaderConfig() != null && this.cacheLoaderManager == null) {
            this.initialiseCacheLoaderManager();
        }
        if (this.configuration.getCacheMode() != Configuration.CacheMode.LOCAL) {
            this.getConfiguration().getRuntimeConfig().setRPCManager(new RPCManagerImpl(this));
            this.setBuddyReplicationConfig(this.configuration.getBuddyReplicationConfig());
        }
        try {
            this.interceptor_chain = InterceptorChainFactory.getInstance().buildInterceptorChain(this);
        }
        catch (Exception e) {
            throw new CacheException("Unable to build interceptor chain", e);
        }
        this.setUseReplQueue(this.configuration.isUseReplQueue());
        this.setIsolationLevel(this.configuration.getIsolationLevel());
        this.getRegionManager();
        this.createEvictionPolicy();
        this.getRegionManager().setDefaultInactive(this.configuration.isInactiveOnStartup());
        this.cacheStatus = CacheStatus.CREATED;
    }

    private void createTransactionManager() {
        this.tm = this.configuration.getRuntimeConfig().getTransactionManager();
        if (this.tm == null) {
            if (this.tm_lookup == null && this.configuration.getTransactionManagerLookupClass() != null) {
                try {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.configuration.getTransactionManagerLookupClass());
                    this.tm_lookup = (TransactionManagerLookup)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new CacheException("Problems creating the cache", e);
                }
            }
            try {
                if (this.tm_lookup != null) {
                    this.tm = this.tm_lookup.getTransactionManager();
                    this.configuration.getRuntimeConfig().setTransactionManager(this.tm);
                } else if (this.configuration.getNodeLockingScheme() == Configuration.NodeLockingScheme.OPTIMISTIC) {
                    this.log.fatal((Object)"No transaction manager lookup class has been defined. Transactions cannot be used and thus OPTIMISTIC locking cannot be used");
                } else {
                    this.log.info((Object)"No transaction manager lookup class has been defined. Transactions cannot be used");
                }
            }
            catch (Exception e) {
                this.log.debug((Object)"failed looking up TransactionManager, will not use transactions", (Throwable)e);
            }
        }
    }

    protected boolean shouldFetchStateOnStartup() {
        boolean loaderFetch = this.cacheLoaderManager != null && this.cacheLoaderManager.isFetchPersistentState();
        return !this.configuration.isInactiveOnStartup() && this.buddyManager == null && (this.configuration.isFetchInMemoryState() || loaderFetch);
    }

    @Override
    public void start() throws CacheException {
        if (!this.cacheStatus.startAllowed()) {
            if (this.cacheStatus.needToDestroyFailedCache()) {
                this.destroy();
            }
            if (this.cacheStatus.needCreateBeforeStart()) {
                this.create();
            } else {
                return;
            }
        }
        try {
            this.internalStart();
        }
        catch (Throwable t) {
            this.handleLifecycleTransitionFailure(t);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void internalStart() throws CacheException, IllegalArgumentException {
        this.cacheStatus = CacheStatus.STARTING;
        this.createTransactionManager();
        if (this.cacheLoaderManager != null) {
            this.cacheLoaderManager.startCacheLoader();
        }
        InterceptorChainFactory.getInstance().initialiseInterceptors(this.interceptor_chain, this);
        switch (3.$SwitchMap$org$jboss$cache$config$Configuration$CacheMode[this.configuration.getCacheMode().ordinal()]) {
            case 1: {
                this.log.debug((Object)"cache mode is local, will not create the channel");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("cache mode is " + (Object)this.configuration.getCacheMode()));
                }
                this.initialiseChannelAndRpcDispatcher();
                if (this.shouldFetchStateOnStartup()) {
                    try {
                        start = System.currentTimeMillis();
                        this.channel.connect(this.configuration.getClusterName(), null, null, this.configuration.getStateRetrievalTimeout());
                        if (this.getMembers().size() > 1) {
                            this.ml.waitForState();
                        }
                        if (!this.log.isDebugEnabled()) ** GOTO lbl36
                        this.log.debug((Object)("connected, state was retrieved successfully (in " + (System.currentTimeMillis() - start) + " milliseconds)"));
                    }
                    catch (StateTransferException ste) {
                        this.channel.disconnect();
                        this.channel.close();
                        throw new CacheException("Unable to fetch state on startup", ste);
                    }
                    catch (ChannelException e) {
                        throw new CacheException("Unable to connect to JGroups channel", e);
                    }
                    catch (Exception ex) {
                        throw new CacheException("Unable to fetch state on startup", ex);
                    }
                } else {
                    try {
                        this.channel.connect(this.configuration.getClusterName());
                    }
                    catch (ChannelException e) {
                        throw new CacheException("Unable to connect to JGroups channel", e);
                    }
                }
lbl36:
                // 3 sources

                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("CacheImpl local address is " + this.channel.getLocalAddress()));
                }
                if (this.buddyManager == null) break;
                this.buddyManager.init(this);
                if (!this.configuration.isUseReplQueue()) break;
                this.log.warn((Object)"Replication queue not supported when using buddy replication.  Disabling repliction queue.");
                this.configuration.setUseReplQueue(false);
                this.repl_queue = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("cache mode " + (Object)this.configuration.getCacheMode() + " is invalid");
            }
        }
        if (this.cacheLoaderManager != null) {
            this.cacheLoaderManager.preloadCache();
        }
        if (this.regionManager.isUsingEvictions()) {
            this.regionManager.startEvictionThread();
        }
        this.notifier.notifyCacheStarted(this, this.getInvocationContext());
        shutdownHook = new Thread(){

            public void run() {
                CacheImpl.this.stop();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        this.log.info((Object)("JBoss Cache version: " + this.getVersion()));
        this.cacheStatus = CacheStatus.STARTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (!this.cacheStatus.destroyAllowed()) {
            if (this.cacheStatus.needStopBeforeDestroy()) {
                try {
                    this.stop();
                }
                catch (CacheException e) {
                    this.log.warn((Object)"Needed to call stop() before destroying but stop() threw exception. Proceeding to destroy", (Throwable)e);
                }
            } else {
                return;
            }
        }
        try {
            this.internalDestroy();
        }
        finally {
            this.cacheStatus = CacheStatus.DESTROYED;
        }
    }

    private void internalDestroy() {
        this.cacheStatus = CacheStatus.DESTROYING;
        this.regionManager = null;
        this.cacheLoaderManager = null;
        this.notifier = null;
        if (this.channel != null) {
            if (this.channel.isOpen()) {
                try {
                    this.channel.close();
                    this.channel.disconnect();
                }
                catch (Exception toLog) {
                    this.log.error((Object)"Problem closing channel; setting it to null", (Throwable)toLog);
                }
            }
            this.channel = null;
            this.configuration.getRuntimeConfig().setChannel(null);
        }
        this.disp = null;
        this.tm = null;
    }

    @Override
    public void stop() {
        if (!this.cacheStatus.stopAllowed()) {
            return;
        }
        boolean failed = this.cacheStatus == CacheStatus.FAILED;
        try {
            this.internalStop();
        }
        catch (Throwable t) {
            if (failed) {
                this.log.warn((Object)"Attempted to stop() from FAILED state, but caught exception; try calling destroy()", t);
            }
            this.handleLifecycleTransitionFailure(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalStop() {
        this.cacheStatus = CacheStatus.STOPPING;
        if (this.buddyManager != null && this.buddyManager.isEnabled()) {
            this.log.debug((Object)"stop(): stopping buddy manager");
            this.buddyManager.stop();
        }
        if (this.channel != null) {
            this.log.info((Object)"stop(): closing the channel");
            this.killChannel();
            this.channel = null;
            this.configuration.getRuntimeConfig().setChannel(null);
        }
        if (this.disp != null) {
            this.log.info((Object)"stop(): stopping the dispatcher");
            this.disp.stop();
            this.disp = null;
        }
        if (this.members != null) {
            Vector<Address> vector = this.members;
            synchronized (vector) {
                this.members.clear();
            }
        }
        this.coordinator = false;
        if (this.repl_queue != null) {
            this.repl_queue.stop();
        }
        if (this.cacheLoaderManager != null) {
            this.log.debug((Object)"stop(): stopping cache loader manager");
            this.cacheLoaderManager.stopCacheLoader();
        }
        if (this.regionManager.isUsingEvictions()) {
            this.regionManager.stopEvictionThread();
        }
        if (this.notifier != null) {
            this.notifier.notifyCacheStopped(this, this.getInvocationContext());
            this.notifier.removeAllCacheListeners();
        }
        this.tm = null;
        this.cacheStatus = CacheStatus.STOPPED;
        this.root.clearDataDirect();
        this.root.removeChildrenDirect();
    }

    @Override
    public CacheStatus getCacheStatus() {
        return this.cacheStatus;
    }

    private void setBuddyReplicationConfig(BuddyReplicationConfig config) {
        if (config != null) {
            this.buddyManager = new BuddyManager(config);
            if (!this.buddyManager.isEnabled()) {
                this.buddyManager = null;
            } else {
                this.internalFqns.add(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN);
            }
        }
    }

    @Override
    public BuddyManager getBuddyManager() {
        return this.buddyManager;
    }

    public Set<Fqn> getInternalFqns() {
        return Collections.unmodifiableSet(this.internalFqns);
    }

    protected void createEvictionPolicy() {
        if (this.configuration.getEvictionConfig() != null && this.configuration.getEvictionConfig().isValidConfig()) {
            this.regionManager.setEvictionConfig(this.configuration.getEvictionConfig());
            this.regionManager.setUsingEvictions(true);
        } else {
            this.regionManager.setUsingEvictions(false);
            this.log.debug((Object)"Not using an EvictionPolicy");
        }
    }

    public void load(String fqn) throws Exception {
        if (this.cacheLoaderManager != null) {
            this.cacheLoaderManager.preload(Fqn.fromString(fqn), true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address getCoordinator() {
        if (this.channel == null) {
            return null;
        }
        Vector<Address> vector = this.members;
        synchronized (vector) {
            while (this.members.isEmpty()) {
                this.log.debug((Object)"getCoordinator(): waiting on viewAccepted()");
                try {
                    this.members.wait();
                }
                catch (InterruptedException e) {
                    this.log.error((Object)"getCoordinator(): Interrupted while waiting for members to be set", (Throwable)e);
                    break;
                }
            }
            return this.members.size() > 0 ? this.members.get(0) : null;
        }
    }

    protected void _evictSubtree(Fqn subtree) throws CacheException {
        Set children;
        if (!this.exists(subtree)) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("_evictSubtree(" + subtree + ")"));
        }
        if ((children = this.getChildrenNames(subtree)) != null) {
            for (Object s : children) {
                Fqn<Object> tmp = new Fqn<Object>(subtree, s);
                this._remove(null, tmp, false, false, true);
            }
        }
        this._remove(null, subtree, false, false, true);
    }

    private void removeLocksForDeadMembers(NodeSPI<K, V> node, List deadMembers) {
        HashSet<GlobalTransaction> deadOwners = new HashSet<GlobalTransaction>();
        NodeLock lock = node.getLock();
        Object owner = lock.getWriterOwner();
        if (this.isLockOwnerDead(owner, deadMembers)) {
            deadOwners.add((GlobalTransaction)owner);
        }
        for (Object e : lock.getReaderOwners()) {
            if (!this.isLockOwnerDead(e, deadMembers)) continue;
            deadOwners.add((GlobalTransaction)e);
        }
        for (GlobalTransaction globalTransaction : deadOwners) {
            boolean localTx;
            boolean broken = LockUtil.breakTransactionLock(lock, globalTransaction, localTx = globalTransaction.getAddress().equals(this.getLocalAddress()), this);
            if (!broken || !this.log.isTraceEnabled()) continue;
            this.log.trace((Object)("Broke lock for node " + node.getFqn() + " held by " + globalTransaction));
        }
        for (NodeSPI nodeSPI : node.getChildrenDirect()) {
            this.removeLocksForDeadMembers(nodeSPI, deadMembers);
        }
    }

    private boolean isLockOwnerDead(Object owner, List deadMembers) {
        boolean result = false;
        if (owner != null && owner instanceof GlobalTransaction) {
            Object addr = ((GlobalTransaction)owner).getAddress();
            result = deadMembers.contains(addr);
        }
        return result;
    }

    public Node get(String fqn) throws CacheException {
        return this.get(Fqn.fromString(fqn));
    }

    public Node<K, V> get(Fqn<?> fqn) throws CacheException {
        MethodCall m = MethodCallFactory.create(MethodDeclarations.getNodeMethodLocal, fqn);
        return (Node)this.invokeMethod(m, true);
    }

    public Node<K, V> _get(Fqn<?> fqn) throws CacheException {
        return this.findNode(fqn);
    }

    public Map _getData(Fqn<?> fqn) {
        NodeSPI<K, V> n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        return n.getDataDirect();
    }

    public Set getKeys(String fqn) throws CacheException {
        return this.getKeys(Fqn.fromString(fqn));
    }

    public Set<K> getKeys(Fqn<?> fqn) throws CacheException {
        MethodCall m = MethodCallFactory.create(MethodDeclarations.getKeysMethodLocal, fqn);
        return (Set)this.invokeMethod(m, true);
    }

    public Map<K, V> getData(Fqn<?> fqn) throws CacheException {
        MethodCall m = MethodCallFactory.create(MethodDeclarations.getDataMapMethodLocal, fqn);
        return (Map)this.invokeMethod(m, true);
    }

    public Set _getKeys(Fqn<?> fqn) throws CacheException {
        NodeSPI<K, V> n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        Set<K> keys = n.getKeysDirect();
        return new HashSet<K>(keys);
    }

    public V get(String fqn, K key) throws CacheException {
        return this.get(Fqn.fromString(fqn), key);
    }

    @Override
    public V get(Fqn<?> fqn, K key) throws CacheException {
        return this.get(fqn, key, true);
    }

    public V _get(Fqn<?> fqn, K key, boolean sendNodeEvent) throws CacheException {
        NodeSPI<K, V> n;
        InvocationContext ctx = this.getInvocationContext();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)new StringBuffer("_get(").append("\"").append(fqn).append("\", \"").append(key).append("\", \"").append(sendNodeEvent).append("\")"));
        }
        if (sendNodeEvent) {
            this.notifier.notifyNodeVisited(fqn, true, ctx);
        }
        if ((n = this.findNode(fqn)) == null) {
            this.log.trace((Object)"node not found");
            return null;
        }
        if (sendNodeEvent) {
            this.notifier.notifyNodeVisited(fqn, false, ctx);
        }
        return n.getDirect(key);
    }

    protected V get(Fqn<?> fqn, K key, boolean sendNodeEvent) throws CacheException {
        MethodCall m = MethodCallFactory.create(MethodDeclarations.getKeyValueMethodLocal, fqn, key, sendNodeEvent);
        return (V)this.invokeMethod(m, true);
    }

    public boolean exists(String fqn) {
        return this.exists(Fqn.fromString(fqn));
    }

    public boolean exists(Fqn<?> fqn) {
        NodeSPI<K, V> n = this.peek(fqn, false);
        return n != null;
    }

    @Override
    public NodeSPI<K, V> peek(Fqn<?> fqn, boolean includeDeletedNodes) {
        if (fqn == null || fqn.size() == 0) {
            return this.root;
        }
        NodeSPI<K, V> n = this.root;
        int fqnSize = fqn.size();
        for (int i = 0; i < fqnSize; ++i) {
            Object obj = fqn.get(i);
            if ((n = n.getChildDirect(obj)) == null) {
                return null;
            }
            if (includeDeletedNodes || !n.isDeleted()) continue;
            return null;
        }
        return n;
    }

    public boolean exists(String fqn, Object key) {
        return this.exists(Fqn.fromString(fqn), key);
    }

    public boolean exists(Fqn<?> fqn, Object key) {
        NodeSPI<K, V> n = this.peek(fqn, false);
        return n != null && n.getKeysDirect().contains(key);
    }

    public void put(String fqn, Map data) throws CacheException {
        this.put(Fqn.fromString(fqn), data);
    }

    @Override
    public void put(Fqn<?> fqn, Map<K, V> data) throws CacheException {
        this.put(fqn, (K)data, (V)false);
    }

    @Override
    public void put(Fqn<?> fqn, Map<K, V> data, boolean erase) throws CacheException {
        GlobalTransaction tx = this.getCurrentTransaction();
        MethodCall m = erase ? MethodCallFactory.create(MethodDeclarations.putDataEraseMethodLocal, tx, fqn, data, true, true) : MethodCallFactory.create(MethodDeclarations.putDataMethodLocal, tx, fqn, data, true);
        this.invokeMethod(m, true);
    }

    public V put(String fqn, K key, V value) throws CacheException {
        return this.put(Fqn.fromString(fqn), key, value);
    }

    @Override
    public V put(Fqn<?> fqn, K key, V value) throws CacheException {
        GlobalTransaction tx = this.getCurrentTransaction();
        MethodCall m = MethodCallFactory.create(MethodDeclarations.putKeyValMethodLocal, tx, fqn, key, value, true);
        return (V)this.invokeMethod(m, true);
    }

    public void remove(String fqn) throws CacheException {
        this.remove(Fqn.fromString(fqn));
    }

    public boolean remove(Fqn fqn) throws CacheException {
        GlobalTransaction tx = this.getCurrentTransaction();
        if (fqn.isRoot()) {
            boolean result = true;
            InvocationContext ctx = this.getInvocationContext();
            Option o = ctx.getOptionOverrides();
            for (Object childName : this._getChildrenNames(fqn)) {
                ctx.setOptionOverrides(o);
                result = this.remove(new Fqn<Object>(fqn, childName)) && result;
            }
            return result;
        }
        MethodCall m = MethodCallFactory.create(MethodDeclarations.removeNodeMethodLocal, tx, fqn, true);
        Object retval = this.invokeMethod(m, true);
        return retval != null && (Boolean)retval != false;
    }

    public void evict(Fqn fqn) throws CacheException {
        if (fqn.isRoot()) {
            InvocationContext ctx = this.getInvocationContext();
            Option o = ctx.getOptionOverrides();
            for (Object childName : this._getChildrenNames(fqn)) {
                ctx.setOptionOverrides(o);
                this.evict(new Fqn<Object>(fqn, childName));
            }
        } else {
            MethodCall m = MethodCallFactory.create(MethodDeclarations.evictNodeMethodLocal, fqn);
            this.invokeMethod(m, true);
        }
    }

    public V remove(String fqn, K key) throws CacheException {
        return this.remove(Fqn.fromString(fqn), key);
    }

    @Override
    public V remove(Fqn<?> fqn, K key) throws CacheException {
        GlobalTransaction tx = this.getCurrentTransaction();
        MethodCall m = MethodCallFactory.create(MethodDeclarations.removeKeyMethodLocal, tx, fqn, key, true);
        return (V)this.invokeMethod(m, true);
    }

    public void removeData(String fqn) throws CacheException {
        this.removeData(Fqn.fromString(fqn));
    }

    public void removeData(Fqn fqn) throws CacheException {
        GlobalTransaction tx = this.getCurrentTransaction();
        MethodCall m = MethodCallFactory.create(MethodDeclarations.removeDataMethodLocal, tx, fqn, true);
        this.invokeMethod(m, true);
    }

    public void releaseAllLocks(String fqn) {
        this.releaseAllLocks(Fqn.fromString(fqn));
    }

    public void releaseAllLocks(Fqn fqn) {
        MethodCall m = MethodCallFactory.create(MethodDeclarations.releaseAllLocksMethodLocal, fqn);
        try {
            this.invokeMethod(m, true);
        }
        catch (CacheException e) {
            this.log.error((Object)("failed releasing all locks for " + fqn), (Throwable)e);
        }
    }

    public String print(String fqn) {
        return this.print(Fqn.fromString(fqn));
    }

    public String print(Fqn fqn) {
        MethodCall m = MethodCallFactory.create(MethodDeclarations.printMethodLocal, fqn);
        Object retval = null;
        try {
            retval = this.invokeMethod(m, true);
        }
        catch (Throwable e) {
            retval = e;
        }
        if (retval != null) {
            return retval.toString();
        }
        return "";
    }

    public Set getChildrenNames(String fqn) throws CacheException {
        return this.getChildrenNames(Fqn.fromString(fqn));
    }

    public <E> Set<E> getChildrenNames(Fqn<E> fqn) throws CacheException {
        MethodCall m = MethodCallFactory.create(MethodDeclarations.getChildrenNamesMethodLocal, fqn);
        Set retval = null;
        retval = (Set)this.invokeMethod(m, true);
        retval = retval != null ? Collections.unmodifiableSet(new HashSet(retval)) : Collections.emptySet();
        return retval;
    }

    public <E> Set<E> _getChildrenNames(Fqn<E> fqn) throws CacheException {
        NodeSPI<K, V> n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        HashSet childNames = new HashSet();
        Map<Object, Node<K, V>> childrenMap = n.getChildrenMapDirect();
        if (childrenMap == null || childrenMap.isEmpty()) {
            return Collections.emptySet();
        }
        Collection<Node<K, V>> s = childrenMap.values();
        for (Node<K, V> c : s) {
            NodeSPI child = (NodeSPI)c;
            if (child.isDeleted()) continue;
            Object e = child.getFqn().getLastElement();
            childNames.add(e);
        }
        return childNames;
    }

    public boolean hasChild(Fqn fqn) {
        if (fqn == null) {
            return false;
        }
        NodeSPI<K, V> n = this.findNode(fqn);
        return n != null && n.hasChildrenDirect();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean details) {
        StringBuffer sb = new StringBuffer();
        int indent = 0;
        if (!details) {
            sb.append(this.getClass().getName()).append(" [").append(this.getNumberOfNodes()).append(" nodes, ");
            sb.append(this.getNumberOfLocksHeld()).append(" locks]");
        } else {
            if (this.root == null) {
                return sb.toString();
            }
            for (NodeSPI<K, V> n : this.root.getChildrenDirect()) {
                n.print(sb, indent);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public String printDetails() {
        StringBuffer sb = new StringBuffer();
        this.root.printDetails(sb, 0);
        sb.append("\n");
        return sb.toString();
    }

    public String printLockInfo() {
        StringBuffer sb = new StringBuffer("\n");
        int indent = 0;
        for (NodeSPI<K, V> n : this.root.getChildrenDirect()) {
            n.getLock().printLockInfo(sb, indent);
            sb.append("\n");
        }
        return sb.toString();
    }

    public int getNumberOfLocksHeld() {
        return this.numLocks(this.root);
    }

    private int numLocks(NodeSPI<K, V> n) {
        int num = 0;
        if (n.getLock().isLocked()) {
            ++num;
        }
        for (NodeSPI<K, V> cn : n.getChildrenDirect(true)) {
            num += this.numLocks(cn);
        }
        return num;
    }

    @Override
    public int getNumberOfNodes() {
        return this.numNodes(this.root) - 1;
    }

    private int numNodes(NodeSPI<K, V> n) {
        int count = 1;
        for (NodeSPI<K, V> child : n.getChildrenDirect()) {
            count += this.numNodes(child);
        }
        return count;
    }

    @Override
    public int getNumberOfAttributes() {
        return this.numAttributes(this.root);
    }

    public int getNumberOfAttributes(Fqn fqn) {
        return this.numAttributes(this.findNode(fqn));
    }

    private int numAttributes(NodeSPI<K, V> n) {
        int count = 0;
        for (NodeSPI<K, V> child : n.getChildrenDirect()) {
            count += this.numAttributes(child);
        }
        return count += n.getDataDirect().size();
    }

    @Deprecated
    public List callRemoteMethods(List<Address> mbrs, MethodCall method_call, boolean synchronous, boolean exclude_self, long timeout) throws Exception {
        return this.callRemoteMethods(mbrs, method_call, synchronous ? 2 : 6, exclude_self, timeout);
    }

    @Deprecated
    public List callRemoteMethods(List<Address> mbrs, MethodCall method_call, int mode, boolean exclude_self, long timeout) throws Exception {
        return this.callRemoteMethods(mbrs, method_call, mode, exclude_self, timeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List callRemoteMethods(List<Address> mbrs, MethodCall method_call, int mode, boolean exclude_self, long timeout, RspFilter rspFilter) throws Exception {
        Address local_addr;
        int modeToUse = mode;
        int preferredMode = this.getInvocationContext().getOptionOverrides().getGroupRequestMode();
        if (preferredMode > -1) {
            modeToUse = preferredMode;
        }
        RspList rsps = null;
        if (this.disp == null) {
            return null;
        }
        Vector<Address> validMembers = null;
        if (mbrs != null) {
            validMembers = new Vector<Address>(mbrs);
        } else {
            Vector<Address> vector = this.members;
            synchronized (vector) {
                validMembers = new Vector<Address>(this.members);
            }
        }
        if (exclude_self && !validMembers.isEmpty() && (local_addr = this.getLocalAddress()) != null) {
            validMembers.remove(local_addr);
        }
        if (validMembers.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"destination list is empty, discarding call");
            }
            return null;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("callRemoteMethods(): valid members are " + validMembers + " methods: " + method_call.getArgs()[0]));
        }
        if (this.channel.flushSupported() && !this.flushBlockGate.await(this.configuration.getStateRetrievalTimeout())) {
            throw new TimeoutException("State retrieval timed out waiting for flush unblock.");
        }
        RspList rspList = rspFilter == null ? this.disp.callRemoteMethods(validMembers, (org.jgroups.blocks.MethodCall)method_call, modeToUse, timeout, this.buddyManager != null && this.buddyManager.isEnabled()) : (rsps = this.disp.callRemoteMethods(validMembers, (org.jgroups.blocks.MethodCall)method_call, modeToUse, timeout, this.buddyManager != null && this.buddyManager.isEnabled(), false, rspFilter));
        if (rsps == null) {
            throw new NotSerializableException("RpcDispatcher returned a null.  This is most often caused by args for " + (Object)((Object)method_call) + " not being serializable.");
        }
        if (mode == 6) {
            return Collections.EMPTY_LIST;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("(" + this.getLocalAddress() + "): responses for method " + method_call.getName() + ":\n" + rsps));
        }
        ArrayList<Object> retval = new ArrayList<Object>(rsps.size());
        for (int i = 0; i < rsps.size(); ++i) {
            Rsp rsp = (Rsp)rsps.elementAt(i);
            if (rsp.wasSuspected() || !rsp.wasReceived()) {
                CacheException ex = rsp.wasSuspected() ? new SuspectException("Suspected member: " + rsp.getSender()) : new TimeoutException("Replication timeout for " + rsp.getSender());
                retval.add(new ReplicationException("rsp=" + rsp, ex));
                continue;
            }
            retval.add(rsp.getValue());
        }
        return retval;
    }

    @Deprecated
    public List callRemoteMethods(List<Address> members, Method method, Object[] args, boolean synchronous, boolean exclude_self, long timeout) throws Exception {
        return this.callRemoteMethods(members, MethodCallFactory.create(method, args), synchronous, exclude_self, timeout);
    }

    @Deprecated
    public List callRemoteMethods(Vector<Address> members, String method_name, Class[] types, Object[] args, boolean synchronous, boolean exclude_self, long timeout) throws Exception {
        Method method = this.getClass().getDeclaredMethod(method_name, types);
        return this.callRemoteMethods(members, method, args, synchronous, exclude_self, timeout);
    }

    public void _putForExternalRead(GlobalTransaction gtx, Fqn fqn, K key, V value, DataVersion dv) throws CacheException {
        this._putForExternalRead(gtx, fqn, key, value);
    }

    public void _put(GlobalTransaction tx, Fqn fqn, Map<K, V> data, boolean create_undo_ops, DataVersion dv) throws CacheException {
        this._put(tx, fqn, data, create_undo_ops, false, dv);
    }

    public void _put(GlobalTransaction tx, Fqn fqn, Map<K, V> data, boolean create_undo_ops, boolean erase_contents, DataVersion dv) throws CacheException {
        this._put(tx, fqn, data, create_undo_ops, erase_contents);
    }

    public Object _put(GlobalTransaction tx, Fqn fqn, K key, V value, boolean create_undo_ops, DataVersion dv) throws CacheException {
        return this._put(tx, fqn, key, value, create_undo_ops);
    }

    public boolean _remove(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, DataVersion dv) throws CacheException {
        return this._remove(tx, fqn, create_undo_ops, true);
    }

    public Object _remove(GlobalTransaction tx, Fqn fqn, K key, boolean create_undo_ops, DataVersion dv) throws CacheException {
        return this._remove(tx, fqn, key, create_undo_ops);
    }

    public void _removeData(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, DataVersion dv) throws CacheException {
        this._removeData(tx, fqn, create_undo_ops, true);
    }

    public void _put(GlobalTransaction tx, String fqn, Map<K, V> data, boolean create_undo_ops) throws CacheException {
        this._put(tx, Fqn.fromString(fqn), data, create_undo_ops);
    }

    public void _put(GlobalTransaction tx, Fqn fqn, Map<K, V> data, boolean create_undo_ops) throws CacheException {
        this._put(tx, fqn, data, create_undo_ops, false);
    }

    public void _put(GlobalTransaction tx, Fqn fqn, Map<K, V> data, boolean create_undo_ops, boolean erase_contents) throws CacheException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("_put(" + tx + ", \"" + fqn + "\", " + data + " undo=" + create_undo_ops + " erase=" + erase_contents + ")"));
        }
        InvocationContext ctx = this.getInvocationContext();
        boolean isRollback = this.checkIsRollingBack(ctx.getTransaction());
        NodeSPI<K, V> n = this.findNodeCheck(tx, fqn);
        Map<K, V> rawData = n.getDataDirect();
        if (!isRollback) {
            this.notifier.notifyNodeModified(fqn, true, NodeModifiedEvent.ModificationType.PUT_MAP, rawData, ctx);
        }
        if (tx != null && create_undo_ops) {
            MethodCall undo_op = MethodCallFactory.create(MethodDeclarations.putDataEraseMethodLocal, tx, fqn, new HashMap<K, V>(rawData), false, true);
            this.tx_table.addUndoOperation(tx, undo_op);
        }
        if (erase_contents) {
            n.clearDataDirect();
        }
        n.putAllDirect(data);
        if (!isRollback) {
            this.notifier.notifyNodeModified(fqn, false, NodeModifiedEvent.ModificationType.PUT_MAP, n.getDataDirect(), ctx);
        }
    }

    public Object _put(GlobalTransaction tx, String fqn, K key, V value, boolean create_undo_ops) throws CacheException {
        return this._put(tx, Fqn.fromString(fqn), key, value, create_undo_ops);
    }

    private boolean checkIsRollingBack(Transaction tx) {
        try {
            return tx != null && (tx.getStatus() == 4 || tx.getStatus() == 9 || tx.getStatus() == 1);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Object _put(GlobalTransaction tx, Fqn fqn, K key, V value, boolean create_undo_ops) throws CacheException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)new StringBuffer("_put(").append(tx).append(", \"").append(fqn).append("\", k=").append(key).append(", v=").append(value).append(")"));
        }
        InvocationContext ctx = this.getInvocationContext();
        boolean isRollback = this.checkIsRollingBack(ctx.getTransaction());
        NodeSPI<K, V> n = this.findNodeCheck(tx, fqn);
        Map<K, V> rawData = n.getDataDirect();
        if (!isRollback) {
            this.notifier.notifyNodeModified(fqn, true, NodeModifiedEvent.ModificationType.PUT_DATA, rawData, ctx);
        }
        V old_value = n.putDirect(key, value);
        if (tx != null && create_undo_ops) {
            MethodCall undo_op = old_value == null ? MethodCallFactory.create(MethodDeclarations.removeKeyMethodLocal, tx, fqn, key, false) : MethodCallFactory.create(MethodDeclarations.putKeyValMethodLocal, tx, fqn, key, old_value, false);
            this.tx_table.addUndoOperation(tx, undo_op);
        }
        Map<K, V> newData = Collections.singletonMap(key, value);
        if (!isRollback) {
            this.notifier.notifyNodeModified(fqn, false, NodeModifiedEvent.ModificationType.PUT_DATA, newData, ctx);
        }
        return old_value;
    }

    public void _remove(GlobalTransaction tx, String fqn, boolean create_undo_ops) throws CacheException {
        this._remove(tx, Fqn.fromString(fqn), create_undo_ops);
    }

    public boolean _remove(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops) throws CacheException {
        return this._remove(tx, fqn, create_undo_ops, true);
    }

    public boolean _remove(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, boolean sendNodeEvent) throws CacheException {
        return this._remove(tx, fqn, create_undo_ops, sendNodeEvent, false);
    }

    public boolean _remove(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, boolean sendNodeEvent, boolean eviction) throws CacheException {
        return this._remove(tx, fqn, create_undo_ops, sendNodeEvent, eviction, null);
    }

    public boolean _remove(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, boolean sendNodeEvent, boolean eviction, DataVersion version) throws CacheException {
        boolean found;
        NodeSPI<K, V> n;
        MethodCall undo_op = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("_remove(" + tx + ", \"" + fqn + "\", undo=" + create_undo_ops + ")"));
        }
        InvocationContext ctx = this.getInvocationContext();
        boolean isRollback = this.checkIsRollingBack(ctx.getTransaction());
        if (tx != null) {
            try {
                if (isRollback) {
                    this.log.trace((Object)"This remove call is triggered by a transaction rollback, as a compensation operation.  Do a realRemove() instead.");
                    return this.realRemove(fqn, true);
                }
            }
            catch (Exception e) {
                this.log.warn((Object)"Unable to get a hold of the transaction for a supposedly transactional call!  This *may* result in stale locks!", (Throwable)e);
            }
        }
        if ((n = this.findNode(fqn, version)) == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("node " + fqn + " not found"));
            }
            return false;
        }
        if (!isRollback) {
            if (eviction) {
                this.notifier.notifyNodeEvicted(fqn, true, ctx);
            } else {
                this.notifier.notifyNodeRemoved(fqn, true, n.getDataDirect(), ctx);
            }
        }
        NodeSPI<K, V> parent_node = n.getParent();
        if (eviction || this.configuration.isNodeLockingOptimistic()) {
            found = parent_node == null ? fqn.isRoot() : parent_node.removeChildDirect(n.getFqn().getLastElement());
        } else {
            found = !n.isDeleted();
            n.markAsDeleted(true);
        }
        if (eviction && parent_node != null) {
            parent_node.setChildrenLoaded(false);
        }
        if (tx != null && create_undo_ops && !eviction) {
            undo_op = MethodCallFactory.create(MethodDeclarations.addChildMethodLocal, tx, parent_node.getFqn(), n.getFqn().getLastElement(), n, false);
            this.tx_table.addUndoOperation(tx, undo_op);
        }
        if (!isRollback) {
            if (eviction) {
                this.notifier.notifyNodeEvicted(fqn, false, ctx);
            } else {
                this.notifier.notifyNodeRemoved(fqn, false, null, ctx);
            }
        }
        return found;
    }

    public V _remove(GlobalTransaction tx, String fqn, K key, boolean create_undo_ops) throws CacheException {
        return this._remove(tx, Fqn.fromString(fqn), key, create_undo_ops);
    }

    public V _remove(GlobalTransaction tx, Fqn fqn, K key, boolean create_undo_ops) throws CacheException {
        NodeSPI<K, V> n;
        MethodCall undo_op = null;
        V old_value = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("_remove(" + tx + ", \"" + fqn + "\", key=" + key + ")"));
        }
        if ((n = this.findNode(fqn)) == null) {
            this.log.warn((Object)("node " + fqn + " not found"));
            return null;
        }
        InvocationContext ctx = this.getInvocationContext();
        boolean isRollback = this.checkIsRollingBack(ctx.getTransaction());
        if (!isRollback) {
            this.notifier.notifyNodeModified(fqn, true, NodeModifiedEvent.ModificationType.REMOVE_DATA, n.getDataDirect(), ctx);
        }
        old_value = n.removeDirect(key);
        if (tx != null && create_undo_ops && old_value != null) {
            undo_op = MethodCallFactory.create(MethodDeclarations.putKeyValMethodLocal, tx, fqn, key, old_value, false);
            this.tx_table.addUndoOperation(tx, undo_op);
        }
        Map<K, Object> removedData = Collections.singletonMap(key, old_value);
        if (!isRollback) {
            this.notifier.notifyNodeModified(fqn, false, NodeModifiedEvent.ModificationType.REMOVE_DATA, removedData, ctx);
        }
        return old_value;
    }

    public void _removeData(GlobalTransaction tx, String fqn, boolean create_undo_ops) throws CacheException {
        this._removeData(tx, Fqn.fromString(fqn), create_undo_ops);
    }

    public void _removeData(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops) throws CacheException {
        this._removeData(tx, fqn, create_undo_ops, true);
    }

    public void _removeData(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, boolean sendNodeEvent) throws CacheException {
        this._removeData(tx, fqn, create_undo_ops, sendNodeEvent, false);
    }

    public void _removeData(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, boolean sendNodeEvent, boolean eviction) throws CacheException {
        this._removeData(tx, fqn, create_undo_ops, sendNodeEvent, eviction, null);
    }

    public void _removeData(GlobalTransaction tx, Fqn fqn, boolean create_undo_ops, boolean sendNodeEvent, boolean eviction, DataVersion version) throws CacheException {
        NodeSPI<K, V> n;
        MethodCall undo_op = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("_removeData(" + tx + ", \"" + fqn + "\")"));
        }
        if ((n = this.findNode(fqn, version)) == null) {
            this.log.warn((Object)("node " + fqn + " not found"));
            return;
        }
        Map<K, V> data = n.getDataDirect();
        InvocationContext ctx = this.getInvocationContext();
        boolean isRollback = this.checkIsRollingBack(ctx.getTransaction());
        if (tx != null && create_undo_ops && !eviction && !data.isEmpty()) {
            undo_op = MethodCallFactory.create(MethodDeclarations.putDataMethodLocal, tx, fqn, new HashMap<K, V>(data), false);
        }
        if (!isRollback) {
            if (eviction) {
                this.notifier.notifyNodeEvicted(fqn, true, ctx);
            } else {
                this.notifier.notifyNodeModified(fqn, true, NodeModifiedEvent.ModificationType.REMOVE_DATA, data, ctx);
            }
        }
        n.clearDataDirect();
        if (eviction) {
            n.setDataLoaded(false);
        }
        if (!isRollback) {
            if (sendNodeEvent) {
                this.notifier.notifyNodeVisited(fqn, false, ctx);
            } else if (eviction) {
                this.notifier.notifyNodeEvicted(fqn, false, ctx);
            } else {
                this.notifier.notifyNodeModified(fqn, false, NodeModifiedEvent.ModificationType.REMOVE_DATA, data, ctx);
            }
        }
        if (tx != null && create_undo_ops) {
            this.tx_table.addUndoOperation(tx, undo_op);
        }
    }

    public boolean _evict(Fqn fqn) throws CacheException {
        if (!this.exists(fqn)) {
            return true;
        }
        boolean create_undo_ops = false;
        boolean sendNodeEvent = false;
        boolean eviction = true;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("_evict(" + fqn + ")"));
        }
        if (this.hasChild(fqn)) {
            this._removeData(null, fqn, create_undo_ops, sendNodeEvent, eviction);
            return false;
        }
        this._remove(null, fqn, create_undo_ops, sendNodeEvent, eviction);
        return true;
    }

    public boolean _evict(Fqn fqn, DataVersion version) throws CacheException {
        if (!this.exists(fqn)) {
            return true;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("_evict(" + fqn + ", " + version + ")"));
        }
        if (this.hasChild(fqn)) {
            this._removeData(null, fqn, false, false, true, version);
            return false;
        }
        this._remove(null, fqn, false, false, true, version);
        return true;
    }

    public void invalidate(Fqn fqn, DataVersion versionToInvalidate) {
        Node<K, V> node = this.get(fqn);
        if (node != null) {
            this._removeData(null, fqn, false, false, true, versionToInvalidate);
            if (versionToInvalidate != null) {
                NodeSPI<K, V> n = this.peek(fqn, false);
                n.setVersion(versionToInvalidate);
            }
        } else {
            if (!this.configuration.isNodeLockingOptimistic()) {
                return;
            }
            Map m = Collections.emptyMap();
            this.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
            this.put(fqn, m);
            this.getInvocationContext().getOptionOverrides().setCacheModeLocal(false);
            NodeSPI nodeSPI = (NodeSPI)this.root.getChild(fqn);
            nodeSPI.setVersion(versionToInvalidate);
        }
    }

    public void _addChild(GlobalTransaction gtx, Fqn parent_fqn, Object child_name, Node cn, boolean undoOps) throws CacheException {
        NodeSPI childNode = (NodeSPI)cn;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("_addChild(\"" + parent_fqn + "\", \"" + child_name + "\", node=" + childNode + ")"));
        }
        if (parent_fqn == null || child_name == null || childNode == null) {
            this.log.error((Object)"parent_fqn or child_name or childNode was null");
            return;
        }
        NodeSPI<K, V> parentNode = this.findNode(parent_fqn);
        if (parentNode == null) {
            this.log.warn((Object)("node " + parent_fqn + " not found"));
            return;
        }
        InvocationContext ctx = this.getInvocationContext();
        boolean isRollback = this.checkIsRollingBack(ctx.getTransaction());
        Fqn<Object> fqn = new Fqn<Object>(parent_fqn, child_name);
        if (!isRollback) {
            this.notifier.notifyNodeCreated(fqn, true, ctx);
        }
        parentNode.addChild(child_name, childNode);
        childNode.markAsDeleted(false, true);
        if (gtx != null && undoOps) {
            this.tx_table.addUndoOperation(gtx, MethodCallFactory.create(MethodDeclarations.removeNodeMethodLocal, gtx, fqn, false));
        }
        if (!isRollback) {
            this.notifier.notifyNodeCreated(fqn, false, ctx);
        }
    }

    public Object _replicate(MethodCall method_call) throws Throwable {
        try {
            Object retVal = this.invokeMethod(method_call, false);
            if (MethodDeclarations.returnValueForRemoteCall(method_call.getMethodId())) {
                return retVal;
            }
            return null;
        }
        catch (Throwable ex) {
            this.log.warn((Object)("replication failure with method_call " + (Object)((Object)method_call) + " exception"), ex);
            throw ex;
        }
    }

    public void _replicate(List<MethodCall> methodCalls) throws Throwable {
        for (MethodCall methodCall : methodCalls) {
            this._replicate(methodCall);
        }
    }

    public List _clusteredGet(MethodCall methodCall, Boolean searchBackupSubtrees) {
        MethodCall call = methodCall;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Clustered Get called with params: " + (Object)((Object)call) + ", " + searchBackupSubtrees));
        }
        Method m = call.getMethod();
        Object[] args = call.getArgs();
        Object callResults = null;
        try {
            Fqn fqn = (Fqn)args[0];
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Clustered get: invoking call " + m + " with Fqn " + fqn));
            }
            callResults = m.invoke((Object)this, args);
            boolean found = this.validResult(callResults, call, fqn);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Got result " + callResults + ", found=" + found));
            }
            if (found && callResults == null) {
                callResults = this.createEmptyResults(call);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)"Problems processing clusteredGet call", (Throwable)e);
        }
        ArrayList<Object> results = new ArrayList<Object>(2);
        if (callResults != null) {
            results.add(true);
            results.add(callResults);
        } else {
            results.add(false);
            results.add(null);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GravitateResult gravitateData(Fqn fqn, boolean searchSubtrees) throws CacheException {
        InvocationContext ctx = this.getInvocationContext();
        this.log.debug((Object)("*****************>>>>> " + this.printLockInfo()));
        try {
            Set<Object> childNames;
            Object backupSubtree;
            ctx.setOriginLocal(false);
            NodeSPI<K, V> actualNode = this.findNode(fqn);
            Fqn backupNodeFqn = null;
            if (actualNode == null && searchSubtrees && (backupSubtree = this.findNode(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN)) != null && (childNames = backupSubtree.getChildrenNamesDirect()) != null) {
                Object childName;
                Iterator<Object> i$ = childNames.iterator();
                while (i$.hasNext() && (actualNode = this.findNode(backupNodeFqn = BuddyManager.getBackupFqn((childName = i$.next()).toString(), fqn))) == null) {
                }
            }
            if (actualNode == null) {
                backupSubtree = GravitateResult.noDataFound();
                return backupSubtree;
            }
            if (backupNodeFqn == null && searchSubtrees) {
                backupNodeFqn = BuddyManager.getBackupFqn(BuddyManager.getGroupNameFromAddress(this.getLocalAddress()), fqn);
            }
            List<NodeData> list = this.getNodeData(new LinkedList<NodeData>(), actualNode);
            GravitateResult gravitateResult = GravitateResult.subtreeResult(list, backupNodeFqn);
            return gravitateResult;
        }
        finally {
            ctx.setOriginLocal(true);
        }
    }

    private List<NodeData> getNodeData(List<NodeData> list, NodeSPI<K, V> node) {
        NodeData data = new NodeData(BuddyManager.getActualFqn(node.getFqn()), node.getDataDirect());
        list.add(data);
        for (NodeSPI<K, V> childNode : node.getChildrenDirect()) {
            this.getNodeData(list, childNode);
        }
        return list;
    }

    public void _remoteAssignToBuddyGroup(BuddyGroup group, Map<Fqn, byte[]> state) throws Exception {
        if (this.buddyManager != null) {
            this.buddyManager.handleAssignToBuddyGroup(group, state);
        } else if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("Received assignToBuddyGroup call from group owner [" + group.getDataOwner() + "] but buddy replication is not enabled on this node!"));
        }
    }

    public void _remoteRemoveFromBuddyGroup(String groupName) throws BuddyNotInitException {
        if (this.buddyManager != null) {
            this.buddyManager.handleRemoveFromBuddyGroup(groupName);
        } else if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("Received removeFromBuddyGroup call for group name [" + groupName + "] but buddy replication is not enabled on this node!"));
        }
    }

    public void _remoteAnnounceBuddyPoolName(Address address, String buddyPoolName) {
        if (this.buddyManager != null) {
            this.buddyManager.handlePoolNameBroadcast(address, buddyPoolName);
        } else if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("Received annouceBuddyPoolName call from [" + address + "] but buddy replication is not enabled on this node!"));
        }
    }

    public void _dataGravitationCleanup(GlobalTransaction gtx, Fqn primary, Fqn backup) throws Exception {
        MethodCall backupDataCleanup;
        MethodCall primaryDataCleanup;
        if (this.buddyManager.isDataGravitationRemoveOnFind()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("DataGravitationCleanup: Removing primary (" + primary + ") and backup (" + backup + ")"));
            }
            primaryDataCleanup = MethodCallFactory.create(MethodDeclarations.removeNodeMethodLocal, null, primary, false);
            backupDataCleanup = MethodCallFactory.create(MethodDeclarations.removeNodeMethodLocal, null, backup, false);
        } else {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("DataGravitationCleanup: Evicting primary (" + primary + ") and backup (" + backup + ")"));
            }
            primaryDataCleanup = MethodCallFactory.create(MethodDeclarations.evictNodeMethodLocal, primary);
            backupDataCleanup = MethodCallFactory.create(MethodDeclarations.evictNodeMethodLocal, backup);
        }
        this.invokeMethod(primaryDataCleanup, true);
        this.invokeMethod(backupDataCleanup, true);
    }

    private boolean validResult(Object callResults, MethodCall mc, Fqn fqn) {
        switch (mc.getMethodId()) {
            case 23: 
            case 24: {
                return callResults != null || this.exists(fqn);
            }
            case 16: {
                return (Boolean)callResults;
            }
        }
        return false;
    }

    private Object createEmptyResults(MethodCall mc) {
        switch (mc.getMethodId()) {
            case 23: 
            case 24: {
                return Collections.emptyMap();
            }
        }
        return null;
    }

    public void _releaseAllLocks(Fqn fqn) {
        try {
            NodeSPI<K, V> n = this.findNode(fqn);
            if (n == null) {
                this.log.error((Object)("releaseAllLocks(): node " + fqn + " not found"));
                return;
            }
            this.releaseAll(n);
        }
        catch (Throwable t) {
            this.log.error((Object)"releaseAllLocks(): failed", t);
        }
    }

    private void releaseAll(NodeSPI<K, V> n) {
        for (NodeSPI<K, V> child : n.getChildrenDirect()) {
            this.releaseAll(child);
        }
        n.getLock().releaseAll();
    }

    public String _print(Fqn fqn) {
        try {
            NodeSPI<K, V> n = this.findNode(fqn);
            if (n == null) {
                return null;
            }
            return n.toString();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void _lock(Fqn fqn, NodeLock.LockType lock_type, boolean recursive) throws TimeoutException, LockingException {
        throw new UnsupportedOperationException("method _lock() should not be invoked on CacheImpl");
    }

    public void optimisticPrepare(GlobalTransaction gtx, List modifications, Map data, Address address, boolean onePhaseCommit) {
        throw new UnsupportedOperationException("optimisticPrepare() should not be called on CacheImpl directly");
    }

    public void prepare(GlobalTransaction global_tx, List modifications, Address coord, boolean onePhaseCommit) {
        throw new UnsupportedOperationException("prepare() should not be called on CacheImpl directly");
    }

    public void commit(GlobalTransaction tx) {
        throw new UnsupportedOperationException("commit() should not be called on CacheImpl directly");
    }

    public void rollback(GlobalTransaction tx) {
        throw new UnsupportedOperationException("rollback() should not be called on CacheImpl directly");
    }

    public void addUndoOperation(GlobalTransaction gtx, MethodCall undo_op) {
        this.tx_table.addUndoOperation(gtx, undo_op);
    }

    @Override
    public CacheLoaderManager getCacheLoaderManager() {
        return this.cacheLoaderManager;
    }

    public void setCacheLoaderManager(CacheLoaderManager cacheLoaderManager) {
        this.cacheLoaderManager = cacheLoaderManager;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        configuration.setCacheImpl(this);
    }

    @Override
    public Notifier getNotifier() {
        return this.notifier;
    }

    @Override
    public InvocationContext getInvocationContext() {
        InvocationContext ctx = this.invocationContextContainer.get();
        if (ctx == null) {
            ctx = new InvocationContext();
            this.invocationContextContainer.set(ctx);
        }
        return ctx;
    }

    @Override
    public void setInvocationContext(InvocationContext ctx) {
        this.invocationContextContainer.set(ctx);
    }

    @Override
    public void move(Fqn<?> nodeToMove, Fqn<?> newParent) {
        MethodCall m = MethodCallFactory.create(MethodDeclarations.moveMethodLocal, nodeToMove, newParent);
        this.invokeMethod(m, true);
    }

    public void _move(Fqn nodeToMoveFqn, Fqn newParentFqn) {
        NodeSPI<K, V> newParent = this.findNode(newParentFqn);
        if (newParent == null) {
            throw new NodeNotExistsException("New parent node " + newParentFqn + " does not exist when attempting to move node!!");
        }
        NodeSPI<K, V> node = this.findNode(nodeToMoveFqn);
        if (node == null) {
            throw new NodeNotExistsException("Node " + nodeToMoveFqn + " does not exist when attempting to move node!!");
        }
        NodeSPI<K, V> oldParent = node.getParent();
        Object nodeName = nodeToMoveFqn.getLastElement();
        oldParent.removeChildDirect(nodeName);
        newParent.addChild(nodeName, node);
        InvocationContext ctx = this.getInvocationContext();
        boolean isRollback = this.checkIsRollingBack(ctx.getTransaction());
        if (!isRollback) {
            this.notifier.notifyNodeMoved(nodeToMoveFqn, new Fqn<Object>(newParentFqn, nodeToMoveFqn.getLastElement()), true, ctx);
        }
        this.moveFqns(node, newParent.getFqn());
        if (!isRollback) {
            this.notifier.notifyNodeMoved(nodeToMoveFqn, new Fqn<Object>(newParentFqn, nodeToMoveFqn.getLastElement()), false, ctx);
        }
        if (ctx.getTransaction() != null) {
            MethodCall undo = MethodCallFactory.create(MethodDeclarations.moveMethodLocal, new Fqn<Object>(newParentFqn, nodeToMoveFqn.getLastElement()), oldParent.getFqn());
            this.tx_table.addUndoOperation(ctx.getGlobalTransaction(), undo);
        }
    }

    public void _block() {
    }

    public void _unblock() {
    }

    private void moveFqns(NodeSPI node, Fqn newBase) {
        Fqn<Object> newFqn = new Fqn<Object>(newBase, node.getFqn().getLastElement());
        node.setFqn(newFqn);
    }

    private void configureLogCategory() {
        String clusterName;
        StringBuffer category = new StringBuffer(this.getClass().getName());
        if (this.configuration != null && (clusterName = this.configuration.getClusterName()) != null) {
            category.append('.');
            category.append(clusterName);
        }
        this.log = LogFactory.getLog((String)category.toString());
    }

    public void killChannel() {
        if (this.channel != null) {
            this.channel.disconnect();
            this.channel.close();
        }
    }

    protected Transaction getLocalTransaction() {
        if (this.tm == null) {
            return null;
        }
        try {
            return this.tm.getTransaction();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private boolean isValid(Transaction tx) {
        if (tx == null) {
            return false;
        }
        int status = -1;
        try {
            status = tx.getStatus();
            return status == 0 || status == 7;
        }
        catch (SystemException e) {
            this.log.error((Object)"failed getting transaction status", (Throwable)e);
            return false;
        }
    }

    public GlobalTransaction getCurrentTransaction() {
        return this.getCurrentTransaction(true);
    }

    public GlobalTransaction getCurrentTransaction(boolean createIfNotExists) {
        Transaction tx = this.getLocalTransaction();
        if (tx == null) {
            return null;
        }
        if (!this.isValid(tx)) {
            int status = -1;
            try {
                status = tx.getStatus();
            }
            catch (SystemException e) {
                // empty catch block
            }
            if (status != 3) {
                this.log.warn((Object)("status is " + status + " (not ACTIVE or PREPARING); returning null)"), new Throwable());
            } else {
                this.log.trace((Object)"status is COMMITTED; returning null");
            }
            return null;
        }
        return this.getCurrentTransaction(tx, createIfNotExists);
    }

    public GlobalTransaction getCurrentTransaction(Transaction tx) {
        return this.getCurrentTransaction(tx, true);
    }

    @Override
    public GlobalTransaction getCurrentTransaction(Transaction tx, boolean createIfNotExists) {
        GlobalTransaction gtx = this.tx_table.get(tx);
        if (gtx == null && createIfNotExists) {
            Address addr = this.getLocalAddress();
            gtx = GlobalTransaction.create(addr);
            this.tx_table.put(tx, gtx);
            TransactionEntry ent = this.configuration.isNodeLockingOptimistic() ? new OptimisticTransactionEntry() : new TransactionEntry();
            ent.setTransaction(tx);
            this.tx_table.put(gtx, ent);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("created new GTX: " + gtx + ", local TX=" + tx));
            }
        }
        return gtx;
    }

    private void blockUntilCacheStarts() throws InterruptedException {
        int pollFrequencyMS = 100;
        long startupWaitTime = this.configuration.getStateRetrievalTimeout();
        long giveUpTime = System.currentTimeMillis() + startupWaitTime;
        while (System.currentTimeMillis() < giveUpTime && !this.cacheStatus.allowInvocations()) {
            Thread.sleep(pollFrequencyMS);
        }
    }

    protected Object invokeMethod(MethodCall m, boolean originLocal) throws CacheException {
        InvocationContext ctx = this.getInvocationContext();
        if (!(MethodDeclarations.isBuddyGroupOrganisationMethod(m.getMethodId()) || this.cacheStatus.allowInvocations() || ctx.getOptionOverrides().isSkipCacheStatusCheck())) {
            if (originLocal) {
                throw new IllegalStateException("Cache not in STARTED state!");
            }
            if (this.getCacheStatus() == CacheStatus.STARTING) {
                try {
                    this.blockUntilCacheStarts();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (!this.cacheStatus.allowInvocations()) {
                    throw new IllegalStateException("Cache not in STARTED state!");
                }
            } else {
                this.log.warn((Object)"Received a remote call but the cache is not in STARTED state - ignoring call.");
                return null;
            }
        }
        MethodCall oldCall = null;
        try {
            oldCall = ctx.getMethodCall();
            ctx.setMethodCall(m);
            if (!originLocal) {
                ctx.setOriginLocal(false);
            }
            Object object = this.interceptor_chain.invoke(ctx);
            return object;
        }
        catch (CacheException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            if (!originLocal) {
                ctx.setOriginLocal(true);
            }
            ctx.setMethodCall(oldCall);
        }
    }

    protected Object getOwnerForLock() {
        Object owner = this.getCurrentTransaction();
        if (owner == null) {
            owner = Thread.currentThread();
        }
        return owner;
    }

    public NodeSPI<K, V> findNode(Fqn fqn) {
        try {
            return this.findNode(fqn, null);
        }
        catch (CacheException e) {
            this.log.warn((Object)"Unexpected error", (Throwable)e);
            return null;
        }
    }

    private NodeSPI<K, V> findNodeCheck(GlobalTransaction tx, Fqn fqn) {
        NodeSPI<K, V> n = this.findNode(fqn);
        if (n == null) {
            String errStr = "node " + fqn + " not found (gtx=" + tx + ", caller=" + Thread.currentThread() + ")";
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)errStr);
            }
            throw new NodeNotExistsException(errStr);
        }
        return n;
    }

    public boolean realRemove(Fqn f, boolean skipMarkerCheck) {
        NodeSPI<K, V> n = this.peek(f, true);
        if (n == null) {
            return false;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Performing a real remove for node " + f + ", marked for removal."));
        }
        if (skipMarkerCheck || n.isDeleted()) {
            if (n.getFqn().isRoot()) {
                n.markAsDeleted(true);
                n.removeChildrenDirect();
                return true;
            }
            return n.getParent().removeChildDirect(n.getFqn().getLastElement());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Node " + f + " NOT marked for removal as expected, not removing!"));
        }
        return false;
    }

    private NodeSPI<K, V> findNode(Fqn fqn, DataVersion version) throws CacheException {
        if (fqn == null) {
            return null;
        }
        NodeSPI<K, V> toReturn = this.peek(fqn, false);
        if (version != null && this.configuration.isNodeLockingOptimistic()) {
            DataVersion nodeVersion = toReturn.getVersion();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("looking for optimistic node [" + fqn + "] with version [" + version + "].  My version is [" + nodeVersion + "]"));
            }
            if (nodeVersion.newerThan(version)) {
                throw new CacheException("Unable to validate versions.");
            }
        }
        return toReturn;
    }

    @Override
    public synchronized RegionManager getRegionManager() {
        if (this.regionManager == null) {
            this.regionManager = new RegionManager(this);
        }
        return this.regionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Marshaller getMarshaller() {
        if (this.marshaller_ == null) {
            CacheImpl cacheImpl = this;
            synchronized (cacheImpl) {
                if (this.marshaller_ == null) {
                    if (this.configuration.getMarshallerClass() == null || this.configuration.getMarshallerClass().equals(VersionAwareMarshaller.class.getName())) {
                        this.marshaller_ = new VersionAwareMarshaller(this.getRegionManager(), this.configuration);
                    } else {
                        try {
                            this.marshaller_ = (Marshaller)Util.loadClass(this.configuration.getMarshallerClass()).newInstance();
                        }
                        catch (Exception e) {
                            this.log.error((Object)("Unable to load marshaller " + this.configuration.getMarshallerClass() + ".  Falling back to default (" + VersionAwareMarshaller.class.getName() + ")"));
                            this.marshaller_ = new VersionAwareMarshaller(this.getRegionManager(), this.configuration);
                        }
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Using marshaller " + this.marshaller_.getClass().getName()));
                    }
                }
            }
        }
        return this.marshaller_;
    }

    protected String getDefaultProperties() {
        return "UDP(mcast_addr=224.0.0.36;mcast_port=55566;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=1000;num_initial_members=2):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=600,1200,2400,4800):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=8192):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true):pbcast.STATE_TRANSFER";
    }

    private void initialiseCacheLoaderManager() throws CacheException {
        if (this.cacheLoaderManager == null) {
            this.cacheLoaderManager = new CacheLoaderManager();
        }
        this.cacheLoaderManager.setConfig(this.configuration.getCacheLoaderConfig(), this);
    }

    @Deprecated
    public void setCacheLoader(CacheLoader loader) {
        this.log.warn((Object)"Using deprecated config method setCacheLoader.  This element will be removed in future, please use CacheLoaderConfiguration instead.");
        try {
            if (this.cacheLoaderManager == null) {
                this.initialiseCacheLoaderManager();
            }
        }
        catch (Exception e) {
            this.log.warn((Object)"Problem setting cache loader.  Perhaps your cache loader config has not been set yet?");
        }
        this.cacheLoaderManager.setCacheLoader(loader);
    }

    public void purgeCacheLoaders() throws Exception {
        if (this.cacheLoaderManager != null) {
            this.cacheLoaderManager.purgeLoaders(true);
        }
    }

    private void initialiseChannelAndRpcDispatcher() throws CacheException {
        this.channel = this.configuration.getRuntimeConfig().getChannel();
        if (this.channel == null) {
            this.channel = this.getMultiplexerChannel();
            if (this.channel != null) {
                this.configuration.setUsingMultiplexer(true);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Created Multiplexer Channel for cache cluster " + this.configuration.getClusterName() + " using stack " + this.configuration.getMultiplexerStack()));
                }
            } else {
                if (this.configuration.getClusterConfig() == null) {
                    this.log.debug((Object)"setting cluster properties to default value");
                    this.configuration.setClusterConfig(this.getDefaultProperties());
                }
                try {
                    this.channel = new JChannel(this.configuration.getClusterConfig());
                }
                catch (Exception e) {
                    throw new CacheException("Unable to create JGroups channel", e);
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("cache properties: " + this.configuration.getClusterConfig()));
                }
            }
            this.configuration.getRuntimeConfig().setChannel(this.channel);
        }
        this.channel.setOpt(5, (Object)true);
        this.channel.setOpt(6, (Object)true);
        this.channel.setOpt(0, (Object)true);
        this.disp = new InactiveRegionAwareRpcDispatcher(this.channel, (MessageListener)this.ml, (MembershipListener)new MembershipListenerAdaptor(), this);
        this.disp.setRequestMarshaller((RpcDispatcher.Marshaller)this.getMarshaller());
        this.disp.setResponseMarshaller((RpcDispatcher.Marshaller)this.getMarshaller());
    }

    private JChannel getMultiplexerChannel() throws CacheException {
        String stackName = this.configuration.getMultiplexerStack();
        RuntimeConfig rtc = this.configuration.getRuntimeConfig();
        ChannelFactory channelFactory = rtc.getMuxChannelFactory();
        JChannel muxchannel = null;
        if (channelFactory != null) {
            try {
                muxchannel = (JChannel)channelFactory.createMultiplexerChannel(stackName, this.configuration.getClusterName());
            }
            catch (Exception e) {
                throw new CacheException("Failed to create multiplexed channel using stack " + stackName, e);
            }
        }
        return muxchannel;
    }

    @Override
    public List<Interceptor> getInterceptorChain() {
        List<Interceptor> modifiable = this.getInterceptors();
        return modifiable == null ? null : Collections.unmodifiableList(modifiable);
    }

    @Override
    public void addCacheListener(Object listener) {
        this.getNotifier().addCacheListener(listener);
    }

    @Override
    public void addCacheListener(Fqn<?> region, Object listener) {
        throw new UnsupportedOperationException("Not implemented in this release");
    }

    @Override
    public void removeCacheListener(Object listener) {
        Notifier n = this.getNotifier();
        if (n != null) {
            n.removeCacheListener(listener);
        }
    }

    @Override
    public void removeCacheListener(Fqn<?> region, Object listener) {
        throw new UnsupportedOperationException("Not implemented in this release");
    }

    @Override
    public Set<Object> getCacheListeners() {
        return this.getNotifier().getCacheListeners();
    }

    @Override
    public Set<Object> getCacheListeners(Fqn<?> region) {
        throw new UnsupportedOperationException("Not implemented in this release");
    }

    @Override
    public synchronized void addInterceptor(Interceptor i, int position) {
        List<Interceptor> interceptors = this.getInterceptors();
        i.setCache(this);
        interceptors.add(position, i);
        Interceptor linkedChain = InterceptorChainFactory.getInstance().correctInterceptorChaining(interceptors);
        this.setInterceptorChain(linkedChain);
    }

    @Override
    public synchronized void removeInterceptor(int position) {
        List<Interceptor> i = this.getInterceptors();
        i.remove(position);
        this.setInterceptorChain(InterceptorChainFactory.getInstance().correctInterceptorChaining(i));
    }

    @Override
    public RPCManager getRPCManager() {
        return this.configuration.getRuntimeConfig().getRPCManager();
    }

    @Override
    public String getClusterName() {
        return this.getConfiguration().getClusterName();
    }

    @Override
    public void evict(Fqn<?> fqn, boolean recursive) {
        NodeSPI<K, V> node = this.peek(fqn, false);
        if (node != null && node.isResident()) {
            return;
        }
        if (recursive) {
            if (node != null) {
                this.evictChildren(node);
            }
        } else {
            this.evict(fqn);
        }
    }

    private void evictChildren(NodeSPI<K, V> n) {
        for (NodeSPI<K, V> child : n.getChildrenDirect()) {
            this.evictChildren(child);
        }
        this.evict(n.getFqn());
    }

    @Override
    public Region getRegion(Fqn<?> fqn, boolean createIfAbsent) {
        return this.getRegionManager().getRegion(fqn, createIfAbsent);
    }

    @Override
    public boolean removeRegion(Fqn<?> fqn) {
        return this.getRegionManager().removeRegion(fqn);
    }

    @Override
    public boolean removeNode(Fqn<?> fqn) {
        return this.remove(fqn);
    }

    @Override
    public void putForExternalRead(Fqn<?> fqn, K key, V value) {
        if (!this.exists(fqn)) {
            this.getInvocationContext().getOptionOverrides().setFailSilently(true);
            GlobalTransaction tx = this.getCurrentTransaction();
            MethodCall m = MethodCallFactory.create(MethodDeclarations.putForExternalReadMethodLocal, tx, fqn, key, value);
            this.invokeMethod(m, true);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("putForExternalRead() called with Fqn " + fqn + " and this node already exists.  This method is hence a no op."));
        }
    }

    public void _putForExternalRead(GlobalTransaction gtx, Fqn fqn, K key, V value) {
        this._put(gtx, fqn, key, value, true);
    }

    public boolean isStarted() {
        return this.getCacheStatus() == CacheStatus.STARTED;
    }

    protected void setMessageListener(MessageListenerAdaptor ml) {
        this.ml = ml;
    }

    static class 3 {
        static final /* synthetic */ int[] $SwitchMap$org$jboss$cache$config$Configuration$CacheMode;

        static {
            $SwitchMap$org$jboss$cache$config$Configuration$CacheMode = new int[Configuration.CacheMode.values().length];
            try {
                3.$SwitchMap$org$jboss$cache$config$Configuration$CacheMode[Configuration.CacheMode.LOCAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$jboss$cache$config$Configuration$CacheMode[Configuration.CacheMode.REPL_SYNC.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$jboss$cache$config$Configuration$CacheMode[Configuration.CacheMode.REPL_ASYNC.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$jboss$cache$config$Configuration$CacheMode[Configuration.CacheMode.INVALIDATION_ASYNC.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$jboss$cache$config$Configuration$CacheMode[Configuration.CacheMode.INVALIDATION_SYNC.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    protected class MembershipListenerAdaptor
    implements ExtendedMembershipListener {
        protected MembershipListenerAdaptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void viewAccepted(View new_view) {
            Vector new_mbrs = new_view.getMembers();
            if (CacheImpl.this.log.isInfoEnabled()) {
                CacheImpl.this.log.info((Object)("viewAccepted(): " + new_view));
            }
            Vector vector = CacheImpl.this.members;
            synchronized (vector) {
                boolean needNotification = false;
                if (new_mbrs != null) {
                    Vector removed = new Vector(CacheImpl.this.members);
                    removed.removeAll(new_mbrs);
                    CacheImpl.this.removeLocksForDeadMembers(CacheImpl.this.root, removed);
                    CacheImpl.this.members.removeAllElements();
                    CacheImpl.this.members.addAll(new_mbrs);
                    needNotification = true;
                }
                CacheImpl.this.coordinator = CacheImpl.this.members.size() != 0 && ((Address)CacheImpl.this.members.get(0)).equals(CacheImpl.this.getLocalAddress());
                if (needNotification && CacheImpl.this.notifier != null) {
                    InvocationContext ctx = CacheImpl.this.getInvocationContext();
                    CacheImpl.this.notifier.notifyViewChange(new_view, ctx);
                }
                CacheImpl.this.members.notifyAll();
            }
        }

        public void suspect(Address suspected_mbr) {
        }

        public void block() {
            CacheImpl.this.flushBlockGate.close();
            if (CacheImpl.this.log.isDebugEnabled()) {
                CacheImpl.this.log.debug((Object)("Block received at " + CacheImpl.this.getLocalAddress()));
            }
            MethodCall m = MethodCallFactory.create(MethodDeclarations.blockChannelLocal, new Object[0]);
            CacheImpl.this.getInvocationContext().getOptionOverrides().setSkipCacheStatusCheck(true);
            CacheImpl.this.invokeMethod(m, true);
            if (CacheImpl.this.log.isDebugEnabled()) {
                CacheImpl.this.log.debug((Object)("Block processed at " + CacheImpl.this.getLocalAddress()));
            }
        }

        public void unblock() {
            if (CacheImpl.this.log.isDebugEnabled()) {
                CacheImpl.this.log.debug((Object)("UnBlock received at " + CacheImpl.this.getLocalAddress()));
            }
            MethodCall m = MethodCallFactory.create(MethodDeclarations.unblockChannelLocal, new Object[0]);
            CacheImpl.this.getInvocationContext().getOptionOverrides().setSkipCacheStatusCheck(true);
            CacheImpl.this.invokeMethod(m, true);
            if (CacheImpl.this.log.isDebugEnabled()) {
                CacheImpl.this.log.debug((Object)("UnBlock processed at " + CacheImpl.this.getLocalAddress()));
            }
            CacheImpl.this.flushBlockGate.open();
        }
    }

    protected class MessageListenerAdaptor
    implements ExtendedMessageListener {
        protected volatile Exception setStateException;
        private final Object stateLock = new Object();

        protected MessageListenerAdaptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForState() throws Exception {
            Object object = this.stateLock;
            synchronized (object) {
                while (!CacheImpl.this.isStateSet) {
                    if (this.setStateException != null) {
                        throw this.setStateException;
                    }
                    try {
                        this.stateLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        protected void stateReceivedSuccess() {
            CacheImpl.this.isStateSet = true;
            this.setStateException = null;
        }

        protected void stateReceivingFailed(Throwable t) {
            if (t instanceof CacheException) {
                CacheImpl.this.log.debug((Object)t);
            } else {
                CacheImpl.this.log.error((Object)"failed setting state", t);
            }
            this.setStateException = t instanceof Exception ? (Exception)t : new Exception(t);
        }

        protected void stateProducingFailed(Throwable t) {
            if (t instanceof CacheException) {
                CacheImpl.this.log.debug((Object)t);
            } else {
                CacheImpl.this.log.error((Object)("Caught " + t.getClass().getName() + " while responding to state transfer request"), t);
            }
        }

        public void receive(Message msg) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getState() {
            MarshalledValueOutputStream out = null;
            byte[] result = null;
            ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(16384);
            try {
                out = new MarshalledValueOutputStream((OutputStream)baos);
                CacheImpl.this.getStateTransferManager().getState((ObjectOutputStream)out, Fqn.ROOT, CacheImpl.this.configuration.getStateRetrievalTimeout(), true, true);
            }
            catch (Throwable t) {
                this.stateProducingFailed(t);
            }
            finally {
                result = baos.getRawBuffer();
                org.jgroups.util.Util.close((OutputStream)out);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(byte[] new_state) {
            if (new_state == null) {
                CacheImpl.this.log.debug((Object)"transferred state is null (may be first member in cluster)");
                return;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(new_state);
            MarshalledValueInputStream in = null;
            try {
                in = new MarshalledValueInputStream((InputStream)bais);
                CacheImpl.this.getStateTransferManager().setState((ObjectInputStream)in, Fqn.ROOT);
                this.stateReceivedSuccess();
            }
            catch (Throwable t) {
                try {
                    this.stateReceivingFailed(t);
                }
                catch (Throwable throwable) {
                    org.jgroups.util.Util.close(in);
                    Object object = this.stateLock;
                    synchronized (object) {
                        this.stateLock.notifyAll();
                    }
                    throw throwable;
                }
                org.jgroups.util.Util.close((InputStream)in);
                Object object = this.stateLock;
                synchronized (object) {
                    this.stateLock.notifyAll();
                }
            }
            org.jgroups.util.Util.close((InputStream)in);
            Object object = this.stateLock;
            synchronized (object) {
                this.stateLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getState(String state_id) {
            boolean hasDifferentSourceAndIntegrationRoots;
            MarshalledValueOutputStream out = null;
            String sourceRoot = state_id;
            byte[] result = null;
            boolean bl = hasDifferentSourceAndIntegrationRoots = state_id.indexOf("_PARTIAL_STATE_DELIMITER") > 0;
            if (hasDifferentSourceAndIntegrationRoots) {
                sourceRoot = state_id.split("_PARTIAL_STATE_DELIMITER")[0];
            }
            ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(16384);
            try {
                out = new MarshalledValueOutputStream((OutputStream)baos);
                CacheImpl.this.getStateTransferManager().getState((ObjectOutputStream)out, Fqn.fromString(sourceRoot), CacheImpl.this.configuration.getStateRetrievalTimeout(), true, true);
            }
            catch (Throwable t) {
                this.stateProducingFailed(t);
            }
            finally {
                result = baos.getRawBuffer();
                org.jgroups.util.Util.close((OutputStream)out);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void getState(OutputStream ostream) {
            MarshalledValueOutputStream out = null;
            try {
                out = new MarshalledValueOutputStream(ostream);
                CacheImpl.this.getStateTransferManager().getState((ObjectOutputStream)out, Fqn.ROOT, CacheImpl.this.configuration.getStateRetrievalTimeout(), true, true);
            }
            catch (Throwable t) {
                try {
                    this.stateProducingFailed(t);
                }
                catch (Throwable throwable) {
                    org.jgroups.util.Util.close(out);
                    throw throwable;
                }
                org.jgroups.util.Util.close((OutputStream)out);
            }
            org.jgroups.util.Util.close((OutputStream)out);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void getState(String state_id, OutputStream ostream) {
            boolean hasDifferentSourceAndIntegrationRoots;
            String sourceRoot = state_id;
            MarshalledValueOutputStream out = null;
            boolean bl = hasDifferentSourceAndIntegrationRoots = state_id.indexOf("_PARTIAL_STATE_DELIMITER") > 0;
            if (hasDifferentSourceAndIntegrationRoots) {
                sourceRoot = state_id.split("_PARTIAL_STATE_DELIMITER")[0];
            }
            try {
                out = new MarshalledValueOutputStream(ostream);
                CacheImpl.this.getStateTransferManager().getState((ObjectOutputStream)out, Fqn.fromString(sourceRoot), CacheImpl.this.configuration.getStateRetrievalTimeout(), true, true);
            }
            catch (Throwable t) {
                try {
                    this.stateProducingFailed(t);
                }
                catch (Throwable throwable) {
                    org.jgroups.util.Util.close(out);
                    throw throwable;
                }
                org.jgroups.util.Util.close((OutputStream)out);
            }
            org.jgroups.util.Util.close((OutputStream)out);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(InputStream istream) {
            if (istream == null) {
                CacheImpl.this.log.debug((Object)"stream is null (may be first member in cluster)");
                return;
            }
            MarshalledValueInputStream in = null;
            try {
                in = new MarshalledValueInputStream(istream);
                CacheImpl.this.getStateTransferManager().setState((ObjectInputStream)in, Fqn.ROOT);
                this.stateReceivedSuccess();
            }
            catch (Throwable t) {
                try {
                    this.stateReceivingFailed(t);
                }
                catch (Throwable throwable) {
                    org.jgroups.util.Util.close(in);
                    Object object = this.stateLock;
                    synchronized (object) {
                        this.stateLock.notifyAll();
                    }
                    throw throwable;
                }
                org.jgroups.util.Util.close((InputStream)in);
                Object object = this.stateLock;
                synchronized (object) {
                    this.stateLock.notifyAll();
                }
            }
            org.jgroups.util.Util.close((InputStream)in);
            Object object = this.stateLock;
            synchronized (object) {
                this.stateLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(String state_id, byte[] state) {
            Object subroot;
            boolean hasDifferentSourceAndIntegrationRoots;
            if (state == null) {
                CacheImpl.this.log.debug((Object)"partial transferred state is null");
                return;
            }
            MarshalledValueInputStream in = null;
            String targetRoot = state_id;
            boolean bl = hasDifferentSourceAndIntegrationRoots = state_id.indexOf("_PARTIAL_STATE_DELIMITER") > 0;
            if (hasDifferentSourceAndIntegrationRoots) {
                targetRoot = state_id.split("_PARTIAL_STATE_DELIMITER")[1];
            }
            try {
                CacheImpl.this.log.debug((Object)("Setting received partial state for subroot " + state_id));
                subroot = Fqn.fromString(targetRoot);
                ByteArrayInputStream bais = new ByteArrayInputStream(state);
                in = new MarshalledValueInputStream((InputStream)bais);
                CacheImpl.this.getStateTransferManager().setState((ObjectInputStream)in, (Fqn)subroot);
                this.stateReceivedSuccess();
            }
            catch (Throwable t) {
                try {
                    this.stateReceivingFailed(t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    org.jgroups.util.Util.close(in);
                    Object object = this.stateLock;
                    synchronized (object) {
                        this.stateLock.notifyAll();
                    }
                }
            }
            org.jgroups.util.Util.close((InputStream)in);
            subroot = this.stateLock;
            synchronized (subroot) {
                this.stateLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(String state_id, InputStream istream) {
            Object subroot;
            boolean hasDifferentSourceAndIntegrationRoots;
            String targetRoot = state_id;
            MarshalledValueInputStream in = null;
            boolean bl = hasDifferentSourceAndIntegrationRoots = state_id.indexOf("_PARTIAL_STATE_DELIMITER") > 0;
            if (hasDifferentSourceAndIntegrationRoots) {
                targetRoot = state_id.split("_PARTIAL_STATE_DELIMITER")[1];
            }
            if (istream == null) {
                CacheImpl.this.log.debug((Object)"stream is null (may be first member in cluster). State is not set");
                return;
            }
            try {
                CacheImpl.this.log.debug((Object)("Setting received partial state for subroot " + state_id));
                in = new MarshalledValueInputStream(istream);
                subroot = Fqn.fromString(targetRoot);
                CacheImpl.this.getStateTransferManager().setState((ObjectInputStream)in, (Fqn)subroot);
                this.stateReceivedSuccess();
            }
            catch (Throwable t) {
                try {
                    this.stateReceivingFailed(t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    org.jgroups.util.Util.close(in);
                    Object object = this.stateLock;
                    synchronized (object) {
                        this.stateLock.notifyAll();
                    }
                }
            }
            org.jgroups.util.Util.close((InputStream)in);
            subroot = this.stateLock;
            synchronized (subroot) {
                this.stateLock.notifyAll();
            }
        }
    }
}

