/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config;

import java.util.Properties;
import org.jboss.cache.buddyreplication.NextMemberBuddyLocator;
import org.jboss.cache.config.ConfigurationComponent;
import org.jboss.cache.config.Dynamic;

public class BuddyReplicationConfig
extends ConfigurationComponent {
    private static final long serialVersionUID = -4826380823985089339L;
    private boolean enabled;
    private String buddyPoolName;
    private boolean autoDataGravitation = true;
    private boolean dataGravitationRemoveOnFind = true;
    private boolean dataGravitationSearchBackupTrees = true;
    @Dynamic
    private int buddyCommunicationTimeout = 10000;
    private BuddyLocatorConfig buddyLocatorConfig;

    public boolean isAutoDataGravitation() {
        return this.autoDataGravitation;
    }

    public void setAutoDataGravitation(boolean autoDataGravitation) {
        this.testImmutability("autoDataGravitation");
        this.autoDataGravitation = autoDataGravitation;
    }

    public int getBuddyCommunicationTimeout() {
        return this.buddyCommunicationTimeout;
    }

    public void setBuddyCommunicationTimeout(int buddyCommunicationTimeout) {
        this.testImmutability("buddyCommunicationTimeout");
        this.buddyCommunicationTimeout = buddyCommunicationTimeout;
    }

    public String getBuddyPoolName() {
        return this.buddyPoolName;
    }

    public void setBuddyPoolName(String buddyPoolName) {
        this.testImmutability("buddyPoolName");
        this.buddyPoolName = buddyPoolName;
    }

    public boolean isDataGravitationRemoveOnFind() {
        return this.dataGravitationRemoveOnFind;
    }

    public void setDataGravitationRemoveOnFind(boolean dataGravitationRemoveOnFind) {
        this.testImmutability("dataGravitationRemoveOnFind");
        this.dataGravitationRemoveOnFind = dataGravitationRemoveOnFind;
    }

    public boolean isDataGravitationSearchBackupTrees() {
        return this.dataGravitationSearchBackupTrees;
    }

    public void setDataGravitationSearchBackupTrees(boolean dataGravitationSearchBackupTrees) {
        this.testImmutability("dataGravitationSearchBackupTrees");
        this.dataGravitationSearchBackupTrees = dataGravitationSearchBackupTrees;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.testImmutability("enabled");
        this.enabled = enabled;
    }

    public BuddyLocatorConfig getBuddyLocatorConfig() {
        return this.buddyLocatorConfig;
    }

    public void setBuddyLocatorConfig(BuddyLocatorConfig buddyLocatorConfig) {
        this.testImmutability("buddyLocatorConfig");
        this.replaceChildConfig(this.buddyLocatorConfig, buddyLocatorConfig);
        this.buddyLocatorConfig = buddyLocatorConfig;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BuddyReplicationConfig) {
            BuddyReplicationConfig other = (BuddyReplicationConfig)obj;
            return this.autoDataGravitation == other.autoDataGravitation && this.dataGravitationRemoveOnFind == other.dataGravitationRemoveOnFind && this.dataGravitationSearchBackupTrees == other.dataGravitationSearchBackupTrees && this.enabled == other.enabled && this.buddyCommunicationTimeout == other.buddyCommunicationTimeout && BuddyReplicationConfig.safeEquals(this.buddyPoolName, other.buddyPoolName) && BuddyReplicationConfig.safeEquals(this.buddyLocatorConfig, other.buddyLocatorConfig);
        }
        return false;
    }

    public int hashCode() {
        int result = 11;
        result = 29 * result + (this.autoDataGravitation ? 0 : 1);
        result = 29 * result + (this.dataGravitationRemoveOnFind ? 0 : 1);
        result = 29 * result + (this.dataGravitationSearchBackupTrees ? 0 : 1);
        result = 29 * result + (this.enabled ? 0 : 1);
        result = 29 * result + this.buddyCommunicationTimeout;
        result = 29 * result + (this.buddyPoolName == null ? 0 : this.buddyPoolName.hashCode());
        result = 29 * result + (this.buddyLocatorConfig == null ? 0 : this.buddyLocatorConfig.hashCode());
        return result;
    }

    public static class BuddyLocatorConfig
    extends ConfigurationComponent {
        private static final long serialVersionUID = -8003634097931826091L;
        private String buddyLocatorClass = NextMemberBuddyLocator.class.getName();
        private Properties buddyLocatorProperties;

        public String getBuddyLocatorClass() {
            return this.buddyLocatorClass;
        }

        public void setBuddyLocatorClass(String buddyLocatorClass) {
            this.testImmutability("buddyLocatorClass");
            this.buddyLocatorClass = buddyLocatorClass;
            if (buddyLocatorClass == null) {
                this.buddyLocatorClass = NextMemberBuddyLocator.class.getName();
            }
        }

        public Properties getBuddyLocatorProperties() {
            return this.buddyLocatorProperties;
        }

        public void setBuddyLocatorProperties(Properties buddyLocatorProperties) {
            this.testImmutability("buddyLocatorProperties");
            this.buddyLocatorProperties = buddyLocatorProperties;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof BuddyLocatorConfig) {
                BuddyLocatorConfig other = (BuddyLocatorConfig)obj;
                return BuddyLocatorConfig.safeEquals(this.buddyLocatorClass, other.buddyLocatorClass) && BuddyLocatorConfig.safeEquals(this.buddyLocatorProperties, other.buddyLocatorProperties);
            }
            return false;
        }

        public int hashCode() {
            int result = 19;
            result = 41 * result + (this.buddyLocatorClass == null ? 0 : this.buddyLocatorClass.hashCode());
            result = 41 * result + (this.buddyLocatorProperties == null ? 0 : this.buddyLocatorProperties.hashCode());
            return result;
        }

        public String toString() {
            return super.toString() + " class=" + this.buddyLocatorClass + " properties=" + this.buddyLocatorProperties;
        }
    }
}

