/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.BaseRpcInterceptor;
import org.jboss.cache.interceptors.InvalidationInterceptorMBean;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.transaction.TransactionEntry;
import org.jboss.cache.transaction.TransactionTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidationInterceptor
extends BaseRpcInterceptor
implements InvalidationInterceptorMBean {
    private long m_invalidations = 0L;
    protected TransactionTable txTable;
    protected Map<GlobalTransaction, List<MethodCall>> txMods;
    protected boolean optimistic;

    @Override
    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.txTable = cache.getTransactionTable();
        this.optimistic = cache.getConfiguration().isNodeLockingOptimistic();
        if (this.optimistic) {
            this.txMods = new ConcurrentHashMap<GlobalTransaction, List<MethodCall>>();
        }
    }

    @Override
    public Object invoke(InvocationContext ctx) throws Throwable {
        MethodCall m = ctx.getMethodCall();
        Option optionOverride = ctx.getOptionOverrides();
        if (optionOverride != null && optionOverride.isCacheModeLocal() && ctx.getTransaction() == null) {
            return super.invoke(ctx);
        }
        Transaction tx = ctx.getTransaction();
        Object retval = super.invoke(ctx);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("(" + this.cache.getLocalAddress() + ") method call " + (Object)((Object)m)));
        }
        if (MethodDeclarations.isCrudMethod(m.getMethodId())) {
            if (m.getMethodId() != 45) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Is a CRUD method");
                }
                HashSet<Fqn> fqns = new HashSet<Fqn>();
                this.findAndAddFqns(m.getArgs(), fqns, m.getMethodId() == 36);
                if (!(fqns.isEmpty() || tx != null && this.isValid(tx))) {
                    for (Fqn fqn : fqns) {
                        this.invalidateAcrossCluster(fqn, null, this.isSynchronous(optionOverride), ctx);
                    }
                }
            } else {
                this.log.debug((Object)"Encountered a putForExternalRead() - is a no op.");
            }
        } else if (tx != null) {
            switch (m.getMethodId()) {
                case 10: {
                    this.log.debug((Object)"Entering InvalidationInterceptor's prepare phase");
                    GlobalTransaction gtx = ctx.getGlobalTransaction();
                    TransactionEntry entry = this.txTable.get(gtx);
                    if (entry == null) {
                        throw new IllegalStateException("cannot find transaction entry for " + gtx);
                    }
                    LinkedList<MethodCall> modifications = new LinkedList<MethodCall>(entry.getModifications());
                    if (modifications.size() > 0) {
                        this.broadcastInvalidate(modifications, gtx, tx, ctx);
                        break;
                    }
                    this.log.debug((Object)"Nothing to invalidate - no modifications in the transaction.");
                    break;
                }
                case 18: {
                    GlobalTransaction gtx = ctx.getGlobalTransaction();
                    TransactionEntry entry = this.txTable.get(gtx);
                    if (entry == null) {
                        throw new IllegalStateException("cannot find transaction entry for " + gtx);
                    }
                    LinkedList<MethodCall> modifications = new LinkedList<MethodCall>(entry.getModifications());
                    if (modifications.size() <= 0) break;
                    this.txMods.put(gtx, modifications);
                    break;
                }
                case 11: {
                    if (!this.optimistic) break;
                    GlobalTransaction gtx = ctx.getGlobalTransaction();
                    List<MethodCall> modifications = this.txMods.remove(gtx);
                    this.broadcastInvalidate(modifications, gtx, tx, ctx);
                    this.log.debug((Object)"Committing.  Broadcasting invalidations.");
                    break;
                }
                case 12: {
                    if (!this.optimistic) break;
                    GlobalTransaction gtx = ctx.getGlobalTransaction();
                    this.txMods.remove(gtx);
                    this.log.debug((Object)"Caught a rollback.  Clearing modification in txMods");
                }
            }
        }
        return retval;
    }

    private void broadcastInvalidate(List<MethodCall> modifications, GlobalTransaction gtx, Transaction tx, InvocationContext ctx) {
        if (this.containsPutForExternalRead(modifications)) {
            this.log.debug((Object)"Modification list contains a putForExternalRead operation.  Not invalidating.");
        } else {
            try {
                this.invalidateModifications(modifications, this.configuration.isNodeLockingOptimistic() ? this.getWorkspace(gtx) : null, this.defaultSynchronous, ctx);
            }
            catch (Throwable t) {
                this.log.warn((Object)"Unable to broadcast evicts as a part of the prepare phase.  Rolling back.", t);
                try {
                    tx.setRollbackOnly();
                }
                catch (SystemException se) {
                    throw new RuntimeException("setting tx rollback failed ", se);
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException("Unable to broadcast invalidation messages", t);
            }
        }
    }

    private boolean containsPutForExternalRead(List<MethodCall> l) {
        if (l == null) {
            return false;
        }
        for (MethodCall m : l) {
            if (m.getMethodId() != 45 && m.getMethodId() != 46) continue;
            return true;
        }
        return false;
    }

    @Override
    public long getInvalidations() {
        return this.m_invalidations;
    }

    @Override
    public void resetStatistics() {
        this.m_invalidations = 0L;
    }

    @Override
    public Map<String, Object> dumpStatistics() {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        retval.put("Invalidations", this.m_invalidations);
        return retval;
    }

    protected void invalidateAcrossCluster(Fqn fqn, TransactionWorkspace workspace, InvocationContext ctx) throws Throwable {
        this.invalidateAcrossCluster(fqn, workspace, this.defaultSynchronous, ctx);
    }

    protected void invalidateAcrossCluster(Fqn fqn, TransactionWorkspace workspace, boolean synchronous, InvocationContext ctx) throws Throwable {
        if (this.configuration.getExposeManagementStatistics() && this.getStatisticsEnabled()) {
            ++this.m_invalidations;
        }
        MethodCall call = MethodCallFactory.create(MethodDeclarations.invalidateMethodLocal, fqn, this.getNodeVersion(workspace, fqn));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Cache [" + this.cache.getLocalAddress() + "] replicating " + (Object)((Object)call)));
        }
        this.replicateCall(call, synchronous, ctx.getOptionOverrides());
    }

    protected DataVersion getNodeVersion(TransactionWorkspace w, Fqn f) {
        if (w == null) {
            return null;
        }
        WorkspaceNode wn = w.getNode(f);
        DataVersion v = wn.getVersion();
        if (wn.isVersioningImplicit()) {
            v = ((DefaultDataVersion)v).increment();
        }
        return v;
    }

    protected void invalidateModifications(List<MethodCall> modifications, TransactionWorkspace workspace, InvocationContext ctx) throws Throwable {
        this.invalidateModifications(modifications, workspace, this.defaultSynchronous, ctx);
    }

    protected void invalidateModifications(List<MethodCall> modifications, TransactionWorkspace workspace, boolean synchronous, InvocationContext ctx) throws Throwable {
        Set<Fqn> modifiedFqns = this.optimisedIterator(modifications);
        for (Fqn fqn : modifiedFqns) {
            this.invalidateAcrossCluster(fqn, workspace, synchronous, ctx);
        }
    }

    protected TransactionWorkspace getWorkspace(GlobalTransaction gtx) {
        OptimisticTransactionEntry entry = (OptimisticTransactionEntry)this.txTable.get(gtx);
        return entry.getTransactionWorkSpace();
    }

    protected void findAndAddFqns(Object[] objects, Set<Fqn> fqns, boolean isMove) {
        if (isMove) {
            Fqn f = (Fqn)objects[0];
            fqns.add(f);
            Object le = f.getLastElement();
            Fqn parent = (Fqn)objects[1];
            fqns.add(new Fqn<Object>(parent, le));
        } else {
            fqns.add((Fqn)objects[1]);
        }
    }

    protected Set<Fqn> optimisedIterator(List<MethodCall> list) {
        HashSet<Fqn> fqns = new HashSet<Fqn>();
        if (list != null) {
            for (MethodCall mc : list) {
                if (!MethodDeclarations.isCrudMethod(mc.getMethodId())) continue;
                this.findAndAddFqns(mc.getArgs(), fqns, 36 == mc.getMethodId());
            }
        }
        return fqns;
    }
}

