/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.AbstractNode;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeFactory;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.VersionedNode;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceNodeImpl<K, V>
extends AbstractNode<K, V>
implements WorkspaceNode<K, V> {
    private static Log log = LogFactory.getLog(WorkspaceNodeImpl.class);
    private NodeSPI<K, V> node;
    private TransactionWorkspace workspace;
    private DataVersion version = DefaultDataVersion.ZERO;
    private boolean modified;
    private boolean created;
    private boolean childrenModified;
    private Map<Object, NodeSPI<K, V>> optimisticChildNodeMap;
    private Set<Fqn> childrenAdded = new HashSet<Fqn>();
    private Set<Fqn> childrenRemoved = new HashSet<Fqn>();
    private Map<K, V> optimisticDataMap;
    private boolean versioningImplicit = true;

    public WorkspaceNodeImpl(NodeSPI<K, V> node, TransactionWorkspace workspace) {
        if (!(node instanceof VersionedNode)) {
            throw new IllegalArgumentException("node " + node + " not VersionedNode");
        }
        this.node = node;
        this.workspace = workspace;
        this.optimisticDataMap = new HashMap<K, V>(node.getDataDirect());
        Map<Object, Node<K, V>> childrenMap = node.getChildrenMapDirect();
        this.optimisticChildNodeMap = childrenMap == null ? new HashMap<Object, NodeSPI<K, V>>() : new HashMap<Object, Node<K, V>>(childrenMap);
        this.version = node.getVersion();
        if (this.version == null) {
            throw new IllegalStateException("VersionedNode version null");
        }
    }

    @Override
    public boolean isChildrenModified() {
        return this.childrenModified;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public boolean isDirty() {
        return this.modified || this.created || this.deleted;
    }

    @Override
    public Fqn getFqn() {
        return this.node.getFqn();
    }

    @Override
    public void putAll(Map<K, V> data) {
        this.realPut(data, false);
        this.modified = true;
    }

    @Override
    public void replaceAll(Map<K, V> data) {
        this.clearData();
        this.putAll(data);
    }

    @Override
    public V put(K key, V value) {
        this.modified = true;
        return this.optimisticDataMap.put(key, value);
    }

    @Override
    public V remove(K key) {
        this.modified = true;
        return this.optimisticDataMap.remove(key);
    }

    @Override
    public V get(K key) {
        return this.optimisticDataMap.get(key);
    }

    @Override
    public Set<K> getKeys() {
        return this.optimisticDataMap.keySet();
    }

    @Override
    public Set<Object> getChildrenNames() {
        return new HashSet<Object>(this.optimisticChildNodeMap.keySet());
    }

    private void realPut(Map<K, V> data, boolean eraseData) {
        this.realPut(data, eraseData, true);
    }

    private void realPut(Map<K, V> data, boolean eraseData, boolean forceDirtyFlag) {
        if (forceDirtyFlag) {
            this.modified = true;
        }
        if (eraseData) {
            this.optimisticDataMap.clear();
        }
        if (data != null) {
            this.optimisticDataMap.putAll(data);
        }
    }

    @Override
    public Node<K, V> getParent() {
        return this.node.getParent();
    }

    @Override
    public NodeSPI<K, V> createChild(Object child_name, NodeSPI<K, V> parent, CacheSPI<K, V> cache, DataVersion version) {
        if (child_name == null) {
            return null;
        }
        NodeSPI child = this.optimisticChildNodeMap.get(child_name);
        if (child == null) {
            NodeFactory factory = cache.getConfiguration().getRuntimeConfig().getNodeFactory();
            child = (NodeSPI)factory.createNodeOfType(parent, child_name, parent, null);
            this.optimisticChildNodeMap.put(child_name, child);
            this.childrenAdded.add(child.getFqn());
            this.childrenRemoved.remove(child.getFqn());
        }
        this.childrenModified = true;
        return child;
    }

    @Override
    public boolean isVersioningImplicit() {
        return this.versioningImplicit;
    }

    @Override
    public void setVersioningImplicit(boolean b) {
        this.versioningImplicit = b;
    }

    @Override
    public NodeSPI<K, V> getChild(Object childName) {
        return this.optimisticChildNodeMap.get(childName);
    }

    @Override
    public NodeSPI<K, V> getNode() {
        return this.node;
    }

    @Override
    public DataVersion getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(DataVersion version) {
        this.version = version;
    }

    @Override
    public List<Set<Fqn>> getMergedChildren() {
        ArrayList<Set<Fqn>> l = new ArrayList<Set<Fqn>>(2);
        l.add(this.childrenAdded);
        l.add(this.childrenRemoved);
        return l;
    }

    @Override
    public Map<K, V> getMergedData() {
        return this.optimisticDataMap;
    }

    @Override
    public TransactionWorkspace getTransactionWorkspace() {
        return this.workspace;
    }

    @Override
    public boolean isCreated() {
        return this.created;
    }

    @Override
    public void markAsCreated() {
        this.created = true;
    }

    @Override
    public Map<K, V> getData() {
        return Collections.unmodifiableMap(this.optimisticDataMap);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.deleted) {
            sb.append("del ");
        }
        if (this.modified) {
            sb.append("modified ");
        }
        if (this.created) {
            sb.append("new ");
        }
        return this.getClass().getSimpleName() + " [ fqn=" + this.getFqn() + " " + sb + "ver=" + this.version + " " + (this.versioningImplicit ? "implicit" : "explicit") + "]";
    }

    @Override
    public Node<K, V> addChild(Fqn f) {
        CacheSPI<K, V> cache = this.getCache();
        Node<K, V> newNode = this;
        GlobalTransaction gtx = cache.getInvocationContext().getGlobalTransaction();
        if (f.size() == 1) {
            newNode = this.createChild(f.get(0), this.node, this.getCache(), this.version);
        } else {
            WorkspaceNodeImpl currentParent = this;
            for (Object o : f.peekElements()) {
                newNode = currentParent instanceof WorkspaceNode ? ((WorkspaceNode)currentParent).getNode().getOrCreateChild(o, gtx) : (currentParent instanceof WorkspaceNode ? ((WorkspaceNode)currentParent).getNode().getOrCreateChild(o, gtx) : ((NodeSPI)((Object)currentParent)).getOrCreateChild(o, gtx));
                currentParent = newNode;
            }
        }
        return newNode;
    }

    @Override
    public void addChild(WorkspaceNode<K, V> child) {
        this.optimisticChildNodeMap.put(child.getFqn().getLastElement(), child.getNode());
        this.childrenAdded.add(child.getFqn());
        this.childrenRemoved.remove(child.getFqn());
        if (log.isTraceEnabled()) {
            log.trace((Object)("Adding child " + child.getFqn()));
        }
    }

    @Override
    public void clearData() {
        this.modified = true;
        this.optimisticDataMap.clear();
    }

    @Override
    public int dataSize() {
        return this.optimisticDataMap.size();
    }

    @Override
    public boolean hasChild(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValid() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLockForChildInsertRemove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLockForChildInsertRemove(boolean lockForChildInsertRemove) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeSPI<K, V> getChild(Fqn f) {
        if (f.size() > 1) {
            throw new UnsupportedOperationException("Workspace node does not support fetching indirect children");
        }
        return this.getChild(f.getLastElement());
    }

    @Override
    public Set<Node<K, V>> getChildren() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasChild(Fqn f) {
        throw new UnsupportedOperationException();
    }

    public NodeSPI<K, V> getNodeSPI() {
        throw new UnsupportedOperationException("WorkspaceNode has no access to a NodeSPI");
    }

    @Override
    public V putIfAbsent(K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V replace(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeChild(Fqn f) {
        if (f.size() > 1) {
            throw new UnsupportedOperationException("Workspace nodes can only remove direct children!");
        }
        Object key = f.getLastElement();
        return this.removeChild(key);
    }

    @Override
    public boolean removeChild(Object childName) {
        NodeSPI<K, V> n = this.optimisticChildNodeMap.remove(childName);
        if (n != null) {
            this.childrenRemoved.add(n.getFqn());
            this.childrenAdded.remove(n.getFqn());
            this.childrenModified = true;
            return true;
        }
        return false;
    }

    protected CacheSPI<K, V> getCache() {
        return this.node.getCache();
    }
}

