/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.mux;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Exchanger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Event;
import org.jgroups.Global;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.UpHandler;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.mux.MuxChannel;
import org.jgroups.mux.MuxHeader;
import org.jgroups.mux.ServiceInfo;
import org.jgroups.protocols.pbcast.FLUSH;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.AckCollector;
import org.jgroups.util.FIFOMessageQueue;
import org.jgroups.util.ThreadNamingPattern;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Multiplexer
implements UpHandler {
    private static final Log log = LogFactory.getLog(Multiplexer.class);
    private static final String SEPARATOR = "::";
    private static final short SEPARATOR_LEN = (short)"::".length();
    private static final String NAME = "MUX";
    private final ConcurrentMap<String, MuxChannel> services = new ConcurrentHashMap<String, MuxChannel>();
    private final JChannel channel;
    private final ExecutorService thread_pool;
    private final FIFOMessageQueue<String, Runnable> fifo_queue = new FIFOMessageQueue();
    private final AckCollector service_ack_collector = new AckCollector();
    private volatile View view = null;
    private final Map<String, Boolean> state_transfer_listeners = new HashMap<String, Boolean>();
    private final Map<String, List<Address>> service_state = new HashMap<String, List<Address>>();
    private final Map<Address, Set<String>> service_responses = new HashMap<Address, Set<String>>();
    private long service_response_timeout = 10000L;

    public Multiplexer(JChannel channel) {
        if (channel == null || !channel.isOpen()) {
            throw new IllegalArgumentException("Channel " + channel + " cannot be used for Multiplexer");
        }
        this.channel = channel;
        this.channel.setUpHandler(this);
        this.channel.setOpt(0, Boolean.TRUE);
        boolean use_thread_pool = Global.getPropertyAsBoolean("jgroups.mux.enabled", true);
        this.thread_pool = use_thread_pool ? this.createThreadPool() : null;
    }

    public JChannel getChannel() {
        return this.channel;
    }

    public Set getApplicationIds() {
        return this.getServiceIds();
    }

    public Set<String> getServiceIds() {
        return Collections.unmodifiableSet(this.services.keySet());
    }

    public long getServicesResponseTimeout() {
        return this.service_response_timeout;
    }

    public void setServicesResponseTimeout(long services_rsp_timeout) {
        this.service_response_timeout = services_rsp_timeout;
    }

    public View getServiceView(String service_id) {
        List<Address> hosts = this.service_state.get(service_id);
        if (hosts == null) {
            return null;
        }
        return this.generateServiceView(hosts);
    }

    public boolean stateTransferListenersPresent() {
        return !this.state_transfer_listeners.isEmpty();
    }

    public synchronized void registerForStateTransfer(String appl_id, String substate_id) {
        String key = appl_id;
        if (substate_id != null && substate_id.length() > 0) {
            key = key + SEPARATOR + substate_id;
        }
        this.state_transfer_listeners.put(key, Boolean.FALSE);
    }

    public synchronized boolean getState(Address target, String id, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        Collection<Boolean> values;
        boolean all_true;
        if (this.state_transfer_listeners.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, Boolean> entry : this.state_transfer_listeners.entrySet()) {
            boolean match;
            String key = entry.getKey();
            int index = key.indexOf(SEPARATOR);
            if (index > -1) {
                String tmp = key.substring(0, index);
                match = id.equals(tmp);
            } else {
                match = id.equals(key);
            }
            if (!match) continue;
            entry.setValue(Boolean.TRUE);
            break;
        }
        if (!(all_true = Util.all(values = this.state_transfer_listeners.values(), Boolean.TRUE))) {
            return true;
        }
        boolean rc = false;
        HashSet<String> keys = new HashSet<String>(this.state_transfer_listeners.keySet());
        rc = this.fetchServiceStates(target, keys, timeout);
        this.state_transfer_listeners.clear();
        return rc;
    }

    protected ThreadPoolExecutor createThreadPool() {
        int min_threads = 1;
        int max_threads = 4;
        long keep_alive = 30000L;
        ThreadFactory factory = new ThreadFactory(){
            ThreadGroup mux_threads = new ThreadGroup(Util.getGlobalThreadGroup(), "MultiplexerThreads");
            Map<String, Object> m = Multiplexer.access$000(Multiplexer.this).getInfo();
            ThreadNamingPattern pattern = (ThreadNamingPattern)this.m.get("thread_naming_pattern");

            public Thread newThread(Runnable command) {
                Thread ret = new Thread(this.mux_threads, command, "Multiplexer");
                if (this.pattern != null) {
                    this.pattern.renameThread(ret);
                }
                return ret;
            }
        };
        min_threads = Global.getPropertyAsInteger("jgroups.mux.min_threads", min_threads);
        max_threads = Global.getPropertyAsInteger("jgroups.mux.max_threads", max_threads);
        keep_alive = Global.getPropertyAsLong("jgroups.mux.keepalive_time", keep_alive);
        return new ThreadPoolExecutor(min_threads, max_threads, keep_alive, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), factory, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    protected void shutdownThreadPool() {
        if (this.thread_pool != null && !this.thread_pool.isShutdown()) {
            this.thread_pool.shutdownNow();
            try {
                this.thread_pool.awaitTermination(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchServiceStates(Address target, Set<String> keys, long timeout) throws ChannelClosedException, ChannelNotConnectedException {
        boolean all_tranfers_ok = false;
        boolean flushStarted = this.channel.startFlush(false);
        if (flushStarted) {
            try {
                for (String stateId : keys) {
                    boolean rc = this.channel.getState(target, stateId, timeout, false);
                    if (rc) continue;
                    throw new Exception("Failed transfer for state id " + stateId + ", state provider was " + target);
                }
                all_tranfers_ok = true;
            }
            catch (Exception e) {
                log.warn((Object)"Failed multiple state transfer under one flush phase ", (Throwable)e);
            }
            finally {
                this.channel.stopFlush();
            }
        }
        return flushStarted && all_tranfers_ok;
    }

    public void sendServiceUpMessage(String service, Address host, boolean bypassFlush) throws Exception {
        this.sendServiceMessage(true, (byte)3, service, host, bypassFlush, null, false);
    }

    public void sendServiceDownMessage(String service, Address host, boolean bypassFlush) throws Exception {
        this.sendServiceMessage(true, (byte)4, service, host, bypassFlush, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                boolean isServiceMessage;
                Message msg = (Message)evt.getArg();
                MuxHeader hdr = (MuxHeader)msg.getHeader(NAME);
                if (hdr == null) {
                    log.error((Object)("MuxHeader not present - discarding message " + msg));
                    return null;
                }
                Address sender = msg.getSrc();
                boolean bl = isServiceMessage = hdr.info != null;
                if (isServiceMessage) {
                    try {
                        this.handleServiceMessage(hdr.info, sender);
                        return null;
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) return null;
                        log.error((Object)"failure in handling service state request", (Throwable)e);
                    }
                    return null;
                }
                MuxChannel mux_ch = (MuxChannel)this.services.get(hdr.id);
                if (mux_ch != null) return this.passToMuxChannel(mux_ch, evt, this.fifo_queue, sender, hdr.id, false);
                return null;
            }
            case 6: {
                Object temp_merge_view;
                Vector<Address> old_members = this.view != null ? this.view.getMembers() : null;
                this.view = (View)evt.getArg();
                Vector<Address> new_members = this.view != null ? this.view.getMembers() : null;
                Vector<Address> left_members = Util.determineLeftMembers(old_members, new_members);
                if (this.view instanceof MergeView) {
                    temp_merge_view = (MergeView)this.view.clone();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("received a MergeView: " + temp_merge_view + ", adjusting the service view"));
                    }
                    try {
                        this.handleMergeView((MergeView)temp_merge_view);
                    }
                    catch (Exception e) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)"failed handling merge view", (Throwable)e);
                        }
                    }
                } else {
                    temp_merge_view = this.service_responses;
                    synchronized (temp_merge_view) {
                        this.service_responses.clear();
                    }
                    HashMap payload = (HashMap)this.view.getPayload("service_state");
                    if (payload != null) {
                        Map<String, List<Address>> e = this.service_state;
                        synchronized (e) {
                            this.service_state.putAll(payload);
                        }
                    }
                }
                this.service_ack_collector.handleView(this.view);
                for (Address member : left_members) {
                    try {
                        this.adjustServiceView(member);
                    }
                    catch (Throwable t) {
                        if (!log.isErrorEnabled()) continue;
                        log.error((Object)"failed adjusting service views", t);
                    }
                }
                return null;
            }
            case 86: {
                View prepare_view = (View)evt.getArg();
                Vector<Address> old_members = this.view != null ? this.view.getMembers() : new Vector<Address>();
                Vector<Address> added_members = new Vector<Address>(prepare_view.getMembers());
                added_members.removeAll(old_members);
                if (added_members.isEmpty()) return null;
                Map<String, List<Address>> t = this.service_state;
                synchronized (t) {
                    prepare_view.addPayload("service_state", this.service_state);
                    return null;
                }
            }
            case 9: {
                Address suspected_mbr = (Address)evt.getArg();
                this.service_ack_collector.suspect(suspected_mbr);
                Map<Address, Set<String>> map = this.service_responses;
                synchronized (map) {
                    this.service_responses.put(suspected_mbr, null);
                    this.service_responses.notifyAll();
                }
                this.passToAllMuxChannels(evt);
                return null;
            }
            case 17: 
            case 72: {
                return this.handleStateRequest(evt);
            }
            case 20: 
            case 71: {
                this.handleStateResponse(evt);
                return null;
            }
            case 8: {
                this.passToAllMuxChannels(evt);
                return null;
            }
            case 10: {
                this.passToAllMuxChannels(evt, true, true);
                this.waitUntilThreadPoolHasNoRunningTasks(1000L);
                return null;
            }
            case 75: {
                this.passToAllMuxChannels(evt);
                return null;
            }
            default: {
                this.passToAllMuxChannels(evt);
            }
        }
        return null;
    }

    private int waitUntilThreadPoolHasNoRunningTasks(long timeout) {
        int num_threads = 0;
        long end_time = System.currentTimeMillis() + timeout;
        while ((num_threads = this.fifo_queue.size()) > 0 && System.currentTimeMillis() < end_time) {
            Util.sleep(100L);
        }
        return num_threads;
    }

    public Channel createMuxChannel(String id, String stack_name) throws Exception {
        if (this.services.containsKey(id)) {
            throw new Exception("service ID \"" + id + "\" is already registered at channel" + this.getLocalAddress() + ", cannot register service with duplicate ID at the same channel");
        }
        MuxChannel ch = new MuxChannel(id, stack_name, this);
        this.services.put(id, ch);
        return ch;
    }

    private void passToAllMuxChannels(Event evt) {
        this.passToAllMuxChannels(evt, false, true);
    }

    private void passToAllMuxChannels(Event evt, boolean block, boolean bypass_thread_pool) {
        for (Map.Entry entry : this.services.entrySet()) {
            String service_name = (String)entry.getKey();
            MuxChannel ch = (MuxChannel)entry.getValue();
            this.passToMuxChannel(ch, evt, this.fifo_queue, null, service_name, block, bypass_thread_pool);
        }
    }

    public MuxChannel remove(String id) {
        return (MuxChannel)this.services.remove(id);
    }

    public void disconnect() {
        boolean all_disconnected = true;
        for (MuxChannel mux_ch : this.services.values()) {
            if (!mux_ch.isConnected()) continue;
            all_disconnected = false;
            break;
        }
        if (all_disconnected) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"disconnecting underlying JChannel as all MuxChannels are disconnected");
            }
            this.channel.disconnect();
        }
    }

    public void unregister(String appl_id) {
        this.services.remove(appl_id);
    }

    public boolean close() {
        boolean all_closed = true;
        for (MuxChannel mux_ch : this.services.values()) {
            if (!mux_ch.isOpen()) continue;
            all_closed = false;
            break;
        }
        if (all_closed) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"closing underlying JChannel as all MuxChannels are closed");
            }
            this.channel.close();
            this.services.clear();
            this.shutdownThreadPool();
        }
        return all_closed;
    }

    public void closeAll() {
        for (MuxChannel mux_ch : this.services.values()) {
            mux_ch.setConnected(false);
            mux_ch.setClosed(true);
            mux_ch.closeMessageQueue(true);
        }
        this.shutdownThreadPool();
    }

    public boolean shutdown() {
        boolean all_closed = true;
        for (MuxChannel mux_ch : this.services.values()) {
            if (!mux_ch.isOpen()) continue;
            all_closed = false;
            break;
        }
        if (all_closed) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"shutting down underlying JChannel as all MuxChannels are closed");
            }
            this.channel.shutdown();
            this.services.clear();
            this.shutdownThreadPool();
        }
        return all_closed;
    }

    public Address getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    public boolean flushSupported() {
        return this.channel.flushSupported();
    }

    public boolean startFlush(boolean automatic_resume) {
        return this.channel.startFlush(automatic_resume);
    }

    public void stopFlush() {
        this.channel.stopFlush();
    }

    public boolean isConnected() {
        return this.channel.isConnected();
    }

    public void connect(String cluster_name) throws ChannelException {
        this.channel.connect(cluster_name);
    }

    public void open() throws ChannelException {
        this.channel.open();
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public Address getStateProvider(Address preferredTarget, String service_id) {
        Address result = null;
        List<Address> hosts = this.service_state.get(service_id);
        if (hosts != null && !hosts.isEmpty()) {
            result = hosts.contains(preferredTarget) ? preferredTarget : hosts.get(0);
        }
        return result;
    }

    private void sendServiceMessage(boolean synchronous, byte type, String service, Address host, boolean bypassFlush, byte[] payload, boolean oob) throws Exception {
        if (host == null) {
            host = this.getLocalAddress();
        }
        if (host == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("local_addr is null, cannot send ServiceInfo." + ServiceInfo.typeToString(type) + " message"));
            }
            return;
        }
        ServiceInfo si = new ServiceInfo(type, service, host, payload);
        MuxHeader hdr = new MuxHeader(si);
        Message service_msg = new Message();
        if (oob) {
            service_msg.setFlag((byte)1);
        }
        service_msg.putHeader(NAME, hdr);
        if (bypassFlush && this.channel.flushSupported()) {
            service_msg.putHeader("FLUSH", new FLUSH.FlushHeader(6));
        }
        this.channel.send(service_msg);
        if (synchronous) {
            this.service_ack_collector.reset(null, this.service_state.get(service));
            int size = this.service_ack_collector.size();
            long service_ack_collection_timeout = 2000L;
            long start = System.currentTimeMillis();
            try {
                this.service_ack_collector.waitForAllAcks(service_ack_collection_timeout);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("received all service ACKs (" + size + ")  in " + (System.currentTimeMillis() - start) + "ms"));
                }
            }
            catch (TimeoutException e) {
                log.warn((Object)("failed to collect all service ACKs (" + size + ") for " + service_msg + " after " + service_ack_collection_timeout + "ms, missing ACKs from " + this.service_ack_collector.printMissing() + " (received=" + this.service_ack_collector.printReceived() + "), local_addr=" + this.getLocalAddress()));
            }
        }
    }

    private Object handleStateRequest(Event evt) {
        String id;
        StateTransferInfo info = (StateTransferInfo)evt.getArg();
        String original_id = id = info.state_id;
        Address requester = info.target;
        try {
            int index = id.indexOf(SEPARATOR);
            if (index > -1) {
                info.state_id = id.substring(index + SEPARATOR_LEN);
                id = id.substring(0, index);
            } else {
                info.state_id = null;
            }
            MuxChannel mux_ch = (MuxChannel)this.services.get(id);
            if (mux_ch == null) {
                throw new IllegalArgumentException("State provider " + this.channel.getLocalAddress() + " does not have service with id " + id);
            }
            StateTransferInfo ret = (StateTransferInfo)this.passToMuxChannel(mux_ch, evt, this.fifo_queue, requester, id, true);
            if (ret != null) {
                ret.state_id = original_id;
            }
            return ret;
        }
        catch (Throwable ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"failed returning the application state, will return null", ex);
            }
            return new StateTransferInfo(null, original_id, 0L, null);
        }
    }

    private void handleStateResponse(Event evt) {
        String substate_id;
        String appl_id;
        StateTransferInfo info = (StateTransferInfo)evt.getArg();
        Address state_sender = info.target;
        String tmp = info.state_id;
        if (tmp == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("state is null, not passing up: " + info));
            }
            return;
        }
        int index = tmp.indexOf(SEPARATOR);
        if (index > -1) {
            appl_id = tmp.substring(0, index);
            substate_id = tmp.substring(index + SEPARATOR_LEN);
        } else {
            appl_id = tmp;
            substate_id = null;
        }
        MuxChannel mux_ch = (MuxChannel)this.services.get(appl_id);
        if (mux_ch == null) {
            log.error((Object)("State receiver " + this.channel.getLocalAddress() + " does not have service with id " + appl_id));
        } else {
            StateTransferInfo tmp_info = info.copy();
            tmp_info.state_id = substate_id;
            Event tmpEvt = new Event(evt.getType(), tmp_info);
            this.passToMuxChannel(mux_ch, tmpEvt, this.fifo_queue, state_sender, appl_id, false);
        }
    }

    private void handleServiceMessage(ServiceInfo info, Address sender) throws Exception {
        switch (info.type) {
            case 3: {
                this.handleServiceUp(info.service, info.host, true);
                this.ackServiceMessage(info, sender);
                break;
            }
            case 4: {
                this.handleServiceDown(info.service, info.host, true);
                this.ackServiceMessage(info, sender);
                break;
            }
            case 5: {
                this.handleServicesRsp(sender, info.state);
                break;
            }
            case 6: {
                this.service_ack_collector.ack(sender);
                break;
            }
            default: {
                if (!log.isErrorEnabled()) break;
                log.error((Object)("service request type " + info.type + " not known"));
            }
        }
    }

    private void ackServiceMessage(ServiceInfo info, Address sender) throws ChannelNotConnectedException, ChannelClosedException {
        Message ack = new Message(sender, null, null);
        ack.setFlag((byte)1);
        ServiceInfo si = new ServiceInfo(6, info.service, info.host, null);
        MuxHeader hdr = new MuxHeader(si);
        ack.putHeader(NAME, hdr);
        if (this.channel.isConnected()) {
            this.channel.send(ack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleServicesRsp(Address sender, byte[] state) throws Exception {
        Set s = (Set)Util.objectFromByteBuffer(state);
        Map<Address, Set<String>> map = this.service_responses;
        synchronized (map) {
            Set<String> tmp = this.service_responses.get(sender);
            if (tmp == null) {
                tmp = new HashSet<String>();
            }
            tmp.addAll(s);
            this.service_responses.put(sender, tmp);
            if (log.isTraceEnabled()) {
                log.trace((Object)("received service response: " + sender + "(" + s.toString() + ")"));
            }
            this.service_responses.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleServiceDown(String service, Address host, boolean received) {
        Address local_address;
        ArrayList<Address> hosts_copy;
        boolean removed = false;
        Map<String, List<Address>> map = this.service_state;
        synchronized (map) {
            List<Address> hosts = this.service_state.get(service);
            if (hosts == null) {
                return;
            }
            removed = hosts.remove(host);
            hosts_copy = new ArrayList<Address>(hosts);
        }
        if (removed) {
            View service_view = this.generateServiceView(hosts_copy);
            MuxChannel ch = (MuxChannel)this.services.get(service);
            if (ch != null && ch.isConnected()) {
                Event view_evt = new Event(6, service_view);
                this.passToMuxChannel(ch, view_evt, this.fifo_queue, null, service, false, true);
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("service " + service + " not found, cannot dispatch service view " + service_view));
            }
        }
        if ((local_address = this.getLocalAddress()) != null && host != null && host.equals(local_address)) {
            this.unregister(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleServiceUp(String service, Address host, boolean received) {
        ArrayList<Address> hosts_copy;
        boolean added = false;
        Map<String, List<Address>> map = this.service_state;
        synchronized (map) {
            List<Address> hosts = this.service_state.get(service);
            if (hosts == null) {
                hosts = new ArrayList<Address>();
                this.service_state.put(service, hosts);
            }
            if (!hosts.contains(host)) {
                hosts.add(host);
                added = true;
            }
            hosts_copy = new ArrayList<Address>(hosts);
        }
        if (added) {
            View service_view = this.generateServiceView(hosts_copy);
            MuxChannel ch = (MuxChannel)this.services.get(service);
            if (ch != null) {
                Event view_evt = new Event(6, service_view);
                this.passToMuxChannel(ch, view_evt, this.fifo_queue, null, service, false, true);
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("service " + service + " not found, cannot dispatch service view " + service_view));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMergeView(MergeView view) throws Exception {
        int num_members = view.size();
        HashMap<Address, Set<String>> copy = null;
        byte[] data = Util.objectToByteBuffer(new HashSet(this.services.keySet()));
        this.sendServiceMessage(false, (byte)5, null, this.channel.getLocalAddress(), true, data, true);
        Map<Address, Set<String>> map = this.service_responses;
        synchronized (map) {
            block7: {
                long start = System.currentTimeMillis();
                try {
                    for (long time_to_wait = this.service_response_timeout; time_to_wait > 0L && Multiplexer.numResponses(this.service_responses) < num_members; time_to_wait -= System.currentTimeMillis() - start) {
                        this.service_responses.wait(time_to_wait);
                    }
                    copy = new HashMap<Address, Set<String>>(this.service_responses);
                }
                catch (Exception ex) {
                    if (!log.isErrorEnabled()) break block7;
                    log.error((Object)("failed fetching a list of services from other members in the cluster, cannot handle merge view " + view), (Throwable)ex);
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("merging service state, my service_state: " + this.service_state + ", received responses: " + copy));
        }
        this.mergeServiceState(view, copy);
        this.service_responses.clear();
    }

    private static int numResponses(Map<Address, Set<String>> m) {
        int num = 0;
        Collection<Set<String>> values = m.values();
        Iterator<Set<String>> it = values.iterator();
        while (it.hasNext()) {
            if (it.next() == null) continue;
            ++num;
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeServiceState(MergeView view, Map<Address, Set<String>> copy) {
        HashSet<String> modified_services = new HashSet<String>();
        Map<String, List<Address>> map = this.service_state;
        synchronized (map) {
            for (Map.Entry<Address, Set<String>> entry : copy.entrySet()) {
                Address host = entry.getKey();
                Set<String> service_list = entry.getValue();
                if (service_list == null) continue;
                for (String service : service_list) {
                    boolean was_modified;
                    List<Address> my_services = this.service_state.get(service);
                    if (my_services == null) {
                        my_services = new ArrayList<Address>();
                        this.service_state.put(service, my_services);
                    }
                    if (!(was_modified = my_services.add(host))) continue;
                    modified_services.add(service);
                }
            }
        }
        for (String service : modified_services) {
            MuxChannel ch = (MuxChannel)this.services.get(service);
            List<Address> hosts = this.service_state.get(service);
            Vector<Address> membersCopy = new Vector<Address>(view.getMembers());
            membersCopy.retainAll(hosts);
            MergeView v = new MergeView(view.getVid(), membersCopy, view.getSubgroups());
            this.passToMuxChannel(ch, new Event(6, v), this.fifo_queue, null, service, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustServiceView(Address host) {
        Map<String, List<Address>> map = this.service_state;
        synchronized (map) {
            for (Map.Entry<String, List<Address>> entry : this.service_state.entrySet()) {
                Address local_address;
                String service = entry.getKey();
                List<Address> hosts = entry.getValue();
                if (hosts == null) continue;
                if (hosts.remove(host)) {
                    View service_view = this.generateServiceView(new ArrayList<Address>(hosts));
                    MuxChannel ch = (MuxChannel)this.services.get(service);
                    if (ch != null && ch.isConnected()) {
                        Event view_evt = new Event(6, service_view);
                        this.passToMuxChannel(ch, view_evt, this.fifo_queue, null, service, false, true);
                    } else if (log.isTraceEnabled()) {
                        log.trace((Object)("service " + service + " not found, cannot dispatch service view " + service_view));
                    }
                }
                if ((local_address = this.getLocalAddress()) == null || host == null || !host.equals(local_address)) continue;
                this.unregister(service);
            }
        }
    }

    private View generateServiceView(List<Address> hosts) {
        if (this.view == null) {
            Vector<Address> tmp = new Vector<Address>();
            tmp.add(this.getLocalAddress());
            this.view = new View(new ViewId(this.getLocalAddress()), tmp);
        }
        Vector<Address> members = new Vector<Address>(this.view.getMembers());
        members.retainAll(hosts);
        return new View(this.view.getVid(), members);
    }

    private Object passToMuxChannel(MuxChannel ch, Event evt, FIFOMessageQueue<String, Runnable> queue, Address sender, String dest, boolean block) {
        return this.passToMuxChannel(ch, evt, queue, sender, dest, block, false);
    }

    private Object passToMuxChannel(MuxChannel ch, Event evt, FIFOMessageQueue<String, Runnable> queue, Address sender, String dest, boolean block, boolean bypass_thread_pool) {
        if (this.thread_pool == null || bypass_thread_pool) {
            return ch.up(evt);
        }
        Task task = new Task(ch, evt, queue, sender, dest, block);
        ExecuteTask execute_task = new ExecuteTask(this.fifo_queue);
        try {
            this.fifo_queue.put(sender, dest, task);
            this.thread_pool.execute(execute_task);
            if (block) {
                try {
                    return task.exchanger.exchange(null);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    public void addServiceIfNotPresent(String id, MuxChannel ch) {
        this.services.putIfAbsent(id, ch);
    }

    static /* synthetic */ JChannel access$000(Multiplexer x0) {
        return x0.channel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExecuteTask
    implements Runnable {
        FIFOMessageQueue<String, Runnable> queue;

        public ExecuteTask(FIFOMessageQueue<String, Runnable> queue) {
            this.queue = queue;
        }

        @Override
        public void run() {
            try {
                Runnable task = this.queue.take();
                task.run();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Task
    implements Runnable {
        Exchanger<Object> exchanger;
        MuxChannel channel;
        Event evt;
        FIFOMessageQueue<String, Runnable> queue;
        Address sender;
        String dest;

        Task(MuxChannel channel, Event evt, FIFOMessageQueue<String, Runnable> queue, Address sender, String dest, boolean result_expected) {
            this.channel = channel;
            this.evt = evt;
            this.queue = queue;
            this.sender = sender;
            this.dest = dest;
            if (result_expected) {
                this.exchanger = new Exchanger();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object retval = this.channel.up(this.evt);
                if (this.exchanger != null) {
                    this.exchanger.exchange(retval);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.queue.done(this.sender, this.dest);
            }
        }
    }
}

