/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

public class CheapDateFormatter {
    static final long SECONDS = 1000L;
    static final long MINUTES = 60000L;
    static final long HOURS = 3600000L;
    static final long DAYS = 86400000L;
    static final long NORMAL_YEAR = 31536000000L;
    static final long LEAP_YEAR = 31622400000L;
    static final long FOURYEARS = 126230400000L;
    static final long END_OF_FIRST_YEAR = 31536000000L;
    static final long END_OF_SECOND_YEAR = 63158400000L;
    static final long END_OF_THIRD_YEAR = 94694400000L;
    static final int[] DAYS_IN_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final int FEBRUARY = 1;

    public static String formatDate(long l) {
        int n;
        boolean bl = false;
        long l2 = l / 126230400000L * 4L;
        long l3 = l % 126230400000L;
        l -= l2 / 4L * 126230400000L;
        l2 += 1970L;
        if (l3 >= 31536000000L) {
            ++l2;
            l -= 31536000000L;
        }
        if (l3 >= 63158400000L) {
            ++l2;
            l -= 31536000000L;
        }
        if (l3 >= 94694400000L) {
            ++l2;
            l -= 31622400000L;
        }
        if (l2 % 4L == 0L) {
            if (l2 % 100L == 0L && l2 % 400L == 0L) {
                bl = true;
            }
            bl = true;
        }
        long l4 = l / 86400000L + 1L;
        int n2 = 1;
        for (int i = 0; i < DAYS_IN_MONTH.length && l4 > (long)(n = bl && i == 1 ? 29 : DAYS_IN_MONTH[i]); l4 -= (long)n, ++i) {
            ++n2;
        }
        long l5 = (l %= 86400000L) / 3600000L;
        long l6 = (l %= 3600000L) / 60000L;
        long l7 = (l %= 60000L) / 1000L;
        return l2 + "-" + CheapDateFormatter.twoDigits(n2) + "-" + CheapDateFormatter.twoDigits(l4) + " " + CheapDateFormatter.twoDigits(l5) + ":" + CheapDateFormatter.twoDigits(l6) + ":" + CheapDateFormatter.twoDigits(l7) + "." + CheapDateFormatter.threeDigits(l %= 1000L) + " GMT";
    }

    private static String twoDigits(long l) {
        String string = l < 10L ? "0" + l : Long.toString(l);
        return string;
    }

    private static String threeDigits(long l) {
        String string = l < 10L ? "00" + l : (l < 100L ? "0" + l : Long.toString(l));
        return string;
    }
}

