/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.interceptors.PassivationInterceptorMBean;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.marshall.MethodCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PassivationInterceptor
extends Interceptor
implements PassivationInterceptorMBean {
    protected CacheLoader loader = null;
    private AtomicLong m_passivations = new AtomicLong(0L);

    @Override
    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.loader = cache.getCacheLoaderManager().getCacheLoader();
    }

    @Override
    public Object invoke(InvocationContext ctx) throws Throwable {
        block4: {
            MethodCall m = ctx.getMethodCall();
            if (m.getMethodId() == 8) {
                Object[] args = m.getArgs();
                Fqn fqn = (Fqn)args[0];
                try {
                    Map attributes = this.getNodeAttributes(fqn);
                    this.cache.getNotifier().notifyNodePassivated(fqn, true, attributes, ctx);
                    this.loader.put(fqn, attributes);
                    this.cache.getNotifier().notifyNodePassivated(fqn, false, Collections.emptyMap(), ctx);
                    if (this.getStatisticsEnabled() && this.configuration.getExposeManagementStatistics()) {
                        this.m_passivations.getAndIncrement();
                    }
                }
                catch (NodeNotLoadedException e) {
                    if (!this.log.isTraceEnabled()) break block4;
                    this.log.trace((Object)("Node " + fqn + " not loaded in memory; passivation skipped"));
                }
            }
        }
        return super.invoke(ctx);
    }

    @Override
    public long getPassivations() {
        return this.m_passivations.get();
    }

    @Override
    public void resetStatistics() {
        this.m_passivations.set(0L);
    }

    @Override
    public Map<String, Object> dumpStatistics() {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        retval.put("Passivations", this.m_passivations.get());
        return retval;
    }

    private Map getNodeAttributes(Fqn fqn) throws NodeNotLoadedException {
        if (fqn == null) {
            throw new NodeNotLoadedException();
        }
        NodeSPI n = this.cache.peek(fqn, true);
        if (n != null) {
            return n.getDataDirect();
        }
        throw new NodeNotLoadedException();
    }

    private static class NodeNotLoadedException
    extends Exception {
        private static final long serialVersionUID = -4078972305344328905L;

        private NodeNotLoadedException() {
        }
    }
}

