/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api.nodevalidity;

import org.jboss.cache.CacheImpl;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.api.nodevalidity.InvalidatedPessNodeValidityTest;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class InvalidatedOptNodeValidityTest
extends InvalidatedPessNodeValidityTest {
    public InvalidatedOptNodeValidityTest() {
        this.optimistic = true;
    }

    public void testTombstoneRevival() {
        this.modifier.put(this.parent, (Object)this.K, (Object)this.V);
        this.modifier.removeNode(this.parent);
        NodeSPI observerNode = (NodeSPI)this.observer.getRoot().getChild(this.parent);
        assert (observerNode == null) : "Should be removed";
        this.modifier.getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)new DefaultDataVersion(10L));
        this.modifier.put(this.parent, (Object)this.K, (Object)this.V);
        NodeSPI modifierNode = (NodeSPI)this.modifier.getRoot().getChild(this.parent);
        assert (modifierNode != null) : "Should not be null";
        assert (modifierNode.isValid()) : "No longer a tombstone";
        assert (((DefaultDataVersion)modifierNode.getVersion()).getRawVersion() == 10L) : "Version should be updated";
        observerNode = (NodeSPI)this.observer.getRoot().getChild(this.parent);
        assert (observerNode != null) : "Should not be null";
        assert (observerNode.isValid()) : "No longer a tombstone";
        assert (((DefaultDataVersion)observerNode.getVersion()).getRawVersion() == 10L) : "Version should be updated";
    }

    public void testTombstoneVersioningFailure() throws Exception {
        CacheImpl modifierImpl = (CacheImpl)this.modifier;
        CacheImpl observerImpl = (CacheImpl)this.observer;
        this.modifier.put(this.parent, (Object)this.K, (Object)this.V);
        assert (this.loader.get(this.parent) != null);
        assert (this.loader.get(this.parent).size() > 0);
        this.modifier.removeNode(this.parent);
        assert (modifierImpl.peek(this.parent, true, true) != null);
        assert (observerImpl.peek(this.parent, true, true) != null);
        assert (modifierImpl.peek(this.parent, false, false) == null);
        assert (observerImpl.peek(this.parent, false, false) == null);
        assert (this.loader.get(this.parent) == null);
        NodeSPI observerNode = (NodeSPI)this.observer.getRoot().getChild(this.parent);
        assert (observerNode == null) : "Should be removed";
        this.modifier.getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)new DefaultDataVersion(1L));
        try {
            this.modifier.put(this.parent, (Object)this.K, (Object)this.V);
            assert (false) : "Should have barfed!";
        }
        catch (RuntimeException expected) {
            // empty catch block
        }
        NodeSPI modifierNode = (NodeSPI)this.modifier.getRoot().getChild(this.parent);
        assert (modifierNode == null) : "Should be null";
        observerNode = (NodeSPI)this.observer.getRoot().getChild(this.parent);
        assert (observerNode == null) : "Should be null";
        NodeSPI modifierTombstone = modifierImpl.peek(this.parent, true, true);
        NodeSPI observerTombstone = observerImpl.peek(this.parent, true, true);
        assert (modifierTombstone != null) : "Tombstone should still exist";
        assert (observerTombstone != null) : "Tombstone should still exist";
        assert (!modifierTombstone.isValid()) : "Should not be valid";
        assert (!observerTombstone.isValid()) : "Should not be valid";
        assert (((DefaultDataVersion)modifierTombstone.getVersion()).getRawVersion() == 2L) : "Should retain versioning";
        assert (((DefaultDataVersion)observerTombstone.getVersion()).getRawVersion() == 2L) : "Should retain versioning";
    }
}

