/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.NodeLock;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class AcquireAllTest {
    CacheImpl cache = null;
    CacheImpl cache2;
    final Fqn FQN = Fqn.fromString((String)"/myNode");
    final String KEY = "key";
    final String VALUE = "value";

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cache != null) {
            this.cache.stop();
            this.cache.destroy();
            this.cache = null;
        }
    }

    public void testAcquireAll() throws Exception {
        Thread owner = Thread.currentThread();
        this.cache = this.createCache(Configuration.CacheMode.LOCAL, IsolationLevel.SERIALIZABLE);
        this.cache.put("/a/b/c", null);
        this.cache.put("/1/2/3", null);
        NodeSPI root = this.cache.getRoot();
        NodeLock lock = root.getLock();
        lock.acquireAll((Object)owner, 2000L, NodeLock.LockType.READ);
        lock.releaseAll((Object)owner);
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        lock.acquireAll((Object)owner, 2000L, NodeLock.LockType.WRITE);
        lock.releaseAll((Object)owner);
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    public void testAcquireAllReplicated() throws Exception {
        Thread owner = Thread.currentThread();
        this.cache2 = this.createCache(Configuration.CacheMode.REPL_ASYNC, IsolationLevel.SERIALIZABLE);
        this.cache2.put("/a/b/c", null);
        this.cache2.put("/1/2/3", null);
        this.cache = this.createCache(Configuration.CacheMode.REPL_ASYNC, IsolationLevel.SERIALIZABLE);
        NodeSPI root = this.cache.getRoot();
        NodeLock lock = root.getLock();
        lock.acquireAll((Object)owner, 2000L, NodeLock.LockType.READ);
        lock.releaseAll((Object)owner);
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
        lock.acquireAll((Object)owner, 2000L, NodeLock.LockType.WRITE);
        lock.releaseAll((Object)owner);
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    private CacheImpl createCache(Configuration.CacheMode mode, IsolationLevel level) throws Exception {
        CacheImpl c = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
        c.getConfiguration().setCacheMode(mode);
        c.getConfiguration().setIsolationLevel(level);
        c.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        c.create();
        c.start();
        return c;
    }
}

