/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.notifications;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.notifications.EventLog;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.notifications.event.EventImpl;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public class RemoteCacheListenerTest {
    protected boolean optLocking = false;
    private Cache<String, String> cache1;
    private Cache<String, String> cache2;
    private TransactionManager tm1;
    private TransactionManager tm2;
    private EventLog eventLog1 = new EventLog();
    private EventLog eventLog2 = new EventLog();
    private Fqn<String> fqn = Fqn.fromString((String)"/test");

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        Configuration c = new Configuration();
        c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        c.setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        if (this.optLocking) {
            c.setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        }
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        c.setFetchInMemoryState(false);
        c.setSyncCommitPhase(true);
        c.setSyncReplTimeout(60000L);
        CacheFactory instance = DefaultCacheFactory.getInstance();
        this.cache1 = instance.createCache(c);
        this.cache2 = instance.createCache(c.clone());
        this.eventLog1.events.clear();
        this.eventLog2.events.clear();
        this.cache1.addCacheListener((Object)this.eventLog1);
        this.cache2.addCacheListener((Object)this.eventLog2);
        this.tm1 = this.cache1.getConfiguration().getRuntimeConfig().getTransactionManager();
        this.tm2 = this.cache2.getConfiguration().getRuntimeConfig().getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TransactionManager tm = this.cache1.getConfiguration().getRuntimeConfig().getTransactionManager();
        if (tm != null && tm.getTransaction() != null) {
            try {
                tm.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((tm = this.cache2.getConfiguration().getRuntimeConfig().getTransactionManager()) != null && tm.getTransaction() != null) {
            try {
                tm.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cache1.stop();
        this.cache1.destroy();
        this.cache2.stop();
        this.cache2.destroy();
    }

    public void testCreation() throws Exception {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog2.events);
        this.cache1.put(this.fqn, (Object)"key", (Object)"value");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("key", "value");
        ArrayList<Event> expected = new ArrayList<Event>();
        if (this.optLocking) {
            expected.add((Event)new EventImpl(false, this.cache1, null, null, null, null, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        }
        expected.add((Event)new EventImpl(true, this.cache1, null, null, this.fqn, null, true, null, false, null, Event.Type.NODE_CREATED));
        expected.add((Event)new EventImpl(false, this.cache1, null, null, this.fqn, null, true, null, false, null, Event.Type.NODE_CREATED));
        expected.add((Event)new EventImpl(true, this.cache1, NodeModifiedEvent.ModificationType.PUT_DATA, Collections.emptyMap(), this.fqn, null, true, null, false, null, Event.Type.NODE_MODIFIED));
        expected.add((Event)new EventImpl(false, this.cache1, NodeModifiedEvent.ModificationType.PUT_DATA, data, this.fqn, null, true, null, false, null, Event.Type.NODE_MODIFIED));
        if (this.optLocking) {
            expected.add((Event)new EventImpl(false, this.cache1, null, null, null, null, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
            this.eventLog1.scrubImplicitTransactions();
            this.eventLog2.scrubImplicitTransactions();
        }
        AssertJUnit.assertEquals((String)"Local events not as expected", expected, this.eventLog1.events);
        this.setCache(this.cache2, expected);
        this.markOriginRemote(expected);
        AssertJUnit.assertEquals((String)"Remote events not as expected", expected, this.eventLog2.events);
        AssertJUnit.assertEquals((String)"value", (String)((String)this.cache1.get(this.fqn, (Object)"key")));
    }

    public void testOnlyModification() throws Exception {
        AssertJUnit.assertNull((Object)this.cache1.get(this.fqn, (Object)"key"));
        AssertJUnit.assertNull((Object)this.cache2.get(this.fqn, (Object)"key"));
        this.cache1.put(this.fqn, (Object)"key", (Object)"value");
        HashMap<String, String> oldData = new HashMap<String, String>();
        oldData.put("key", "value");
        AssertJUnit.assertEquals((String)"value", (String)((String)this.cache1.get(this.fqn, (Object)"key")));
        AssertJUnit.assertEquals((String)"value", (String)((String)this.cache2.get(this.fqn, (Object)"key")));
        this.eventLog1.events.clear();
        this.eventLog2.events.clear();
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog1.events);
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog2.events);
        this.cache1.put(this.fqn, (Object)"key", (Object)"value2");
        HashMap<String, String> newData = new HashMap<String, String>();
        newData.put("key", "value2");
        ArrayList<Event> expected = new ArrayList<Event>();
        if (this.optLocking) {
            expected.add((Event)new EventImpl(false, this.cache1, null, null, null, null, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        }
        expected.add((Event)new EventImpl(true, this.cache1, NodeModifiedEvent.ModificationType.PUT_DATA, oldData, this.fqn, null, true, null, false, null, Event.Type.NODE_MODIFIED));
        expected.add((Event)new EventImpl(false, this.cache1, NodeModifiedEvent.ModificationType.PUT_DATA, newData, this.fqn, null, true, null, false, null, Event.Type.NODE_MODIFIED));
        if (this.optLocking) {
            expected.add((Event)new EventImpl(false, this.cache1, null, null, null, null, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
            this.eventLog1.scrubImplicitTransactions();
            this.eventLog2.scrubImplicitTransactions();
        }
        AssertJUnit.assertEquals((String)"Local events not as expected", expected, this.eventLog1.events);
        this.setCache(this.cache2, expected);
        this.markOriginRemote(expected);
        AssertJUnit.assertEquals((String)"Remote events not as expected", expected, this.eventLog2.events);
    }

    public void testOnlyRemoval() throws Exception {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog2.events);
        this.cache1.put(this.fqn, (Object)"key", (Object)"value");
        HashMap<String, String> oldData = new HashMap<String, String>();
        oldData.put("key", "value");
        AssertJUnit.assertEquals((String)"value", (String)((String)this.cache1.get(this.fqn, (Object)"key")));
        AssertJUnit.assertEquals((String)"value", (String)((String)this.cache2.get(this.fqn, (Object)"key")));
        this.eventLog1.events.clear();
        this.eventLog2.events.clear();
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog1.events);
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog2.events);
        this.cache1.removeNode(this.fqn);
        ArrayList<Event> expected = new ArrayList<Event>();
        if (this.optLocking) {
            expected.add((Event)new EventImpl(false, this.cache1, null, null, null, null, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        }
        expected.add((Event)new EventImpl(true, this.cache1, null, oldData, this.fqn, null, true, null, false, null, Event.Type.NODE_REMOVED));
        expected.add((Event)new EventImpl(false, this.cache1, null, null, this.fqn, null, true, null, false, null, Event.Type.NODE_REMOVED));
        if (this.optLocking) {
            expected.add((Event)new EventImpl(false, this.cache1, null, null, null, null, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
            this.eventLog1.scrubImplicitTransactions();
            this.eventLog2.scrubImplicitTransactions();
        }
        AssertJUnit.assertEquals((String)"Local events not as expected", expected, this.eventLog1.events);
        this.setCache(this.cache2, expected);
        this.markOriginRemote(expected);
        AssertJUnit.assertEquals((String)"Remote events not as expected", expected, this.eventLog2.events);
        AssertJUnit.assertNull((String)"Should be null", (Object)this.cache1.getRoot().getChild(this.fqn));
        AssertJUnit.assertNull((String)"Should be null", (Object)this.cache2.getRoot().getChild(this.fqn));
    }

    public void testRemoveData() throws Exception {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog2.events);
        this.cache1.put(this.fqn, (Object)"key", (Object)"value");
        this.cache1.put(this.fqn, (Object)"key2", (Object)"value2");
        HashMap<String, String> oldData = new HashMap<String, String>();
        oldData.put("key", "value");
        oldData.put("key2", "value2");
        this.eventLog1.events.clear();
        this.eventLog2.events.clear();
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog1.events);
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog2.events);
        this.cache1.remove(this.fqn, (Object)"key2");
        HashMap<String, String> removed = new HashMap<String, String>();
        removed.put("key2", "value2");
        ArrayList<Event> expected = new ArrayList<Event>();
        if (this.optLocking) {
            expected.add((Event)new EventImpl(false, this.cache1, null, null, null, null, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        }
        expected.add((Event)new EventImpl(true, this.cache1, NodeModifiedEvent.ModificationType.REMOVE_DATA, oldData, this.fqn, null, true, null, false, null, Event.Type.NODE_MODIFIED));
        expected.add((Event)new EventImpl(false, this.cache1, NodeModifiedEvent.ModificationType.REMOVE_DATA, removed, this.fqn, null, true, null, false, null, Event.Type.NODE_MODIFIED));
        if (this.optLocking) {
            expected.add((Event)new EventImpl(false, this.cache1, null, null, null, null, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
            this.eventLog1.scrubImplicitTransactions();
            this.eventLog2.scrubImplicitTransactions();
        }
        AssertJUnit.assertEquals((String)"Local events not as expected", expected, this.eventLog1.events);
        this.setCache(this.cache2, expected);
        this.markOriginRemote(expected);
        AssertJUnit.assertEquals((String)"Remote events not as expected", expected, this.eventLog2.events);
    }

    public void testPutMap() throws Exception {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog2.events);
        HashMap<String, String> oldData = new HashMap<String, String>();
        oldData.put("key", "value");
        oldData.put("key2", "value2");
        AssertJUnit.assertNull((Object)this.cache1.getRoot().getChild(this.fqn));
        AssertJUnit.assertNull((Object)this.cache2.getRoot().getChild(this.fqn));
        this.eventLog1.events.clear();
        this.eventLog2.events.clear();
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog1.events);
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog2.events);
        this.cache1.put(this.fqn, oldData);
        ArrayList<Event> expected = new ArrayList<Event>();
        if (this.optLocking) {
            expected.add((Event)new EventImpl(false, this.cache1, null, null, null, null, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        }
        expected.add((Event)new EventImpl(true, this.cache1, null, null, this.fqn, null, true, null, false, null, Event.Type.NODE_CREATED));
        expected.add((Event)new EventImpl(false, this.cache1, null, null, this.fqn, null, true, null, false, null, Event.Type.NODE_CREATED));
        expected.add((Event)new EventImpl(true, this.cache1, NodeModifiedEvent.ModificationType.PUT_MAP, Collections.emptyMap(), this.fqn, null, true, null, false, null, Event.Type.NODE_MODIFIED));
        expected.add((Event)new EventImpl(false, this.cache1, NodeModifiedEvent.ModificationType.PUT_MAP, oldData, this.fqn, null, true, null, false, null, Event.Type.NODE_MODIFIED));
        if (this.optLocking) {
            expected.add((Event)new EventImpl(false, this.cache1, null, null, null, null, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
            this.eventLog1.scrubImplicitTransactions();
            this.eventLog2.scrubImplicitTransactions();
        }
        AssertJUnit.assertEquals((String)"Local events not as expected", expected, this.eventLog1.events);
        this.setCache(this.cache2, expected);
        this.markOriginRemote(expected);
        AssertJUnit.assertEquals((String)"Remote events not as expected", expected, this.eventLog2.events);
    }

    public void testMove() {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog2.events);
        Fqn newParent = Fqn.fromString((String)"/a");
        this.cache1.put(this.fqn, (Object)"key", (Object)"value");
        this.cache1.put(newParent, (Object)"key", (Object)"value");
        Node n1 = this.cache1.getRoot().getChild(this.fqn);
        Node n2 = this.cache1.getRoot().getChild(newParent);
        this.eventLog1.events.clear();
        this.eventLog2.events.clear();
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog1.events);
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog2.events);
        this.cache1.move(n1.getFqn(), n2.getFqn());
        Fqn newFqn = new Fqn(newParent, (Object[])new String[]{(String)this.fqn.getLastElement()});
        ArrayList<Event> expected = new ArrayList<Event>();
        if (this.optLocking) {
            expected.add((Event)new EventImpl(false, this.cache1, null, null, null, null, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        }
        expected.add((Event)new EventImpl(true, this.cache1, null, null, this.fqn, null, true, newFqn, false, null, Event.Type.NODE_MOVED));
        expected.add((Event)new EventImpl(false, this.cache1, null, null, this.fqn, null, true, newFqn, false, null, Event.Type.NODE_MOVED));
        if (this.optLocking) {
            expected.add((Event)new EventImpl(false, this.cache1, null, null, null, null, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
            this.eventLog1.scrubImplicitTransactions();
            this.eventLog2.scrubImplicitTransactions();
        }
        AssertJUnit.assertEquals((String)"Local events not as expected", expected, this.eventLog1.events);
        this.setCache(this.cache2, expected);
        this.markOriginRemote(expected);
        AssertJUnit.assertEquals((String)"Remote events not as expected", expected, this.eventLog2.events);
    }

    public void testTxCreationCommit() throws Exception {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog2.events);
        this.tm1.begin();
        Transaction tx = this.tm1.getTransaction();
        this.cache1.put(this.fqn, (Object)"key", (Object)"value");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("key", "value");
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add((Event)new EventImpl(false, this.cache1, null, null, null, tx, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        expected.add((Event)new EventImpl(true, this.cache1, null, null, this.fqn, tx, true, null, false, null, Event.Type.NODE_CREATED));
        expected.add((Event)new EventImpl(false, this.cache1, null, null, this.fqn, tx, true, null, false, null, Event.Type.NODE_CREATED));
        expected.add((Event)new EventImpl(true, this.cache1, NodeModifiedEvent.ModificationType.PUT_DATA, Collections.emptyMap(), this.fqn, tx, true, null, false, null, Event.Type.NODE_MODIFIED));
        expected.add((Event)new EventImpl(false, this.cache1, NodeModifiedEvent.ModificationType.PUT_DATA, data, this.fqn, tx, true, null, false, null, Event.Type.NODE_MODIFIED));
        AssertJUnit.assertEquals(expected, this.eventLog1.events);
        AssertJUnit.assertTrue((boolean)this.eventLog2.events.isEmpty());
        this.tm1.commit();
        expected.add((Event)new EventImpl(false, this.cache1, null, null, null, tx, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
        AssertJUnit.assertEquals(expected, this.eventLog1.events);
        this.setCache(this.cache2, expected);
        this.markOriginRemote(expected);
        this.scrubTransactions(expected);
        this.eventLog2.scrubImplicitTransactions();
        AssertJUnit.assertEquals(expected, this.eventLog2.events);
        AssertJUnit.assertEquals((String)"value", (String)((String)this.cache1.get(this.fqn, (Object)"key")));
        AssertJUnit.assertEquals((String)"value", (String)((String)this.cache2.get(this.fqn, (Object)"key")));
    }

    public void testTxCreationRollback() throws Exception {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog2.events);
        this.tm1.begin();
        Transaction tx = this.tm1.getTransaction();
        this.cache1.put(this.fqn, (Object)"key", (Object)"value");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("key", "value");
        ArrayList<EventImpl> expected = new ArrayList<EventImpl>();
        expected.add(new EventImpl(false, this.cache1, null, null, null, tx, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        expected.add(new EventImpl(true, this.cache1, null, null, this.fqn, tx, true, null, false, null, Event.Type.NODE_CREATED));
        expected.add(new EventImpl(false, this.cache1, null, null, this.fqn, tx, true, null, false, null, Event.Type.NODE_CREATED));
        expected.add(new EventImpl(true, this.cache1, NodeModifiedEvent.ModificationType.PUT_DATA, Collections.emptyMap(), this.fqn, tx, true, null, false, null, Event.Type.NODE_MODIFIED));
        expected.add(new EventImpl(false, this.cache1, NodeModifiedEvent.ModificationType.PUT_DATA, data, this.fqn, tx, true, null, false, null, Event.Type.NODE_MODIFIED));
        AssertJUnit.assertEquals(expected, this.eventLog1.events);
        AssertJUnit.assertTrue((boolean)this.eventLog2.events.isEmpty());
        this.tm1.rollback();
        expected.add(new EventImpl(false, this.cache1, null, null, null, tx, true, null, false, null, Event.Type.TRANSACTION_COMPLETED));
        AssertJUnit.assertEquals(expected, this.eventLog1.events);
        AssertJUnit.assertTrue((boolean)this.eventLog2.events.isEmpty());
        AssertJUnit.assertNull((Object)this.cache1.get(this.fqn, (Object)"key"));
        AssertJUnit.assertNull((Object)this.cache2.get(this.fqn, (Object)"key"));
    }

    public void testTxOnlyModification() throws Exception {
        AssertJUnit.assertNull((Object)this.cache1.get(this.fqn, (Object)"key"));
        AssertJUnit.assertNull((Object)this.cache2.get(this.fqn, (Object)"key"));
        this.cache1.put(this.fqn, (Object)"key", (Object)"value");
        HashMap<String, String> oldData = new HashMap<String, String>();
        oldData.put("key", "value");
        AssertJUnit.assertEquals((String)"value", (String)((String)this.cache1.get(this.fqn, (Object)"key")));
        AssertJUnit.assertEquals((String)"value", (String)((String)this.cache2.get(this.fqn, (Object)"key")));
        this.eventLog1.events.clear();
        this.eventLog2.events.clear();
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog1.events);
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog2.events);
        this.tm1.begin();
        Transaction tx = this.tm1.getTransaction();
        HashMap<String, String> newData = new HashMap<String, String>();
        newData.put("key", "value2");
        this.cache1.put(this.fqn, (Object)"key", (Object)"value2");
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add((Event)new EventImpl(false, this.cache1, null, null, null, tx, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        expected.add((Event)new EventImpl(true, this.cache1, NodeModifiedEvent.ModificationType.PUT_DATA, oldData, this.fqn, tx, true, null, false, null, Event.Type.NODE_MODIFIED));
        expected.add((Event)new EventImpl(false, this.cache1, NodeModifiedEvent.ModificationType.PUT_DATA, newData, this.fqn, tx, true, null, false, null, Event.Type.NODE_MODIFIED));
        AssertJUnit.assertEquals(expected, this.eventLog1.events);
        AssertJUnit.assertEquals((String)"Events log should be empty until commit time", (int)0, (int)this.eventLog2.events.size());
        this.tm1.commit();
        expected.add((Event)new EventImpl(false, this.cache1, null, null, null, tx, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
        AssertJUnit.assertEquals(expected, this.eventLog1.events);
        this.setCache(this.cache2, expected);
        this.markOriginRemote(expected);
        this.scrubTransactions(expected);
        this.eventLog2.scrubImplicitTransactions();
        AssertJUnit.assertEquals(expected, this.eventLog2.events);
    }

    public void testTxOnlyRemoval() throws Exception {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog2.events);
        this.cache1.put(this.fqn, (Object)"key", (Object)"value");
        HashMap<String, String> oldData = new HashMap<String, String>();
        oldData.put("key", "value");
        AssertJUnit.assertEquals((String)"value", (String)((String)this.cache1.get(this.fqn, (Object)"key")));
        AssertJUnit.assertEquals((String)"value", (String)((String)this.cache2.get(this.fqn, (Object)"key")));
        this.eventLog1.events.clear();
        this.eventLog2.events.clear();
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog1.events);
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog2.events);
        this.tm1.begin();
        Transaction tx = this.tm1.getTransaction();
        this.cache1.removeNode(this.fqn);
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add((Event)new EventImpl(false, this.cache1, null, null, null, tx, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        expected.add((Event)new EventImpl(true, this.cache1, null, oldData, this.fqn, tx, true, null, false, null, Event.Type.NODE_REMOVED));
        expected.add((Event)new EventImpl(false, this.cache1, null, null, this.fqn, tx, true, null, false, null, Event.Type.NODE_REMOVED));
        AssertJUnit.assertEquals(expected, this.eventLog1.events);
        AssertJUnit.assertEquals((String)"Events log should be empty until commit time", (int)0, (int)this.eventLog2.events.size());
        this.tm1.commit();
        expected.add((Event)new EventImpl(false, this.cache1, null, null, null, tx, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
        AssertJUnit.assertEquals(expected, this.eventLog1.events);
        this.setCache(this.cache2, expected);
        this.markOriginRemote(expected);
        this.scrubTransactions(expected);
        this.eventLog2.scrubImplicitTransactions();
        AssertJUnit.assertEquals(expected, this.eventLog2.events);
        AssertJUnit.assertNull((String)"Should be null", (Object)this.cache1.getRoot().getChild(this.fqn));
        AssertJUnit.assertNull((String)"Should be null", (Object)this.cache2.getRoot().getChild(this.fqn));
    }

    public void testTxRemoveData() throws Exception {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog2.events);
        this.cache1.put(this.fqn, (Object)"key", (Object)"value");
        this.cache1.put(this.fqn, (Object)"key2", (Object)"value2");
        HashMap<String, String> oldData = new HashMap<String, String>();
        oldData.put("key", "value");
        oldData.put("key2", "value2");
        this.eventLog1.events.clear();
        this.eventLog2.events.clear();
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog1.events);
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog2.events);
        this.tm1.begin();
        Transaction tx = this.tm1.getTransaction();
        HashMap<String, String> removed = new HashMap<String, String>();
        removed.put("key2", "value2");
        this.cache1.remove(this.fqn, (Object)"key2");
        LinkedList<Event> expected = new LinkedList<Event>();
        expected.add((Event)new EventImpl(false, this.cache1, null, null, null, tx, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        expected.add((Event)new EventImpl(true, this.cache1, NodeModifiedEvent.ModificationType.REMOVE_DATA, oldData, this.fqn, tx, true, null, false, null, Event.Type.NODE_MODIFIED));
        expected.add((Event)new EventImpl(false, this.cache1, NodeModifiedEvent.ModificationType.REMOVE_DATA, removed, this.fqn, tx, true, null, false, null, Event.Type.NODE_MODIFIED));
        AssertJUnit.assertEquals(expected, this.eventLog1.events);
        AssertJUnit.assertEquals((String)"Events log should be empty until commit time", (int)0, (int)this.eventLog2.events.size());
        this.tm1.commit();
        expected.add((Event)new EventImpl(false, this.cache1, null, null, null, tx, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
        AssertJUnit.assertEquals(expected, this.eventLog1.events);
        this.setCache(this.cache2, expected);
        this.markOriginRemote(expected);
        this.scrubTransactions(expected);
        this.eventLog2.scrubImplicitTransactions();
        AssertJUnit.assertEquals(expected, this.eventLog2.events);
    }

    public void testTxMove() throws Exception {
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog2.events);
        Fqn newParent = Fqn.fromString((String)"/a");
        this.cache1.put(this.fqn, (Object)"key", (Object)"value");
        this.cache1.put(newParent, (Object)"key", (Object)"value");
        Node n1 = this.cache1.getRoot().getChild(this.fqn);
        Node n2 = this.cache1.getRoot().getChild(newParent);
        this.eventLog1.events.clear();
        this.eventLog2.events.clear();
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog1.events);
        AssertJUnit.assertEquals((String)"Event log should be empty", Collections.emptyList(), this.eventLog2.events);
        this.tm1.begin();
        Transaction tx = this.tm1.getTransaction();
        Fqn newFqn = new Fqn(newParent, (Object[])new String[]{(String)this.fqn.getLastElement()});
        this.cache1.move(n1.getFqn(), n2.getFqn());
        ArrayList<Event> expected = new ArrayList<Event>();
        expected.add((Event)new EventImpl(false, this.cache1, null, null, null, tx, true, null, false, null, Event.Type.TRANSACTION_REGISTERED));
        expected.add((Event)new EventImpl(true, this.cache1, null, null, this.fqn, tx, true, newFqn, false, null, Event.Type.NODE_MOVED));
        expected.add((Event)new EventImpl(false, this.cache1, null, null, this.fqn, tx, true, newFqn, false, null, Event.Type.NODE_MOVED));
        AssertJUnit.assertEquals(expected, this.eventLog1.events);
        AssertJUnit.assertEquals((String)"Events log should be empty until commit time", (int)0, (int)this.eventLog2.events.size());
        this.tm1.commit();
        expected.add((Event)new EventImpl(false, this.cache1, null, null, null, tx, true, null, true, null, Event.Type.TRANSACTION_COMPLETED));
        AssertJUnit.assertEquals(expected, this.eventLog1.events);
        this.setCache(this.cache2, expected);
        this.markOriginRemote(expected);
        this.scrubTransactions(expected);
        this.eventLog2.scrubImplicitTransactions();
        AssertJUnit.assertEquals(expected, this.eventLog2.events);
    }

    private void setCache(Cache<String, String> c, List<Event> l) {
        for (Event e : l) {
            ((EventImpl)e).setCache(c);
        }
    }

    private void markOriginRemote(List<Event> l) {
        for (Event e : l) {
            ((EventImpl)e).setOriginLocal(false);
        }
    }

    private void scrubTransactions(List<Event> l) {
        for (Event e : l) {
            ((EventImpl)e).setTransaction(null);
        }
    }
}

