/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.cache.pojo;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.pojo.test.ArrayObject;
import org.jboss.cache.pojo.test.Person;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Basic PojoCache test case.
 *
 * @author Ben Wang
 */
@Test(groups = {"functional"})
public class ArrayTest 
{
   Log log = LogFactory.getLog(ArrayTest.class);
   PojoCache cache_;

   @BeforeMethod(alwaysRun = true)
   protected void setUp() throws Exception
   {
      log.info("setUp() ....");
      String configFile = "META-INF/local-service.xml";
      boolean toStart = false;
      cache_ = PojoCacheFactory.createCache(configFile, toStart);
      cache_.start();
   }

   @AfterMethod(alwaysRun = true)
   protected void tearDown() throws Exception
   {
      cache_.stop();
   }

   public void testSimple() throws Exception
   {
      log.info("testSimple() ....");
      ArrayObject ao = new ArrayObject();
      Person joe = new Person();
      joe.setName("Joe");
      joe.setAge(19);

      Person ben = new Person();
      ben.setName("Ben");
      ben.setAge(19);

      ao.setPerson(0, joe);

      cache_.attach("ao", ao);

      // TODO This should trigger a write on team but instead it does a read only. Why?
      ao.setPerson(1, ben);

   }




}
