/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.collection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.AspectManager;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.pointcut.ast.ParseException;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.aop.proxy.ClassProxyFactory;
import org.jboss.aop.util.MethodHashing;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.PojoCacheException;
import org.jboss.cache.pojo.collection.CachedListAbstract;
import org.jboss.cache.pojo.collection.CachedMapImpl;
import org.jboss.cache.pojo.collection.CachedSetImpl;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.interceptors.dynamic.AbstractCollectionInterceptor;
import org.jboss.cache.pojo.interceptors.dynamic.CachedListInterceptor;
import org.jboss.cache.pojo.interceptors.dynamic.CachedMapInterceptor;
import org.jboss.cache.pojo.interceptors.dynamic.CachedSetInterceptor;
import org.jboss.cache.pojo.util.AopUtil;

public class CollectionInterceptorUtil {
    private static Log log = LogFactory.getLog((String)CollectionInterceptorUtil.class.getName());

    private static ClassProxy createProxy(Class clazz, AbstractCollectionInterceptor interceptor) throws Exception {
        ClassProxy result = ClassProxyFactory.newInstance((Class)clazz);
        InstanceAdvisor advisor = result._getInstanceAdvisor();
        advisor.appendInterceptor((Interceptor)interceptor);
        try {
            String bindName = clazz.getName() + ".toString";
            LinkedHashMap bindings = AspectManager.instance().getBindings();
            if (((HashMap)bindings).get(bindName) == null) {
                String bind = null;
                if (interceptor instanceof CachedListInterceptor) {
                    bind = "execution(public String " + CachedListAbstract.class.getName() + "->toString())";
                } else if (interceptor instanceof CachedSetInterceptor) {
                    bind = "execution(public String " + CachedSetImpl.class.getName() + "->toString())";
                } else if (interceptor instanceof CachedMapInterceptor) {
                    bind = "execution(public String " + CachedMapImpl.class.getName() + "->toString())";
                } else {
                    throw new IllegalStateException("CollectionInterceptorUtil.createProxy(). Non Collection interceptor" + interceptor);
                }
                AdviceBinding bindingm = new AdviceBinding(bindName, bind, null);
                AspectManager.instance().addBinding(bindingm);
            }
        }
        catch (ParseException e) {
            throw new PojoCacheException("PojoUtil._attachInterceptor(): can't parse the field binding: " + (Object)((Object)e));
        }
        return result;
    }

    public static ClassProxy createMapProxy(PojoCacheImpl cache, Fqn fqn, Class clazz, Map obj) throws Exception {
        return CollectionInterceptorUtil.createProxy(clazz, new CachedMapInterceptor(cache, fqn, clazz, obj));
    }

    public static ClassProxy createListProxy(PojoCacheImpl cache, Fqn fqn, Class clazz, List obj) throws Exception {
        return CollectionInterceptorUtil.createProxy(clazz, new CachedListInterceptor(cache, fqn, clazz, obj));
    }

    public static ClassProxy createSetProxy(PojoCacheImpl cache, Fqn fqn, Class clazz, Set obj) throws Exception {
        return CollectionInterceptorUtil.createProxy(clazz, new CachedSetInterceptor(cache, fqn, clazz, obj));
    }

    public static AbstractCollectionInterceptor getInterceptor(ClassProxy proxy) {
        InstanceAdvisor advisor = proxy._getInstanceAdvisor();
        return (AbstractCollectionInterceptor)AopUtil.findCollectionInterceptor(advisor);
    }

    public static Map getMethodMap(Class clazz) {
        HashMap result = ClassProxyFactory.getMethodMap((String)clazz.getName());
        if (result == null) {
            try {
                ClassProxyFactory.newInstance((Class)clazz);
            }
            catch (Exception e) {
                throw new PojoCacheException(e);
            }
            result = ClassProxyFactory.getMethodMap((String)clazz.getName());
        }
        return result;
    }

    public static Map getManagedMethods(Class clazz) {
        Method tostring = null;
        try {
            tostring = Object.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new PojoCacheException(e);
        }
        HashMap<Long, Method> managedMethods = new HashMap<Long, Method>();
        try {
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                long hash = MethodHashing.methodHash((Method)methods[i]);
                managedMethods.put(hash, methods[i]);
            }
            long hash = MethodHashing.methodHash((Method)tostring);
            managedMethods.put(hash, tostring);
        }
        catch (Exception ignored) {
            log.trace((Object)ignored, (Throwable)ignored);
        }
        return managedMethods;
    }

    private static boolean skipVerify(Method method) {
        String name = method.getName();
        Class<?>[] types = method.getParameterTypes();
        return "toString".equals(name) && types.length == 0;
    }

    public static Object invoke(Invocation invocation, AbstractCollectionInterceptor interceptor, Object impl, Map methodMap, Map managedMethods) throws Throwable {
        try {
            if (invocation instanceof MethodInvocation) {
                Object target;
                MethodInvocation methodInvocation = (MethodInvocation)invocation;
                Long methodHash = methodInvocation.getMethodHash();
                Method method = (Method)managedMethods.get(methodHash);
                if (log.isTraceEnabled() && method != null) {
                    log.trace((Object)("invoke(): method intercepted " + method.getName()));
                }
                Object[] args = methodInvocation.getArguments();
                if (method != null) {
                    if (!CollectionInterceptorUtil.skipVerify(method)) {
                        interceptor.verifyAttached(impl);
                    }
                    return method.invoke(impl, args);
                }
                method = methodInvocation.getMethod();
                if (method == null) {
                    method = (Method)methodMap.get(methodHash);
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("invoke(): non-managed method: " + method.toString()));
                }
                if ((target = methodInvocation.getTargetObject()) == null) {
                    throw new PojoCacheException("CollectionInterceptorUtil.invoke(): targetObject is null. Can't invoke " + method.toString());
                }
                return method.invoke(target, args);
            }
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            if (e.getTargetException() != null) {
                throw e.getTargetException();
            }
            throw e;
        }
        return invocation.invokeNext();
    }
}

