/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.IN;
import java.util.Iterator;

public class MemoryBudget
implements EnvConfigObserver {
    public static final int LONG_OVERHEAD = 16;
    public static final int BYTE_ARRAY_OVERHEAD = 12;
    public static final int OBJECT_OVERHEAD = 8;
    public static final int ARRAY_ITEM_OVERHEAD = 4;
    public static final int HASHMAP_OVERHEAD = 120;
    public static final int HASHMAP_ENTRY_OVERHEAD = 24;
    public static final int HASHSET_OVERHEAD = 130;
    public static final int HASHSET_ENTRY_OVERHEAD = 24;
    public static final int TWOHASHMAPS_OVERHEAD = 240;
    public static final int LN_OVERHEAD = 24;
    public static final int BIN_FIXED_OVERHEAD = 464;
    public static final int DIN_FIXED_OVERHEAD = 376;
    public static final int DBIN_FIXED_OVERHEAD = 480;
    public static final int IN_FIXED_OVERHEAD = 305;
    public static final int KEY_OVERHEAD = 32;
    public static final int LSN_SIZE = 8;
    public static final int LOCK_OVERHEAD = 32;
    public static final int LOCKINFO_OVERHEAD = 16;
    public static final int TXN_OVERHEAD = 160;
    public static final int CHECKPOINT_REFERENCE_SIZE = 56;
    private static final long MIN_MAX_MEMORY_SIZE = 1024L;
    private static final long N_64MB = 0x4000000L;
    private long cacheMemoryUsage;
    private long maxMemory;
    private long logBufferBudget;
    private long treeBudget;
    private long inOverhead;
    private long binOverhead;
    private long dinOverhead;
    private long dbinOverhead;
    private EnvironmentImpl envImpl;
    static final /* synthetic */ boolean $assertionsDisabled;

    MemoryBudget(EnvironmentImpl envImpl, DbConfigManager configManager) throws DatabaseException {
        this.envImpl = envImpl;
        envImpl.addConfigObserver(this);
        this.reset(configManager);
        this.inOverhead = IN.computeOverhead(configManager);
        this.binOverhead = BIN.computeOverhead(configManager);
        this.dinOverhead = DIN.computeOverhead(configManager);
        this.dbinOverhead = DBIN.computeOverhead(configManager);
    }

    public void envConfigUpdate(DbConfigManager configManager) throws DatabaseException {
        long oldLogBufferBudget = this.logBufferBudget;
        this.reset(configManager);
        if (oldLogBufferBudget != this.logBufferBudget) {
            this.envImpl.getLogManager().resetPool(configManager);
        }
    }

    private void reset(DbConfigManager configManager) throws DatabaseException {
        long newLogBufferBudget;
        long newMaxMemory = configManager.getLong(EnvironmentParams.MAX_MEMORY);
        long jvmMemory = MemoryBudget.getRuntimeMaxMemory();
        if (newMaxMemory != 0L) {
            if (jvmMemory < newMaxMemory) {
                throw new IllegalArgumentException(EnvironmentParams.MAX_MEMORY.getName() + " has a value of " + newMaxMemory + " but the JVM is only configured for " + jvmMemory + ". Consider using je.maxMemoryPercent.");
            }
            if (newMaxMemory < 1024L) {
                throw new IllegalArgumentException(EnvironmentParams.MAX_MEMORY.getName() + " is " + newMaxMemory + " which less than the minimum: " + 1024L);
            }
        } else {
            if (jvmMemory == Long.MAX_VALUE) {
                jvmMemory = 0x4000000L;
            }
            int maxMemoryPercent = configManager.getInt(EnvironmentParams.MAX_MEMORY_PERCENT);
            newMaxMemory = (long)maxMemoryPercent * jvmMemory / 100L;
        }
        if ((newLogBufferBudget = configManager.getLong(EnvironmentParams.LOG_MEM_SIZE)) == 0L) {
            newLogBufferBudget = newMaxMemory >> 4;
        } else if (newLogBufferBudget > newMaxMemory / 2L) {
            newLogBufferBudget = newMaxMemory / 2L;
        }
        int numBuffers = configManager.getInt(EnvironmentParams.NUM_LOG_BUFFERS);
        long startingBufferSize = newLogBufferBudget / (long)numBuffers;
        int logBufferSize = configManager.getInt(EnvironmentParams.LOG_BUFFER_MAX_SIZE);
        if (startingBufferSize > (long)logBufferSize) {
            startingBufferSize = logBufferSize;
            newLogBufferBudget = (long)numBuffers * startingBufferSize;
        }
        this.maxMemory = newMaxMemory;
        this.logBufferBudget = newLogBufferBudget;
        this.treeBudget = newMaxMemory - newLogBufferBudget;
    }

    public static long getRuntimeMaxMemory() {
        String jvmVersion;
        if ("Mac OS X".equals(System.getProperty("os.name")) && (jvmVersion = System.getProperty("java.version")) != null && jvmVersion.startsWith("1.4.2")) {
            return Long.MAX_VALUE;
        }
        return Runtime.getRuntime().maxMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initCacheMemoryUsage() throws DatabaseException {
        long totalSize = 0L;
        INList inList = this.envImpl.getInMemoryINs();
        inList.latchMajor();
        try {
            Iterator iter = inList.iterator();
            while (iter.hasNext()) {
                IN in = (IN)iter.next();
                long size = in.getInMemorySize();
                totalSize += size;
            }
        }
        finally {
            inList.releaseMajorLatch();
        }
        if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
            throw new AssertionError();
        }
        this.cacheMemoryUsage = totalSize;
    }

    public void updateCacheMemoryUsage(long increment) {
        this.cacheMemoryUsage += increment;
        if (this.cacheMemoryUsage > this.treeBudget) {
            this.envImpl.alertEvictor();
        }
    }

    public long accumulateNewUsage(IN in, long newSize) {
        return in.getInMemorySize() + newSize;
    }

    public void refreshCacheMemoryUsage(long newSize) {
        this.cacheMemoryUsage = newSize;
    }

    public long getCacheMemoryUsage() {
        return this.cacheMemoryUsage;
    }

    public long getLogBufferBudget() {
        return this.logBufferBudget;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getTreeBudget() {
        return this.treeBudget;
    }

    public long getINOverhead() {
        return this.inOverhead;
    }

    public long getBINOverhead() {
        return this.binOverhead;
    }

    public long getDINOverhead() {
        return this.dinOverhead;
    }

    public long getDBINOverhead() {
        return this.dbinOverhead;
    }

    void loadStats(StatsConfig config, EnvironmentStats stats) {
        stats.setCacheDataBytes(this.getCacheMemoryUsage());
    }

    static {
        $assertionsDisabled = !MemoryBudget.class.desiredAssertionStatus();
    }
}

